#ifdef	RCSIDENT
static char *RCSid = "$Header: help.c,v 1.4 87/10/13 10:41:03 notes Exp $";
#endif	RCSIDENT

/* nfhelp -- provide help-function support for notesfiles
**
** External wrapper for help() function:
**	prompts the user for what he'd like to learn about
**	gets help from (the argument) help file name
**	interprets help() return status
*/

#include <stdio.h>
#include "parms.h"
#include "structs.h"
#ifdef SYSV
#   include <string.h>
#else
#   include <strings.h>
#endif /* SYSV */
#include <errno.h>
extern int errno;

/* Exit status returned by help() */
#define	FOUND		0	/* found the keyword */
#define	NOTFOUND	1	/* didn't find the keyword */
#define	ERROR		(-1)	/* didn't find the help file */


nfhelp(helpfile)	/* notesfile help wrapper */
	char *helpfile;	/* file containing help info */
{
	char helppath[WDLEN];
	char keyword[BUFLEN];
	int i;
	int status;	/* returned by help() */

	sprintf(helppath, "%s/help/%s", libdir, helpfile);

askuser:
	prompt("Press RETURN for a command summary.\nHelp on which topic?  ");
	i = gline(keyword, sizeof keyword);	/* get keyword */
	keyword[i] = '\n';	/* put back the newline, sigh */
	keyword[++i] = '\0';	/* terminate the string */
	printf("\n");

	switch (status = help(keyword, helppath))	/* print help */
	{
	case FOUND:	/* success */
		break;
	case NOTFOUND:	/* failure */
		keyword[--i] = '\0';	/* shoot newline, yow! */
		printf("Sorry, no help for `%s'; press `?' for general help.\n",
			keyword);
		break;
	case ERROR:	/* dismal failure! */
		warn("Sorry, no help file \"%s\"\n", helppath);
		break;
	default:
		warn("help(%d): can't happen", status);
		break;
	}

	/* imitate wfchar(), except allow rapid re-help */
	printf("--Press `?' to get more help, or another key to return to notes--");
	switch (gchar())
	{
		case '?':
		case 'h':
			goto askuser;
	}

	return i;
}


/* help -- help subsystem that understands defined keywords
**
** Looks for the desired keyword in the help file at runtime, so you
** can give extra help or supply local customizations by merely editing
** the help file.
**
** The original (single-file) idea and algorithm is by John D. Johnson,
** Hewlett-Packard Company.  Thanx and a tip of the Hatlo hat!
**
** The help file looks like (the question marks are really in column 1):
** 
** 	?topic
** 	This line is printed when the user wants help on "topic".
** 	?keyword
** 	?Keyword
** 	?KEYWORD
** 	These lines will be printed on the screen if the user wanted
** 	help on "keyword", "Keyword", or "KEYWORD".  No casefolding is
**	done on the keywords.
** 	?subject
** 	?alias
** 	This line is printed for help on "subject" and "alias".
** 	?
**	??
** 	Since there is a null keyword for this line, this section
** 	is printed when the user wants general help (when a help
** 	keyword isn't given).  A command summary is usually here.
**	Notice that the null keyword is equivalent to a "?" keyword
**	here, because of the '?' and '??' topic lines above.
** 	?last-subject
** 	Note that help sections are terminated by the start of the next
** 	'?' entry or by EOF.  So you can't have a leading '?' on a line
** 	of any help section.
*/

#define	KEYFLAG	'?'	/* leading char in help file topic lines */
#define	SAME	0	/* for strcmp() */

/*
** Calling sequence:
**	int result;		# 0 == success
**	char *keyword;		# topic to give help on
**	char *pathname;		# path of help file
**	result = help(keyword, pathname);
** Sample:
**	cmd = "search\n";
**	helpfile = "/usr/local/lib/program/program.help";
**	if (help(cmd, helpfile) != 0)
**		printf("Sorry, no help for %s", cmd);
*/
#ifdef	WDLEN
#  define	PATHSIZE	WDLEN
#else
#  define	PATHSIZE	BUFSIZ
#endif

help(keyword, path)	/* print a help message */
	char *keyword;	/* on this topic */
	char *path;	/* from this file */
{
	static char oldpath[PATHSIZE];	/* previous help file */
	char *oldpathp = oldpath;	/* pointer to same */

	static FILE *helpfp = NULL;
	FILE *fopen();

	char buf[BUFSIZ];	/* line from help file */
	char *bufp = buf;	/* pointer to same */
	char *bufkeyp = bufp + 1;	/* start of key in help line */

	oldpath[0] = '\0';
/*
** Open the help file if necessary (say, 1st time we enter this routine,
** or if the help file changes from the last time we were called).
*/
	errno = 0;
	if (strcmp(oldpathp, path) == SAME)
		rewind(helpfp);	/* start at the beginning each time */
	else
	{	/* first time the user asked for help using this file */
		if ((helpfp = fopen(path, "r")) == NULL)
		{	/* can't open help file, so error exit */
			perror(path);
			return ERROR;
		}
		/* save the new path in oldpath */
		if (strlen(path) < sizeof oldpath)
			strcpy(oldpathp, path);
		else
		{	/* not enough room in oldpath, sigh */
			strncpy(oldpathp, path, sizeof oldpath);
			oldpath[sizeof oldpath] = (char)NULL;
		}
	}

/*
** The correct help file is open.  Look in there for the keyword.
*/
	while (fgets(buf, sizeof buf, helpfp) != NULL)
	{	/*
		** If we find the keyword:
		**	skip to the first non-keyword line
		**	print lines until you find another keyword line or EOF
		**	return success
		*/
		if (buf[0] == KEYFLAG && strcmp(keyword, bufkeyp) == SAME)
		{	/* found the key */
			while (fgets(buf, sizeof buf, helpfp) != NULL
				&& buf[0] == KEYFLAG)
				;	/* eat additional keyword lines */

			fputs(bufp, stdout);		/* print help */
			while (fgets(buf, sizeof buf, helpfp) != NULL
				&& buf[0] != KEYFLAG)
				fputs(bufp, stdout);	/* print help */
			return FOUND;
		}
	}

/* 
** Didn't find anything in the help file for the poor user.  Return failure.
** Don't close the help file!  The luser may want further help, and
** re-opening an already-open help file is wasteful.
*/
	return NOTFOUND;
}
