/* $Header: gtime.c,v 1.2 86/02/28 09:45:09 notes Exp $ */

/*
 * Miscellaneous time conversion routines
 *	-- lks
 */
#include "parms.h"
/* #include "structs.h" */
#include <time.h>

#include <sys/types.h>

#ifdef FAKE_FTIME
#   include "timeb.h"
#else
#   include <sys/timeb.h>
#endif FAKE_FTIME

static int dmsize[] = {
	31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
};

static int dysize();
static int mosize();

/*
 * return our current time zone,
 * in minutes west of Greenwich
 */
tzone()
{
	static int oncedone;
	static int timezn;

	if (!oncedone) {
		struct timeb tb;
		oncedone++;
		ftime(&tb);		/* V7 system call */
		timezn = tb.timezone;
	}

	return(timezn);
}
		
/*
 * given a broken down localtime, return the UNIX style time.
 * we intuit daylight savings time and timezone corrections
 * from what the system settings are.
 */
tm_to_time(adt, bdt)
	struct tm *adt;
	time_t *bdt;
{
	register int i;
	int yr;
	time_t tim;

	tim = 0L;
	yr = adt->tm_year + 1900;
	for (i = 1970; i < yr; i++)
		tim += dysize(i);
	i = adt->tm_mon + 1;
	while (--i > 0)
		tim += mosize(yr, i);
	tim += adt->tm_mday - 1;
	tim *= 24;
	tim += adt->tm_hour;
	tim *= 60;
	tim += adt->tm_min;
	tim *= 60;
	tim += adt->tm_sec;


	tim += tzone() * 60;			/* GMT correction */
	if (localtime(&tim)->tm_isdst)
		tim += -1*60*60;		/* daylight savings */
	*bdt = tim;
#ifdef	debug
	printf("year %d mon %d mday %d hour %d min %d sec %d tzone %d\n",
		adt->tm_year, adt->tm_mon, adt->tm_mday, adt->tm_hour,
		adt->tm_min, adt->tm_sec, tzone());
	printf("time set to %s", ctime(bdt));
#endif
}

static
dysize(y)
	int y;
{
	return((y%4) ? 365 : 366);
}

static
mosize(y, t)
	int y, t;
{

	if (t==2 && dysize(y)==366)
		return(29);
	return(dmsize[t-1]);
}
