/* $Header: dounix.c,v 1.3 87/06/30 18:09:15 notes Exp $ */

#include "parms.h"
#include "structs.h"
#include <signal.h>			/* signal processing */

extern int errno;

/*
 * dounix(charstring, flag) will execute that character string as a shell
 * command stolen from shell, though this one catches more signals.
 *
 *	R. Kolstad -- 11/2/80
 *	modified: R. Essick January 1982, to clean up some signal processing
 *
 */
/* VARARGS */
dounix (arg0, arg1, arg2, arg3, arg4)
char   *arg0, *arg1, *arg2, *arg3, *arg4;
{
    register    pid,
                rpid;
    SIGHNDLR	(*p)(), (*q)(), (*r)();
#ifdef	SIGTSTP
    SIGHNDLR	(*s) ();
#endif
    char *cmd;
    int     retcode;

    fflush(stdout);
    ttystop();			/* give back to normal mode */
    if ((pid = fork()) == 0) {
	closeRFA();			/* see dosystem.c */
	uncatchem();			/* reset this process signals */
	setgid(globgid);		/* give him his uid */
	umask(msk);			/* restore umask */

	if (arg0 == 0) {
	    execlp(shell, shell, 0);
	    cmd = shell;
	} else {
	    execlp(arg0, arg0, arg1, arg2, arg3, arg4);
	    cmd = arg0;
	}
	fprintf(stderr, "dounix: execlp failed\n");
	perror(cmd);
	_exit(1);
    }
    p = signal(SIGHUP, SIG_IGN);
    q = signal(SIGINT, SIG_IGN);
    r = signal(SIGQUIT, SIG_IGN);
#ifdef	SIGTSTP
    s = signal(SIGTSTP, SIG_DFL);
#endif
    while ((rpid = wait(&retcode)) != pid && rpid != -1);
    signal(SIGHUP, p);
    signal(SIGINT, q);
    signal(SIGQUIT, r);
#ifdef	SIGTSTP
    signal(SIGTSTP, s);
#endif
    ttystrt();			/* set terminal mode back */
    return(rpid!=-1 ? retcode>>8 : 1);
}



/*
 *	shell - give the user a shell
 *	this includes:
 *	1) changing to the directory where he came in from
 *	2) giving him a shell
 *	3) return to the notefile directory
 *
 *	original author: Ray Essick may 29, 1981
 *
 */
gshell()
{
	int ret;

	printf ("\n");
	ret = dounix (0, 0, 0, 0, 0);
	if (ret != 0)
		wfchar();
	return(ret);
}
