/* $Header: dmpresp.c,v 1.5 86/06/19 19:36:57 wunder Exp $ */

/*
 *	dmpresp
 *	prints logical response number to the note whose number is
 *	passed in. The note descriptor is also passed in. The dump is
 *	sent to the stdio descriptor pointed to by dumpfile
 *
 *	Original Coding:	Ray Essick December 1981
 *
 */

#include "parms.h"
#include "structs.h"
#include <time.h>

dmpresp(io, note, notenum, dmpfile, num, extensive)
struct io_f *io;
struct note_f *note;
FILE *dmpfile;
{
	int roffset, rrecnum;
	struct resp_f rsprec;
	struct txthead_f txthead;
	struct tm *tm;
	/* Use a big buffer (IDSZ) for [nr]sys, in case they overflow SYSSZ */
	char nsys[IDSZ], nuniq[IDSZ];
	char rsys[IDSZ], runiq[IDSZ];
	char hline[PATHLEN];
	struct msg_f *msgp;

	if (lrsp(io, notenum, num, &rsprec, &roffset, &rrecnum) == -1)
		return;

	msgp = &rsprec.r_msg[roffset];
	gethdr(io, &note->n_msg, note->n_msg.m_artid, hline);
	parseid(hline, nuniq, nsys);
	nuniq[SYSSZ-1] = nsys[SYSSZ-1] = '\0';
	gethdr(io, msgp, msgp->m_artid, hline);
	parseid(hline, runiq, rsys);
	runiq[SYSSZ-1] = rsys[SYSSZ-1] = '\0';
	fprintf(dmpfile, "R:%s:%s:%s:%s:%d\n", nsys, nuniq, rsys, runiq, num);

	gethdr(io, msgp, msgp->m_from, hline);

	if (!extensive)	{ /* retrofit hack! */
	    char *p;
	    extern char *index();
	    
	    /*
	     * In order to nfxmit back to old (notes ~1.3) sites, we
	     * need to get rid of everything but the username out of
	     * the from information.  To do this, we first nuke everything
	     * after the '@' in addresses of the form "tw@hpisla.UUCP (Tw Cook)",
	     * then we truncate to 9 characters so that we make sure it fits within
	     * the old username fields.  Someone should really check to see if
	     * we can't leave it a bit longer than this.	 - tw.
	     */

	    if (NULL != (p = index (hline, '@')))
	        *p = '\0';

	    hline[9] = '\0';
	}

	fprintf(dmpfile, "%s:%d\n", hline, notesuid);

	tm = localtime(&msgp->m_subtime);
	fprintf(dmpfile, "%d:%d:%d:%d:%d\n", tm->tm_year+1900,
	    tm->tm_mon+1, tm->tm_mday, tm->tm_hour, tm->tm_min);
	if (extensive) {
		tm = localtime(&msgp->m_rcvtime);
		fprintf(dmpfile, "%d:%d:%d:%d:%d\n", tm->tm_year+1900,
		    tm->tm_mon+1, tm->tm_mday, tm->tm_hour, tm->tm_min);
		gethdr(io, msgp, msgp->m_path, hline);
		fprintf(dmpfile, "%s\n", hline);
	}

	gethrec(io, &msgp->m_addr, &txthead);
	fprintf(dmpfile, "%03o:%ld\n", msgp->m_stat, txthead.textlen);
	pageout(io, &msgp->m_addr, dmpfile);

}

/*
 *	dmpall - dump all the responses to a note.  Merely calls
 *	dmpresp repetitively to dump all of them 
 *
 *	Original Coding:	Ray Essick	December 1981
 */
dmprall(io, note, notenum, dmpfile, extensive)
struct io_f *io;
struct note_f *note;
FILE *dmpfile;
{
	int num;

	for (num = 1; num <= note->n_nresp; num++)
		dmpresp(io, note, notenum, dmpfile, num, extensive);
}
