/* $Header: dmpnote.c,v 1.6 86/06/19 19:35:57 notes Exp $ */

/*
 *	dmpnote - dump a note in canonical form. This routine
 *	will take the note specified by the arguement and dump
 *	it in a canonical form..
 *
 *	dmpfile - stdio descriptor to write the output to 
 *	note - the current descriptor for that note 
 *
 *	Original Coding:	Ray Essick	December 1981
 */

#include "parms.h"
#include "structs.h"
#include <time.h>

dmpnote(io, note, notenum, dmpfile, extensive)
struct io_f *io;
struct note_f *note;
FILE *dmpfile;
{
	struct txthead_f txthead;
	struct tm *tm;
	/* Use a big buffer (IDSZ) for [nr]sys, in case they overflow SYSSZ */
	char nsys[IDSZ], nuniq[IDSZ];
	char hline[PATHLEN];
	struct msg_f *msgp;

	msgp = &note->n_msg;
	gethdr(io, msgp, msgp->m_artid, hline);
	parseid(hline, nuniq, nsys);
	nuniq[SYSSZ-1] = nsys[SYSSZ-1] = '\0';
	fprintf(dmpfile, "N:%s:%s:%d\n", nsys, nuniq, note->n_nresp);
	fprintf(dmpfile, "%s\n", note->n_title);

	gethdr(io, msgp, msgp->m_from, hline);

	if (!extensive)	{ /* retrofit hack! */
	    char *p;
	    extern char *index();
	    
	    /*
	     * In order to nfxmit back to old (notes ~1.3) sites, we
	     * need to get rid of everything but the username out of
	     * the from information.  To do this, we first nuke everything
	     * after the '@' in addresses of the form "tw@hpisla.UUCP (Tw Cook)",
	     * then we truncate to 9 characters so that we make sure it fits within
	     * the old username fields.  Someone should really check to see if
	     * we can't leave it a bit longer than this.	 - tw.
	     */

	    if (NULL != (p = index (hline, '@')))
	        *p = '\0';

	    hline[9] = '\0';
	}

	fprintf(dmpfile, "%s:%d\n", hline, notesuid);

	tm = localtime(&msgp->m_subtime);
	fprintf(dmpfile, "%d:%d:%d:%d:%d\n", tm->tm_year+1900,
	    tm->tm_mon+1, tm->tm_mday, tm->tm_hour, tm->tm_min);

	if (extensive) {
		tm = localtime(&msgp->m_rcvtime);
		fprintf(dmpfile, "%d:%d:%d:%d:%d\n", tm->tm_year+1900,
	    	    tm->tm_mon+1, tm->tm_mday, tm->tm_hour, tm->tm_min);

		tm = localtime(&note->n_lmod);
		fprintf(dmpfile, "%d:%d:%d:%d:%d\n", tm->tm_year+1900,
	    	    tm->tm_mon+1, tm->tm_mday, tm->tm_hour, tm->tm_min);
		gethdr(io, msgp, msgp->m_path, hline);
		fprintf(dmpfile, "%s\n", hline);    /* dump who from */
	}

	gethrec(io, &msgp->m_addr, &txthead);		/* get the body */
	fprintf(dmpfile, "%03o:%ld\n", msgp->m_stat, txthead.textlen);
	pageout(io, &msgp->m_addr, dmpfile);
}
