/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/dropt.c,v 2.0 89/04/15 23:50:10 gore Exp $ */

#include "parms.h"
#include "structs.h"
#include "header.h"

#ifdef __STDC__
static void display_moderation(struct io_f *io);
#else  __STDC__
static void display_moderation();
#endif __STDC__

/*
 *	this function processes the director options.
 *
 *	call: contains the io pointer to the file.
 *
 *	allows continued access only if the user if a director.
 *
 *	the functions of the director options includes:
 *	1) granting/denial of director priviledges
 *	2) granting/denial of regular access priviledges
 *	3) changing the director message
 *	4) writing a policy note
 *
 *	Returns: -1 normally
 *		 -4 if the user hit cntrl d ( to total exit)
 */

direct(io)
struct io_f *io;
{
	int     i;				/* scratch */
	int     c;
	char    title[DMLEN];		/* hold new director message */
	char    ntitle[NNLEN];		/* hold note file title */
	struct note_f   note;
	char    buff[BUFLEN];
	char *buffptr;
	int     start, end;
	struct notesenv oldenv;
	int retstat;
	int	nnotes, nresps;
	struct hbuf h;
#ifdef __STDC__
	extern char *getname(int);
#else
	extern char *getname();
#endif

	if (allow(io, DRCTOK) == 0) {
		warn("Sorry, you are not a director");
		return(-1);
	}

	replot = 1;
	oldenv = curenv;
	setjmp(jenv);
	while (1) {
		if (replot) {
			replot = 0;
			erase();
			i = (ncols - strlen(io->descr.d_title)) / 2;
			at(1, i);
			fputs(io->descr.d_title, stdout);
			i = (ncols - strlen(io->descr.d_drmes)) / 2;
			at(2, i);
			fputs(io->descr.d_drmes, stdout);
			i = (ncols - 52) / 2;
			at(3, i);
			printf("Anonymous: ");
			/* at(3, 25); */
			printf(io->descr.d_stat & ANONOK ? "ON " : "OFF");
			/* at(3, 31); */
			printf("   Notefile: ");
			/* at(3, 41); */
			printf(io->descr.d_stat & OPEN ? "OPEN  " : "CLOSED");
			/* at(3, 51); */
			printf("   Networked: ");
			/* at(3, 62); */
			printf(io->descr.d_stat & NETWRKD ? "YES" : "NO ");
			display_moderation(io);
		}
		cmdprompt();
		c = gchar(1);		/* get the command character */
		switch (c) {
		case 'r':
		case '\f':
			replot = 1;
			break;
		case '?': 
		case 'h': 
			nfhelp(DIRHLP);
			replot = 1;
			break;

		case 'k':
		case 'q': 		/* leave director options */
			retstat = -1;
			goto out;

		case '\004':        	/* control D */
			retstat = QUITFAST;
			goto out;

		case '!': 			/* give them a shell */
			gshell();
			break;

		case 'p': 			/* run access lists */
			if (doaccess(io) == QUITFAST) {
				retstat = QUITFAST;
				goto out;
			}
			replot = 1;
			break;

		case 'a': 			/* toggle anonymous option */
			lock(io, 'n');
			getdscr(io, &io->descr);
			/* get up to date descriptor */
			if (io->descr.d_stat & ANONOK)
				io->descr.d_stat &= ~ANONOK;
			else
				io->descr.d_stat |= ANONOK;
			putdscr(io, &io->descr);
			unlock(io, 'n');
			i = (ncols - 52) / 2 + 11;
			at(3, i);
			printf(io->descr.d_stat & ANONOK ? "ON " : "OFF");
			break;

		case 'c': 			/* compress the notefile */
			if (io->descr.d_stat & OPEN) {
				warn("Notefile must be closed to compress");
				continue;
			} 
			prompt("Compressing...");
			fflush(stdout);
			if (compress(io, LOCKIT, &nnotes, &nresps) >= 0)
				prompt("Left %d notes and %d responses",
				       nnotes, nresps);
			else
				warn("notesfile compressed behind your back");
			break;

		case 'o': 			       /* toggle open status */
			lock(io, 'n');
			getdscr(io, &io->descr);
			if (io->descr.d_stat & OPEN)
				io->descr.d_stat &= ~OPEN;
			else
				io->descr.d_stat |= OPEN;
			putdscr(io, &io->descr);
			unlock(io, 'n');
			i = (ncols - 52) / 2 + 27;
			at(3, i);
			printf(io->descr.d_stat & OPEN ? "OPEN  " : "CLOSED");
			break;

		case 'n': 			/* toggle network status */
			lock(io, 'n');
			getdscr(io, &io->descr);
			if (io->descr.d_stat & NETWRKD)
				io->descr.d_stat &= ~NETWRKD;
			else
				io->descr.d_stat |= NETWRKD;
			putdscr(io, &io->descr);
			unlock(io, 'n');
			i = (ncols - 52) / 2 + 47;
			at(3, i);
			printf(io->descr.d_stat & NETWRKD ? "YES" : "NO ");
			break;

		case 'm': 			 /* toggle moderation status */
			if (is_moderated(io)) {
			    make_unmoderated(io);
			} else {
			    char addr[ADDRLEN];
			    char *submission_address;

			    get_moderator(io, addr);
			    if (addr[0] == '\0') {
				prompt("Submission address: ");
				if (gline(addr, ADDRLEN) == 0) {
				    break;
				}
				submission_address = addr;
			    } else {
				prompt("Submission address (now %s): ", addr);
				if (gline(addr, ADDRLEN) == 0) {
				    submission_address = NULL;
				} else {
				    submission_address = addr;
				}
			    }
			    make_moderated (io, submission_address);
			}
			display_moderation(io);
			replot = 1;
			break;

		case 'M': 		/* collect a new director message */
			prompt("New director message: ");
			if (gline(title, DMLEN) == 0)
				break;
			lock(io, 'n');
			getdscr(io, &io->descr);
			/* get up-to-date version */
			strcpy(io->descr.d_drmes, title);
			putdscr(io, &io->descr);
			unlock(io, 'n');
			replot = 1;
			break;

		case 't': 			/* write title for note file */
			prompt("New title for notefile: ");
			if (gline(ntitle, NNLEN) == 0)
				break;
			lock(io, 'n');
			/* get up-to-date version */
			getdscr(io, &io->descr);
			strcpy(io->descr.d_title, ntitle);
			putdscr(io, &io->descr);
			unlock(io, 'n');
			replot = 1;
			break;

		case 'w': 		/* let him write a new policy note */
			if (io->descr.d_plcy) {
				prompt("Rewrite policy? ");
				if (askyn () == 'n') {
					c = 'e';
					break;
				}
			}
			prompt("Edit New Policy Text:");
			if (gettext(io, &note.n_msg.m_addr, (FILE *)0) == 0) {
				c = 'e';
				break;
			}
			genhdr(io, &h, 0);
			strcpy(note.n_title, "POLICY NOTE");
			note.n_stat = 0;
			lock(io, 'n');
			puthdr(io, &note.n_msg, &h);
			putnote(io, &note, POLICY, ADDTIME);
			unlock(io, 'n');
				/* show it to him */
			dspmsg(io, &note, &note.n_msg, 0, 0);
			break;

		case 'z':		/* zap a lot of notes/responses */
			prompt("Enter list of notes to delete: ");
			if (gline(buff, BUFLEN) == 0)
				continue;	/* grab line */
			prompt("Really delete %s? ", buff);
			if (askyn () != 'y')
				break;			/* chicken out */
			at(14, 1);
			clear_eol();
			buffptr = buff;
			while (listget(&buffptr, &start, &end)) {
				if (start == end)
					printf ("%d ", start);
				else
					printf ("%d-%d ", start, end);
				mdelete (io, start, end);	/* zap those */
			}
			continue;

		default: 
			warn("? for help, q to quit");
			continue;

		}
	}
out:
	ignsigs++;
	curenv = oldenv;
	ignsigs--;
	return(retstat);
}

static void
display_moderation(io)
    struct io_f *io;
{
    int i;
    char *submission_address;
    char addr[ADDRLEN];

    get_moderator(io, addr);
    submission_address = addr[0]=='\0' ? "None" : addr;

    if(io->descr.d_stat & MODERATED) {
	i = (ncols - 37 - strlen(submission_address))/2;
	at(4, i);
	printf("Moderated: YES (submission address: %s)",
	       submission_address);
    } else {
	i = (ncols - 41 - strlen(submission_address))/2;
	at(4, i);
	printf("Moderated: NO (last submission address: %s)",
	       submission_address);
    }
}
