/*
 * slurp.h - common definitions for slurp
 *
 * Copyright (C) 1992 Stephen Hebditch. All rights reserved.
 * TQM Communications, BCM Box 225, London, WC1N 3XX.
 * steveh@orbital.demon.co.uk  +44 836 825962
 *
 * See README for more information and disclaimers
 *
 * 1.00  29 Sep 92  SH  Initial coding.
 * 1.01   6 Dec 92  SH  Added no_time_flag
 * 1.03  15 Dec 92  SH  Added SYS_ERRLIST
 *
 */

/* Local header files */

#include "conf.h"
#include "nntp.h"


/* Standard header files */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <ctype.h>

#ifdef SYSLOG
  #ifdef FAKESYSLOG
    #include "fakesyslog.h"
  #else
    #include <syslog.h>
  #endif
#endif

#ifdef USG
  #include <string.h>
  #include <time.h>
#else
  #include <strings.h>
  #include <sys/time.h>
#endif


/* Important variables */

extern char *hostname;		/* Name of current NNTP server host */
extern char *pname;			/* Name of this program */
extern int  debug_flag;		/* Write extra debugging output to screen */
extern int  no_time_flag;	/* Don't update slurp.tim */

/* Article counters */

extern int  dupart;			/* Number of duplicate articles */
extern int  misart;			/* Number of missing articles */
extern int  newart;			/* Number of new articles */

extern long totalsize;		/* Total size of articles tranferred */

/* Details for NEWNEWS */

extern char *nn_newsgroups;
extern char *nn_time;
extern char *nn_distributions;

/* Binary tree holding message ids */

struct mnode
	{
	struct mnode *left;
	struct mnode *right;
	char msgid [MSGIDMAX];
	};
                          
extern struct mnode *root;
extern int entries;


/* Slurp function prototypes */

extern int  open_history ();						/* history.c */
extern void close_history ();
extern int  check_id (char *message_id);

extern long server_time ();							/* time.c */

extern void get_ids ();								/* newnews.c */

extern void get_articles ();						/* articles.c */
extern void enqueue_batch ();

extern int  space (int min_free);					/* space.c */

extern int  tcp_open (char *host, char *service);	/* sockets.c */
extern int  server_init (char *hostname);
extern void close_server ();
extern int  get_server (char *buf, int size);
extern void put_server (char *buf);

extern void log_ret (const char *fmt, ...);			/* misc.c */
extern void log_sys (const char *fmt, ...);
extern void log_msg (const char *fmt, ...);


/* The inevitable... */

#if !defined(TRUE) || ((TRUE) != 1)
  #define TRUE (1)
#endif

#if !defined(FALSE) || ((FALSE) != 0)
  #define FALSE (0)
#endif

#ifdef USG
  #define FCNTL
  #ifndef bcopy
    #define bcopy(a,b,c) (void)memcpy((char*)b,(char*)a,(int)c)
  #endif
  #ifndef bzero
    #define bzero(a,b) (void)memset((char*)a,0,(int)b)
  #endif
#endif

#ifndef PATH_MAX
  #define PATH_MAX 1024
#endif

#ifdef SYS_ERRLIST
  extern const char sys_errlist[];
  #define strerror(x) (sys_errlist[x])
#endif


/* END-OF-FILE */
