/*
 * Configuration file for NNTPlink.  Please edit the following appropriately.
 */


/*
 * Machine/OS configuration questions.
 */

/*
 * Define if your signal() routines are broken (ie: older Sys V)
 */
#undef BROKEN_SIGNAL


/*
 * Define if running under C News.
 */
#define CNEWS


/*
 * Define DECNET if you want DECnet support.
 */
#undef DECNET


/*
 * Define if you want DKHOST support
 */
#undef DKHOST

/*
 * Define this if your system has Posix session control (ie:  has a
 * setsid().)
 */
#define IS_POSIX


/*
 * What does free() take as its argument?
 */
#define FREE_ARG (char *)


/*
 * Do you have getrusage()?
 */
#define HAVE_GETRUSAGE


/*
 * Do you have a "working" select command which allows you to not
 * specify any file descriptors?
 */
#define HAVE_SELECT


/*
 * Does your setpgrp() not allow any arguments?  (ie: SysV)
 */
#define HAVE_SETPGRP_NOARGS


/*
 * Do you have the include file <string.h> or <strings.h>?  Define this
 * if you have <string.h> and undefine it if you have <strings.h>.  If
 * you have both then chances are you'll need to define it.
 */
#define HAVE_STRING_H


/*
 * Do you have the mmap() system call?  (ie: SunOS)
 */
#define MMAP

/*
 * Do you need my strcasecmp()?
 */
#undef NEED_STRCASECMP


/*
 * What does signal() return?
 */
#define SIGRET void


/*
 * Should we use bcopy() in place of memcpy()?
 */
#undef USE_BCOPY


/*
 * Should we use index() in place of strchr()?
 */
#undef USE_INDEX

/*
 * Should we use varags?
 */
#undef USE_VARARGS



/*
 * The following are general configuration type questions.
 */

/*
 * Define AUTH to use the proposed NNTP Version 2 authentication protocol.
 *
 * If you define AUTH, then define the file where the nntp
 * site/userid/passwords are kept.  Protect this file (mode: 600)
 */
#undef	AUTH
#undef	PASSFILE	"/usr/local/src/public/link/3.0/nntp_sys"


/*
 * Default news batch directory.  (Can be overridden with "-B batchdir").
 */
#define BATCHDIR	"/usr/spool/news/out.going"


/*
 * How many seconds should nntplink sleep between checks for a new batchfile?
 * (Can be overridden with "-n num").
 */
#define BATCH_SLEEP	60


/*
 * Number of articles we must have offered to remote end before nntplink
 * resets the batchfile.  NOTE:  This must be a multiple of LOG_AFTER.
 * (Can be overridden with "-c num")
 */
#define CLEAR_BATCHFILE	(1*LOG_AFTER)


/*
 * If we've offered this many articles then we want to close and reopen the
 * link to give the remote host a chance to log statistics.  (Can be
 * overridden with "-a num").
 */
#define CLOSE_AFTER	100


/*
 * After this many seconds of idle time we will close the connection.
 * (NOTE: Use "NEVER" to never close the connection due to idle).
 * Can be overridden by "-C num" -- use "-C -1" to never close the
 * connection.
 */
#define CLOSE_TIMEOUT 300


/*
 * Input file flags - where do we get articles from?  Don't change these.
 *
 * NOTE:  These are here only so the following define (DEF_INPUT_FROM)
 *        doesn't get confused - I guess some older machines can't deal
 *        with using a definition before it's defined.  :-)
 */
#define FLG_BATCHFILE	(1<<0)		/* only from batchfile */
#define FLG_LOGFILE	(1<<1)		/* from batchfile, then logfile */
#define FLG_STDIN	(1<<2)		/* from batchfile, then <stdin> */

/*
 * Where should nntplink default to get it articles from?
 * FLG_BATCHFILE or FLG_LOGFILE or FLG_STDIN
 * (Can be overridden with "-i [batchfile|logfile|stdin]").
 */
#define DEF_INPUT_FROM	FLG_LOGFILE


/*
 * If your system doesn't have getdtablesize() then define the following
 * to be the max number of slots in the file descriptor table.
 */
#undef DTABLESIZE	20


/*
 * How many seconds should nntplink sleep between checks for a new entry
 * in either the log file or the batchfile?  (Can be overridden with
 * "-E num").
 */
#define ENTRY_SLEEP	1


/*
 * After this many seconds of idle time we will exit from nntplink.
 * (NOTE: Use NEVER to never exit nntplink).  Can be overridden by
 * "-e num" -- use "-e -1" to never exit nntplink.
 */
#define EXIT_TIMEOUT NEVER


/*
 * If you don't have support for syslog, but want a facsimile,
 * define FAKESYSLOG to be the name of a file to which to log stuff.  e.g.,
 *
 *      #define FAKESYSLOG      "/usr/lib/news/nntplink.log"
 *
 * If your host supports the BSD fdopen() function and the O_APPEND flag
 * to open(), you should define FAKEAPPEND with FAKESYSLOG so that
 * multiple copies of nntplink don't trash the log with buffered fprintf's.
 */
#undef  FAKESYSLOG	"/usr/lib/news/nntplink.log"
#undef  FAKEAPPEND


/*
 * If we've gone FAIL_MINUTES between successful article transmissions then
 * we'll syslog() an error message.  Can be overridden with "-F num".
 *
 * Once we've hit FAIL_MINUTES, we will repeat the message every
 * REPEAT_MINUTES until the error condition goes away.  Can be overridden
 * with "-R num".
 */
#define FAIL_MINUTES	(12*60)
#define REPEAT_MINUTES	(12*60)


/*
 * Default news history file.  (Can be overridden with "-H historyfile").
 */
#define HISTORYFILE	"/usr/lib/news/history"


/*
 * Number of articles we must have offered to remote end before nntplink
 * decides to log local statistics.  (Can be overridden with "-l num").
 */
#define LOG_AFTER	100


/*
 * Default news logfile.  (Can be overridden with "-L logfile").
 */
#define LOGFILE		"/usr/lib/news/log"


/*
 * How many seconds should nntplink sleep between checks for a new logfile?
 * (Can be overridden with "-N num").
 */
#define LOGFILE_SLEEP	60


/*
 * If you are going to be using the "logfile input mode" of nntplink
 * and you haven't installed the modifications to [relaynews|inews]
 * (which saves the path of each article to the logfile) then you
 * must define this (it causes nntplink to do a history lookup to
 * get the path).
 */
#undef LOOKUP_ARTICLE


/*
 * If you defined LOOKUP_ARTICLE then you must pick one of the dbm's
 * from this list - it is used in the history lookup.
 */
#ifdef LOOKUP_ARTICLE
#define DBZ
#undef DBM
#undef NDBM
#endif


/*
 * How many times can an article fail to be transferred before we either
 * junk it or put it into the failure file?
 */
#define MAX_ART_FAILS	2


/*
 * When we get an error from the remote host we want to sleep for NAPTIME
 * seconds, if we continue to get an error then we want to have exponential
 * backoff until we get to MAX_NAPTIME seconds.
 */
#define NAPTIME		15		/* 15 seconds */
#define MAX_NAPTIME	(15*64)		/* 16 minutes */


/*
 * Default news spool directory.  (Can be overridden with "-S spooldir").
 */
#define SPOOLDIR	"/usr/spool/news"


/*
 * If we have gone this many minutes between successfull transmissions of
 * articles then we want to "catch up" by reading to the end of the current
 * input file (either the "logfile" or "stdin").
 */
#define SPOOL_MINUTES	60


/*
 * If you don't have "LOG_NEWS", define SYSLOG to be something you do have,
 * ie: LOG_LOCAL0
 */
#define SYSLOG		LOG_NEWS



               /**** END OF CONFIGURATION SECTION *****/
/*
 * Random stuff needed for nntplink
 *
 * This file also contains a lot of assumptions about what features
 * are available on the local system - if something is not working
 * to your liking, look them over carefully.
 */

#define VERSION		"3.0.2"
#define DATAFILE_VERSION 3.0

#define Boolean	char

#ifdef USE_INDEX
#define strchr		index
#define strrchr		rindex
#endif

#ifdef USE_BCOPY
#define memcpy(a,b,c)    bcopy(b,a,c)
#endif

#define	MAXDIGS		11

#define USE_KEEPALIVES

#define fb_error(a)	fb_err(a)

#define	T_IP_TCP	1	/* transport is IP/TCP */
#define	T_DECNET	2	/* transport is DECNET */
#define T_DKHOST	3	/* transport is DKHOST */

#define READ_TIMEOUT	300	/* seconds to read timeout in read_reply() */

#ifndef TRUE
#define TRUE		1
#define FALSE		0
#endif

#define LOG_ERROR	TRUE
#define DONT_LOG_ERROR	FALSE

#define WAIT		TRUE
#define DONT_WAIT	FALSE
#define WANT_FILENAME	FALSE

#define FAIL		(-1)
#define NONE		(-1)
#define MATCH		0

#define NOHOST		(FAIL-1)
#define NOSERVICE	(FAIL-2)

#ifndef NULL
#define NULL		0
#endif

#define NEVER		(-1)

#define FCLOSE(fp)	{ (void) fclose(fp); (fp) = NULL; }
#define CLOSE(fd)	{ (void) close(fd); (fd) = NONE; }

#define FREE(mp)	{ (void) free( FREE_ARG mp); (mp) = NULL; }

#ifdef DBZ		/* If you use DBZ, then you need DBM as well. */
#ifndef DBM
#define DBM
#endif /* DBM */
#endif /* DBZ */

/*
 * <dbm.h> stupidly defines NULL, which is why the following
 * brain death is necessary.
 */

#ifdef DBM
# ifdef DBZ
#  include <dbz.h>
# else /* DBZ */
#  undef NULL
#  include <dbm.h>
#  undef NULL
#  define NULL	0
# endif /* DBZ */
#else
# ifdef NDBM
#  include <ndbm.h>
# endif /* NDBM */
#endif /* DBM */


#define dlog	if (!Debug) ; else log

/*
 * Some systems leave this out of <errno.h>
 */
extern int errno;

/*
 * Some systems don't have <malloc.h>
 */
extern char *malloc();

extern char *errmsg();
