#include <signal.h>
#include "conf.h"
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#include "readline.h"
#include "nntplink.h"

extern Boolean Debug;
extern int Input_from;
extern Boolean One_shot;

extern Boolean Reset_log;

Boolean Abort_signaled = FALSE;
Boolean Reset_signaled = FALSE;

extern void fail();
extern void log();

void
  sighandler(sig)
int sig;
{
    static char *fname = "sighandler: ";

#ifdef BROKEN_SIGNAL
    signal(sig, SIG_IGN);
    signal(sig, sighandler);
#endif

    dlog(LOG_DEBUG, fname, "%s%s: received signal %d\n", Host.name, sig);

    switch(sig) {
      case SIGINT:
      case SIGTERM:
	Abort_signaled = TRUE;
	break;

      case SIGHUP:
	if (One_shot)
	  Abort_signaled = TRUE;
	else if ( ! (Input_from & FLG_BATCHFILE))
	  Reset_signaled = TRUE;

#ifdef FAKESYSLOG
      case SIGUSR1:
	Reset_log = TRUE;
#endif
	
	break;

      case SIGPIPE:
#ifdef SIGURG
      case SIGURG:
#endif
	log(LOG_DEBUG, fname, "%s%s: received signal %d - continuing\n",
	    Host.name, sig);
	break;

      default:
	fail(fname, "%s%s: Received unknown signal %d\n", Host.name, sig);
	/*NOTREACHED*/
    }
    return;
}
