/*
 * Common declarations, includes, and other goodies.
 *
 * @(#)$Header: common.h,v 1.33 90/08/25 17:00:11 sob Exp $
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <ctype.h>
#include <pwd.h>
#include <sys/file.h>
#include <sys/param.h>
#ifdef BSD2_10
#include <short_names.h>
#endif BSD2_10

#include "../common/nntp.h"
#include "../common/conf.h"

#ifdef SYSLOG
# ifdef FAKESYSLOG
#  include "fakesyslog.h"
# else
#  include <syslog.h>
# endif
#endif

#ifdef USG
extern struct passwd *getpwent(), *getpwuid(), *getpwnam();
#define iolen_t unsigned
# include <string.h>
#else not USG
# include <strings.h>
# include <sys/wait.h>
#define iolen_t int
#endif not USG

#ifdef NDIR
#ifdef M_XENIX
# include <sys/ndir.h>
#else
# include <ndir.h>
#endif
#else not NDIR
# include <sys/dir.h>
#endif not NDIR

#ifdef FCNTL
# include <fcntl.h>
#endif FCNTL

#ifdef ultrix
extern char * index();
extern char * rindex();
#endif

/*
 * <dbm.h> stupidly defines NULL, which is why the following
 * brain death is necessary.
 */

#ifdef DBM
# ifdef DBZ
#  include <dbz.h>
# else /* DBZ */
#  undef NULL
#  include <dbm.h>
#  undef NULL
#  define NULL	0
# endif /* DBZ */
#endif /* DBM */

#ifdef NDBM
# include <ndbm.h>
#endif
/*
 * Some generic maximums.
 */

#ifndef MAXPATHLEN
#define	MAXPATHLEN	1024
#endif not MAXPATHLEN

#ifndef MAXHOSTNAMELEN
#define	MAXHOSTNAMELEN	256
#endif not MAXHOSTNAMELEN

#ifndef MINFREE
#define MINFREE         0
#endif

#ifndef POSTBUFFER
#define POSTBUFFER      0
#endif

#define	MAXBUFLEN	1024

/*
 * For "spew()"
 */

#define	ARTICLE	0
#define	HEAD	1
#define	BODY	2
#define	STAT	3

/*
 * For "ngmatch()"
 */

#define	ALLBUT	1

#define	valid_art(s)	(atoi(s) != 0)

#define	putline(s)	fputs((s), stdout); putchar('\r'); putchar('\n');

extern	int	errno;

extern	char	*gets(), *fgets();
extern	char	*mktemp();
extern	FILE	*open_valid_art();
extern	FILE	*openartbyid();
extern	char	*gethistent();
extern	int	restreql();
extern	int	s1strneql();	/* for ngmatch */

extern	char	spooldir[];
extern	char	activefile[];
extern	char	distributionsfile[];
extern	char	newsgroupsfile[];
extern	char	accessfile[];
extern	char	historyfile[];
extern	char	ngdatefile[];
extern	char	inews[];
extern	char	rnews[];

extern	char	**group_array;
extern	char	*actbuf;
extern	int	num_groups;
extern	char	*homedir;
extern	int	ingroup;
extern	int	maxgroups;
extern	int	art_array[];
extern	int	art_ptr;
extern	FILE	*art_fp;
extern	int	num_arts;
extern	int	uid_poster, gid_poster;
extern	int	canread, canpost, canxfer;
extern	char	**ngpermlist;
extern	int	ngpermcount;

extern	char	nntp_version[];

extern	char	hostname[];

#ifdef LOG
extern	int	grps_acsd, arts_acsd;

extern	int	ih_accepted;
extern	int	ih_rejected;
extern	int	ih_failed;

extern	int	nn_told;
extern	int	nn_took;
#endif
