#define	TRUE		1
#define	FALSE		0

#define	VERSION			"0.4"

/* Pull in all the system includes that are portability prone. */

#include "config.h"
#include "patchlevel.h"


#define	CONFIG_FILENAME		"config"
#define	SITE_DIRECTORY		"sites"
#define	EXCLUSIONS_FILENAME	"exclude"
#define	BODY_FILENAME		"groups"
#define	NEWBODY_FILENAME	"groups.new"
#define	OLDBODY_FILENAME	"groups.old"

#define	GROUP_OVERFLOW_LP	25	/* Point at which newsgroup newlines */

#define	MAX_LINE_SIZE		512
#define	MODEST_SIZE		128

#define FILE_LOCK			/* this should always be OK */

#ifdef FILE_LOCK
#define LOCK_SLEEP		60	/* time to sleep between lock attempts */	
#define MAX_LOCK_SLEEP_COUNT	10	/* maximum number of tries */
#endif

/* Logit flags */

#define	L_LOG		(1<<0)
#define	L_MAIL		(1<<1)
#define	L_BOTH		(L_LOG | L_MAIL)
#define	L_TIMESTAMP	(1<<2)


typedef	struct	group_s	GROUP;

typedef struct	tag_s	TAG;

struct tag_s {
    TAG		*next;
    GROUP	*group;
};

struct	group_s {
    GROUP	*next;
    char	*name;
    char	*desc;
    int		order;		/* Needed for sorting */
    union {
	int	not;
	TAG	*tag;
    }		u;
};

typedef struct {
    GROUP	*head;
    GROUP	*tail;
    unsigned	length;
} LIST;

#define TRAVERSE(list, elt) \
	if (list) \
	    for (elt = list->head; elt; elt = elt->next)

#define NEXT(list, elt) \
	elt = elt->next

#define LIST_LENGTH(list) \
	(list->length)

/* Protos */

#if defined(__STDC__) || defined(__cplusplus)
# ifndef __P
# define __P(protos)	protos		/* ANSI C */
# endif
#else
# ifndef __P
# define __P(protos)	()		/* traditional braindamage */
# endif
# define const
#endif

extern	int	wildmat __P((char *text, char *p));
extern	void	logit __P((int lflags, char *prefix, const char *msg));
extern	int	lockit __P((void));
extern	void	unlockit __P((void));
extern	void	gupout __P((int val, const char *msg));
extern	void	prune __P((LIST *active_list, LIST *group_list));
extern	int	help __P((char **tokens));
extern	void	print_newsgroups __P((FILE *, char *gname));
extern	LIST	*read_groups __P((int fd, LIST *exclusion_list));
extern	LIST	*create_list __P((void));
extern	GROUP	*create_group __P((int not_flag, const char *name));
extern	void	destroy_group __P((GROUP *gp));
extern	void	add_group __P((LIST *list, GROUP *group));
extern	void	remove_group __P((LIST *list, GROUP *group));

extern	char	*xstrdup __P((const char *str));
extern	int	subscribed __P((LIST *gp, char *gname));

/* mail.c */

extern	FILE	*mail_open __P((int, char *, char *, char *));
extern	void	mail_close __P((FILE *));

/* sort.c */

extern	LIST	*sort_groups __P((LIST *list));


#ifdef NO_STRERROR
extern	const char *strerror __P((int err));
#endif

/* Define external variables */

#ifdef	MAIN
#define	EXTERN
#else
#define	EXTERN	extern
#endif

extern	char	*progname;

EXTERN	char	*log_filename;
EXTERN	FILE	*log_fp;

EXTERN	FILE	*mail_fp;

EXTERN	char	*active_path;
EXTERN	char	*newsgroups_path;

EXTERN	char	msg[MAX_LINE_SIZE*2];

EXTERN	LIST	*active_list;
EXTERN	LIST	*group_list;
