/* Semantic Operations */

typedef enum {
	oCall = 0,					/* 0 */
	oReturn,					/* 1 */
	oRuleEnd,					/* 2 */
	oJump,						/* 3 */
	oInput,						/* 4 */
	oInputAny,					/* 5 */
	oInputChoice,					/* 6 */
	oEmit,						/* 7 */
	oError,						/* 8 */
	oChoice,					/* 9 */
	oChoiceEnd,					/* 10 */
	oSetParameter,					/* 11 */
	oSetResult,					/* 12 */
	oSetResultFromInput,				/* 13 */
	oSetComponentType,				/* 14 */
	oEmitToken,					/* 15 */
	oEmitTokenCurType,				/* 16 */
	oDeferEmitToken,				/* 17 */
	oReleaseEmitToken,				/* 18 */
	oOpenAddress,					/* 19 */
	oAppendAddress,					/* 20 */
	oCloseAddress,					/* 21 */
	oDateTime,					/* 22 */
	oEnterReceived,					/* 23 */
	oExitReceived,					/* 24 */
	oSaveReceivedComponent,				/* 25 */
	oSetReturnType,					/* 26 */
	oRewind,					/* 27 */
	lastOfTableOperation
} TableOperation;

/* Input Tokens */

typedef enum {
	tSyntaxError = -1,				/* -1 */
	tIdent,						/* 0 */
	tString,					/* 1 */
	tInteger,					/* 2 */
	tSemicolon,					/* 3 */
	tComma,						/* 4 */
	tPeriod,					/* 5 */
	tColon,						/* 6 */
	tLeftAngle,					/* 7 */
	tRightAngle,					/* 8 */
	tAtSign,					/* 9 */
	tOtherSpecial,					/* 10 */
	tAtom,						/* 11 */
	tBy,						/* 12 */
	tDomainLiteral,					/* 13 */
	tFor,						/* 14 */
	tFrom,						/* 15 */
	tId,						/* 16 */
	tQuotedString,					/* 17 */
	tVia,						/* 18 */
	tWith,						/* 19 */
	tNewLine,					/* 20 */
	tEndOfHeader,					/* 21 */
	lastOfInputTokens
} InputTokens;

/* Output Tokens */

typedef enum {
	aOutputToken = 0,				/* 0 */
	lastOfOutputTokens
} OutputTokens;

/* Input/Output Tokens */


/* Error Codes */

typedef enum {
	eNoError = 0,					/* 0 */
	eSyntaxError,					/* 1 */
	ePrematureEndOfFile,				/* 2 */
	eExtraneousProgramText,				/* 3 */
	eExtraneousTokensInAddress = 10,		/* 10 */
	eExtraneousTokensInMailbox,			/* 11 */
	eMissingSemicolonToEndGroup,			/* 12 */
	eMissingSemicolonInReceived,			/* 13 */
	eMissingEndOfAddress,				/* 14 */
	eMissingEndOfMailbox,				/* 15 */
	eIllegalWordInPhrase,				/* 16 */
	eIllegalSpecialInPhrase,			/* 17 */
	eIllegalPeriodInPhrase,				/* 18 */
	eIllegalPhraseMustBeQuoted,			/* 19 */
	eIllegalSubdomainInDomain,			/* 20 */
	eIllegalTokenInRoute,				/* 21 */
	eIllegalWordInLocalPart,			/* 22 */
	eIllegalStartOfMessageId,			/* 23 */
	eIllegalEndOfMessageId,				/* 24 */
	eIllegalEncryptionIdentifier,			/* 25 */
	eIllegalAddressSeparator,			/* 26 */
	eIllegalMailboxSeparator,			/* 27 */
	eIllegalMessageIDSeparator,			/* 28 */
	eIllegalStartOfRouteAddress,			/* 29 */
	eIllegalEndOfRouteAddress,			/* 30 */
	eIllegalSpecialInValue,				/* 31 */
	eIllegalReferencesSeparator,			/* 32 */
	eExpectedWord,					/* 33 */
	eSslStackOverflow = 40,				/* 40 */
	lastOfErrorCodes
} ErrorCodes;

/* Type Values */

typedef enum {
	cPhrase = 0,					/* 0 */
	cComment,					/* 1 */
	cSpecial,					/* 2 */
	cGroup,						/* 3 */
	cAddress,					/* 4 */
	cDomain,					/* 5 */
	cWord,						/* 6 */
	cResync,					/* 7 */
	cError,						/* 8 */
	lastOfComponentClass
} ComponentClass;

typedef enum {
	rAddress = 0,					/* 0 */
	rDate,						/* 1 */
	rReceived,					/* 2 */
	lastOfReturnValue
} ReturnValue;

typedef enum {
	rcFrom = 0,					/* 0 */
	rcBy,						/* 1 */
	rcVia,						/* 2 */
	rcWith,						/* 3 */
	rcId,						/* 4 */
	rcFor,						/* 5 */
	rcDate,						/* 6 */
	lastOfReceivedComponent
} ReceivedComponent;

typedef enum {
	Failure = 0,					/* 0 */
	Success,					/* 1 */
	lastOfOutcome
} Outcome;

