/* relay-blocking policy tests;  Added for ZMailer 2.99.44 by Matti Aarnio
   on 16-Dec-96 */

/* Pre-included before including this:
   - all type-defining files
   - *DB* headers
 */

struct policystate {		/* Part of SmtpState structure */
    int always_reject;
    int always_freeze;
    int always_accept;
    int sender_reject;
    int sender_freeze;
    int relaycustnet;
    int rcpt_nocheck;

    int request;
    /* These flags say which attributes are checked. */
    /* For example: P_A_REJECTSOURCE ( == 3)
       Corresponding flag is 3rd bit (1 << 3) = 8.
       Flag P_A_ALIAS ( == 1) is ignored.            */
    char values[12]; /* XX: Make sure the P_A_* attributes fit here! */
    /* Attribute values are stored here. */
};


#ifdef _POLICYTEST_INTERNAL_

typedef union {
    struct sockaddr_in v4;
#ifdef INET6
    struct sockaddr_in6 v6;
#endif
} Usockaddr;


typedef enum {
    _dbt_none, _dbt_btree, _dbt_ndbm, _dbt_gdbm
} dbtypes;


struct policytest {
    char *dbtype;
    char *dbpath;
    dbtypes dbt;
    union {
#ifdef HAVE_NDBM_H
	DBM *_ndbm;
#endif
#ifdef HAVE_GDBM_H
	GDBM_FILE _gdbm;
#endif
#ifdef HAVE_DB_H
	DB *_db;
#endif
    } db_;
#define btree db_._db
#define gdbm  db_._gdbm
#define ndbm  db_._ndbm
};

#else				/* This is the external interface -- doesn't tell a thing ;-) */

struct policytest {
    void *dummy;
};

#endif

typedef enum {
    POLICY_HELONAME,
    POLICY_SOURCEADDR,
    POLICY_MAILFROM,
    POLICY_RCPTTO
} PolicyTest;

/* Test return values:
   <0 : Always reject
   =0 : Accept
   >0 : Accept into freeze area...
 */

extern void policydefine __((struct policytest ** relp, const char *dbtype, const char *dbpath));
extern void policyinit __((struct policytest ** relp, struct policystate * ps));
extern int policytest __((struct policytest * rel, struct policystate * ps, PolicyTest how, const char *str, const int len));
extern int policytestaddr __((struct policytest * rel, struct policystate * ps, PolicyTest how, Usockaddr * raddr));

extern struct policytest *policydb;
