diff -u -r zmailer-2.99.38/BUGS zmailer-2.99.39/BUGS
--- zmailer-2.99.38/BUGS	Sun Aug 18 17:35:19 1996
+++ zmailer-2.99.39/BUGS	Fri Oct 25 21:11:01 1996
@@ -1,5 +1,13 @@
 Known/suspected bugs/Missing Features on current Zmailer sources
 
+- Reports heard of router locking failing to acquire individualy
+  a target file, and thus resulting multiple routing/delivering of
+  the same message.
+
+- DSN (Delivery Status Notification) mechanism does not (yet) report
+  on "SUCCESS" or "DELAY", only noticing "NEVER", and reacting as if
+  "FAILURE" is always given...
+
 - BUG! mailbox has a file creation failure window:
         - mailbox1 tests to see if the mailbox exists, and it does not
         - mailbox2 tests to see if the mailbox exists, and it does not
@@ -30,6 +38,9 @@
 	- BSD (new) db -- tested in  ndbm  compability mode
 	- sdbm -- never tested
 
+- Add LDAP databases (and BSD DB too) to router!
+	(sendmail-8.8.x has/will get LDAP)
+
 - 'channel error' detection is partial at places;
 	transporters: sm, hold, errormail
 
@@ -121,6 +132,12 @@
 
   Hmm.. Perhaps we could do a ``single process doing multi-stream reception ?''
   it would require fairly large rewrite of the SMTP-server..
+
+  Also: What to do when there are more incoming SMTP sessions than the
+  process can have open file descriptors ?  Two for each way of SMTP (for
+  stdio library!) channel, one for each spool file in active use at the
+  input phase, and one for log.    (Ok, stdio must do with one fd, but
+  it may want to have separate buffers for output, and input..)
 
 - Alias processing by "newaliases" (printaliases: run_praliases)
   is "interesting" -- if sysadm wants to add an alias like:
diff -u -r zmailer-2.99.38/ChangeLog zmailer-2.99.39/ChangeLog
--- zmailer-2.99.38/ChangeLog	Fri Aug 23 11:50:53 1996
+++ zmailer-2.99.39/ChangeLog	Tue Oct 22 18:54:46 1996
@@ -1,3 +1,24 @@
+Tue Oct 22 18:51:07 1996  Matti Aarnio  <mea@mea.tmt.tele.fi>
+
+	* smtpserver/smtpserver.c:
+	    Fixes to:
+	      - ident processing
+	      - IETF NOTARY DSN mechanisms -- will ALWAYS create  ORCPT= entry!
+
+	* libident/identuser.c:
+	    Changes at the return values at various error conditions
+
+	* transports/libta/ctlopen.c:
+	    Fix on DSN NOTARY parameter scanning
+	
+Thu Sep 12 22:19:58 1996  Matti Aarnio  <mea@mea.tmt.tele.fi>
+
+	* configure.in, Makefile.in, utils/makendbm/makendbm.c,
+	  utils/makendbm/ndbmlook.c, support/vacation/vacation.SH:
+	    A RedHat 3.0.3 Linux with some additions from more
+	    recent "Rembrandt" release caused several changes
+	    into the autoconfig, and makendbm system.
+
 Fri Aug 23 11:32:43 1996  Matti Aarnio  <mea@nic.funet.fi>
 
 	* transports/mailbox/mailbox.c:
diff -u -r zmailer-2.99.38/INSTALL zmailer-2.99.39/INSTALL
--- zmailer-2.99.38/INSTALL	Fri Aug 23 20:36:27 1996
+++ zmailer-2.99.39/INSTALL	Fri Oct 25 22:12:29 1996
@@ -196,11 +196,21 @@
 	you can alter it..  Into $MAILSHARE/mail.conf -- for example.
 
 
+    ==> /etc/group : zmailer -group
+
 	The default configuration also expects to find names of trusted users
 	listed at  /etc/group -entry:  zmailer.  Users (unames) listed there
 	will be able to claim any addresses at the message headers, etc.
 	(See $MAILSHARE/cf/trusted.cf  for its usage there.)
-	SECURITY ITEM: Those users MUST NOT contain 'nobody' !
+	Usual set is:  root,daemon,uucp
+	(Note: At some machines 'daemon' is called 'daemons' ... it is
+	       the one with UID=1)
+
+	SECURITY ITEM: Those users at zmailer-group MUST NOT contain 'nobody' !
+	(The 'nobody' is used to prevent externally given inputs from being
+	 able to execute arbitary programs at the system, or from writing to
+	 arbitary files..)
+
 
 	At this point, you should be able to start the router process in
 	interactive mode.  Run:
Only in zmailer-2.99.39: MANIFEST
diff -u -r zmailer-2.99.38/Makefile zmailer-2.99.39/Makefile
--- zmailer-2.99.38/Makefile	Tue Sep 17 20:42:23 1996
+++ zmailer-2.99.39/Makefile	Sat Oct 26 00:19:18 1996
@@ -23,13 +23,14 @@
 PROGS	= router/router scheduler/scheduler			\
 	scheduler/mailq smtpserver/smtpserver transports/-ok	\
 	compat/rmail/rmail compat/sendmail/sendmail		\
-	support/vacation/vacation
+	support/vacation/vacation utils/makendbm/makendbm
 
 # Subdirectories to run make in for the primary targets.
-SUBDIRS =  smtpserver router scheduler transports compat
+SUBDIRS =  smtpserver router scheduler transports compat 	\
+	   utils/makendbm support/vacation
 # Subdirectories where to run 'make clean'
 MOREDIRS = libs lib libc libsh libident libmalloc libresolv ssl \
-	   utils/makendbm support/vacation proto
+	   proto
 # Files to remove in cleanup
 CLEANFILES = include/rfc822.entry $(ZCONF) version.c
 DISTCLEANFILES = include/mail.h SiteConfig
@@ -62,6 +63,7 @@
 	cd smtpserver ; $(MAKE) $(MFLAGS) install
 	cd transports ; $(MAKE) $(MFLAGS) install
 	cd libc ; $(MAKE) $(MFLAGS) install
+	cd utils/makendbm ; $(MAKE) $(MFLAGS) install
 	cd support/vacation ; $(MAKE) $(MFLAGS) install
 
 dirs:
@@ -76,6 +78,7 @@
 	cd smtpserver ; $(MAKE) $(MFLAGS) install
 	cd transports ; $(MAKE) $(MFLAGS) install
 	cd libc ; $(MAKE) $(MFLAGS) install
+	cd utils/makendbm ; $(MAKE) $(MFLAGS) install
 	cd support/vacation ; $(MAKE) $(MFLAGS) install
 
 router/router:
@@ -102,6 +105,9 @@
 support/vacation/vacation:
 	cd support/vacation ; $(MAKE) $(MFLAGS) vacation
 
+utils/makendbm/makendbm:
+	cd utils/makendbm ; $(MAKE) $(MFLAGS)
+
 lib/libz.a: lib/*.c
 	cd lib ; $(MAKE) $(MFLAGS)
 
@@ -202,7 +208,7 @@
 	cat SiteConfig | \
 	sed -n	-e '/^\([a-zA-Z][^ 	]*\)[ 	]*=[ 	]*\(.*\)[ 	]*$$/!d' \
 		-e 's/^\([^ 	]*\)[ 	]*=[ 	]*\(.*\)[ 	]*$$/\1="\2"/' \
-		-e 's/^\([^ 	]*\)=""/\1="/' -e 's/""$$/"/'	\
+		-e 's/^\([^ 	]*\)=""\(.*\)""$$/\1="\2"/'	\
 		-e 's/="\([^ 	]*\)"$$/=\1/'			\
 		-e p	) > $@
 # The sed-patterns above do:
diff -u -r zmailer-2.99.38/Makefile.in zmailer-2.99.39/Makefile.in
--- zmailer-2.99.38/Makefile.in	Sun Aug 25 01:04:56 1996
+++ zmailer-2.99.39/Makefile.in	Tue Oct 22 19:02:07 1996
@@ -23,13 +23,14 @@
 PROGS	= router/router scheduler/scheduler			\
 	scheduler/mailq smtpserver/smtpserver transports/-ok	\
 	compat/rmail/rmail compat/sendmail/sendmail		\
-	support/vacation/vacation
+	support/vacation/vacation utils/makendbm/makendbm
 
 # Subdirectories to run make in for the primary targets.
-SUBDIRS =  smtpserver router scheduler transports compat
+SUBDIRS =  smtpserver router scheduler transports compat 	\
+	   utils/makendbm support/vacation
 # Subdirectories where to run 'make clean'
 MOREDIRS = libs lib libc libsh libident libmalloc libresolv ssl \
-	   utils/makendbm support/vacation proto
+	   proto
 # Files to remove in cleanup
 CLEANFILES = include/rfc822.entry $(ZCONF) version.c
 DISTCLEANFILES = include/mail.h SiteConfig
@@ -62,6 +63,7 @@
 	cd smtpserver ; $(MAKE) $(MFLAGS) install
 	cd transports ; $(MAKE) $(MFLAGS) install
 	cd libc ; $(MAKE) $(MFLAGS) install
+	cd utils/makendbm ; $(MAKE) $(MFLAGS) install
 	cd support/vacation ; $(MAKE) $(MFLAGS) install
 
 dirs:
@@ -76,6 +78,7 @@
 	cd smtpserver ; $(MAKE) $(MFLAGS) install
 	cd transports ; $(MAKE) $(MFLAGS) install
 	cd libc ; $(MAKE) $(MFLAGS) install
+	cd utils/makendbm ; $(MAKE) $(MFLAGS) install
 	cd support/vacation ; $(MAKE) $(MFLAGS) install
 
 router/router:
@@ -102,6 +105,9 @@
 support/vacation/vacation:
 	cd support/vacation ; $(MAKE) $(MFLAGS) vacation
 
+utils/makendbm/makendbm:
+	cd utils/makendbm ; $(MAKE) $(MFLAGS)
+
 lib/libz.a: lib/*.c
 	cd lib ; $(MAKE) $(MFLAGS)
 
@@ -202,7 +208,7 @@
 	cat SiteConfig | \
 	sed -n	-e '/^\([a-zA-Z][^ 	]*\)[ 	]*=[ 	]*\(.*\)[ 	]*$$/!d' \
 		-e 's/^\([^ 	]*\)[ 	]*=[ 	]*\(.*\)[ 	]*$$/\1="\2"/' \
-		-e 's/^\([^ 	]*\)=""/\1="/' -e 's/""$$/"/'	\
+		-e 's/^\([^ 	]*\)=""\(.*\)""$$/\1="\2"/'	\
 		-e 's/="\([^ 	]*\)"$$/=\1/'			\
 		-e p	) > $@
 # The sed-patterns above do:
diff -u -r zmailer-2.99.38/SiteConfig zmailer-2.99.39/SiteConfig
--- zmailer-2.99.38/SiteConfig	Tue Sep 17 20:43:08 1996
+++ zmailer-2.99.39/SiteConfig	Sat Oct 26 00:19:43 1996
@@ -153,4 +153,4 @@
 # This really should be done with some system ioctl(), but those are
 # damn varying, and often still do kmem reads...
 #SELFADDRESSES=1.2.3.4,2.3.4.5,::1.2.3.4
-SELFADDRESSES=
+SELFADDRESSES= 
diff -u -r zmailer-2.99.38/SiteConfig.in zmailer-2.99.39/SiteConfig.in
--- zmailer-2.99.38/SiteConfig.in	Fri Aug 23 12:38:44 1996
+++ zmailer-2.99.39/SiteConfig.in	Thu Sep 12 19:57:18 1996
@@ -153,4 +153,4 @@
 # This really should be done with some system ioctl(), but those are
 # damn varying, and often still do kmem reads...
 #SELFADDRESSES=1.2.3.4,2.3.4.5,::1.2.3.4
-SELFADDRESSES=@SELFADDRESSES@
+SELFADDRESSES= @SELFADDRESSES@
Only in zmailer-2.99.39: cache.csc.fi
Only in zmailer-2.99.39/compat/rmail: linebuffer.o
Only in zmailer-2.99.39/compat/rmail: revision
Only in zmailer-2.99.39/compat/rmail: rmail
Only in zmailer-2.99.39/compat/rmail: rmail.o
Only in zmailer-2.99.39/compat/rmail: version.c
Only in zmailer-2.99.39/compat/rmail: version.o
Only in zmailer-2.99.39/compat/sendmail: revision
Only in zmailer-2.99.39/compat/sendmail: sendmail
diff -u -r zmailer-2.99.38/compat/sendmail/sendmail.c zmailer-2.99.39/compat/sendmail/sendmail.c
--- zmailer-2.99.38/compat/sendmail/sendmail.c	Mon Aug 19 18:56:50 1996
+++ zmailer-2.99.39/compat/sendmail/sendmail.c	Fri Oct 25 19:46:12 1996
@@ -47,7 +47,8 @@
 extern int runastrusteduser(), runasrootuser();
 extern void prversion(), doabort();
 extern int mail_priority;
-extern void check_and_print_to();
+extern void check_and_print_to __((FILE *, char*, char*));
+extern int is_xtext_string __((char *));
 
 char *progname;
 
@@ -61,6 +62,7 @@
 FILE	*mfp = NULL;
 extern char *postoffice; /* At mail_open() */
 
+
 int
 main(argc, argv)
 	int argc;
@@ -78,6 +80,11 @@
 	char	buf[8192];
 	char   *buf2 = NULL;
 	char	*bodytype = NULL;
+	int	usersubmission = 0;
+	char	*submitprotocol = NULL;
+	char	*notificationopt = NULL;
+	char	*returnopt = NULL;
+	char	*envidstr = NULL;
 
 	if ((cp = strrchr(argv[0], '/')) != NULL)
 		progname = ++cp;
@@ -103,7 +110,7 @@
 	configfile = pooption = NULL;
 	if (printq || aliases)
 		goto otherprog;
-	while ((c = getopt(argc, argv,"B:EJb:e:r:f:h:F:C:d:Oo:P:imnq:stvVx")) != EOF) {
+	while ((c = getopt(argc, argv,"B:C:EF:JN:OP:R:UV:b:d:e:r:f:h:imno:p:q:stvx")) != EOF) {
 		switch (c) {
 		case 'B':
 			/* Sendmail 8.7 compability:
@@ -201,6 +208,27 @@
 		case 'O':	/* for NeXT mail */
 			/* default behavior */
 			break;
+		case 'N':
+			notificationopt = optarg;
+			if (strcasecmp(notificationopt,"never") != 0 &&
+			    strcasecmp(notificationopt,"success") != 0 &&
+			    strcasecmp(notificationopt,"failure") != 0 &&
+			    strcasecmp(notificationopt,"delay") != 0) {
+			  fprintf(stderr,"sendmail: illegal -N -option parameter: '%s'\n",optarg);
+			  exit(EX_USAGE);
+			}
+			break;
+		case 'R':
+			returnopt = optarg;
+			if (strcasecmp(returnopt,"full") != 0 &&
+			    strcasecmp(returnopt,"hdrs") != 0) {
+			  fprintf(stderr,"sendmail: illegal -R -option parameter: '%s'\n",optarg);
+			  exit(EX_USAGE);
+			}
+			break;
+		case 'U':
+			usersubmission = 1;
+			break;
 		case 'v':	/* be verbose */
 			verbose = 1;
 			break;
@@ -208,12 +236,18 @@
 			sprintf(ebp, " -%c", c);
 			ebp += strlen(ebp);
 			break;
+		case 'p':
+			submitprotocol = optarg;
+			break;
 		case 'P':
 			mail_priority = atoi(optarg);
 			break;
 		case 'V':
-			prversion("sendmail");
-			exit(0);
+			envidstr = optarg;
+			if (!is_xtext_string(envidstr)) {
+			  fprintf(stderr,"sendmail: invalid format of -V (envid) parameter: '%s'\n",envidstr);
+			  exit(EX_USAGE);
+			}
 			break;
 		case 'x':	/* Ignore this AIXism */
 			break;
@@ -421,10 +455,17 @@
 		  fprintf(mfp, "fullname %s\n", fullname);
 		if (from != NULL && *from != '\0')
 		  fprintf(mfp, "from %s\n", from);
+		if (envidstr)
+		  fprintf(mfp, "envid %s\n", envidstr);
+		if (returnopt)
+		  fprintf(mfp, "notaryret %s\n", returnopt);
+		if (submitprotocol)
+		  fprintf(mfp, "with %s\n", submitprotocol);
+
 		if (!binary) {
 		  for (; optind < argc; ++optind)
 		    /*fprintf(mfp, "to %s\n", argv[optind]);*/
-		    check_and_print_to(mfp,argv[optind]);
+		    check_and_print_to(mfp,argv[optind],notificationopt);
 		}
 
 		if (fflush(mfp) == EOF
@@ -609,11 +650,12 @@
 
 /* haa@cs.hut.fi:  Sometimes address components contain pure junk.. */
 void
-check_and_print_to(mfp, addr)
+check_and_print_to(mfp, addr, notify)
 	FILE *mfp;
-	char *addr;
+	char *addr, *notify;
 {
 	char *copy = NULL, *printme = addr, *from, *to;
+	char *s;
 
 	if (addr == NULL) {
 	  fprintf(stderr, "sendmail: Argument botch: NULL address\n");
@@ -633,6 +675,19 @@
 	}
 	fprintf(mfp, "to %s\n", printme);
 	if (copy) free(copy);
+	fprintf(mfp, "todsn ORCPT=rfc822;");
+	s = printme;
+	while (*s) {
+	  u_char c = *s;
+	  if ('!' <= c && c <= '~' && c != '+' && c != '=')
+	    putc(c,mfp);
+	  else
+	    fprintf(mfp,"+%02X",c);
+	  ++s;
+	}
+	if (notify)
+	  fprintf(mfp," NOTIFY=%s", notify);
+	putc('\n',mfp);
 }
 
 #if 0
@@ -643,3 +698,27 @@
 	return emalloc(n);
 }
 #endif
+
+int is_xtext_string(str)
+char *str;
+{
+	/* Verify that the input is valid RFC 1981 XTEXT string! */
+
+	while (*str) {
+		unsigned char c = *str;
+		if ('!' <= c && c <= '~' && c != '+' && c != '=')
+		  ; /* is ok! */
+		else if (c == '+') {
+		  c = *++str;
+		  if (!(('0' <= c && c <= '9') || ('A' <= c && c <= 'F')))
+		    return 0; /* Invalid! */
+		  c = *++str;
+		  if (!(('0' <= c && c <= '9') || ('A' <= c && c <= 'F')))
+		    return 0; /* Invalid! */
+		} else {
+		  return 0; /* Is not valid XTEXT string */
+		}
+		++str;
+	}
+	return 1;
+}
Only in zmailer-2.99.39/compat/sendmail: sendmail.o
Only in zmailer-2.99.39/compat/sendmail: version.c
Only in zmailer-2.99.39/compat/sendmail: version.o
Only in zmailer-2.99.38: config.cache
Only in zmailer-2.99.38: config.log
Only in zmailer-2.99.38: config.status
Only in zmailer-2.99.39: configure
diff -u -r zmailer-2.99.38/configure.in zmailer-2.99.39/configure.in
--- zmailer-2.99.38/configure.in	Fri Aug 23 12:41:09 1996
+++ zmailer-2.99.39/configure.in	Thu Sep 12 22:01:12 1996
@@ -371,7 +371,7 @@
 	  fi
 	  LIBS="$t_oldLibs"
 	else
-	  AC_MSG_ERROR([config.cache inconsistency! Delete it, and redo!])
+	  AC_MSG_ERROR([config.cache inconsistency! (gdbm) Delete it, and redo!])
 	fi
       else # Has it in the libc!
 	LIBGDBM=""
@@ -393,35 +393,42 @@
       LIBNDBM="-ldbm"
       t_found_at="dbm library"
     else
-      AC_TRY_LINK([], [dbm_open();], ac_cv_lib_c_dbm_open=yes,
-				     ac_cv_lib_c_dbm_open=no)
-      if test "$ac_cv_lib_c_dbm_open" = no; then
-	if test "x$ac_cv_lib_dbm_dbm_open" = x; then # not set
-	  t_oldLibs="$LIBS"
-	  LIBS="$LIBS -ldbm"
-	  AC_TRY_LINK([], [dbm_open();], ac_cv_lib_dbm_dbm_open=yes,
-					 ac_cv_lib_dbm_dbm_open=no)
-	  if test "$ac_cv_lib_dbm_dbm_open" = yes; then
-	    LIBNDBM="-ldbm"
-	    t_found_at="dbm library"
-	  else
-	    LIBS="$t_oldLibs -ldb"
-	    AC_TRY_LINK([],[dbm_open();], ac_cv_lib_db_dbm_open=yes,
-					  ac_cv_lib_db_dbm_open=no)
-	    if test "$ac_cv_lib_db_dbm_open" = yes ; then
-		LIBNDBM="-ldb"
-		t_found_at="db library"
+      if test "$ac_cv_lib_dbm_dbm_open" = no ; then
+	if test "$ac_cv_lib_db_dbm_open" = yes ; then
+	  LIBNDBM="-ldb"
+	  t_found_at="db library"
+	fi
+      else
+	AC_TRY_LINK([], [dbm_open();],	ac_cv_lib_c_dbm_open=yes,
+					ac_cv_lib_c_dbm_open=no)
+	if test "$ac_cv_lib_c_dbm_open" = no; then
+	  if test "x$ac_cv_lib_dbm_dbm_open" = x; then # not set
+	    t_oldLibs="$LIBS"
+	    LIBS="$LIBS -ldbm"
+	    AC_TRY_LINK([], [dbm_open();], ac_cv_lib_dbm_dbm_open=yes,
+					   ac_cv_lib_dbm_dbm_open=no)
+	    if test "$ac_cv_lib_dbm_dbm_open" = yes; then
+	      LIBNDBM="-ldbm"
+	      t_found_at="dbm library"
 	    else
-		AC_MSG_RESULT([Has <ndbm.h>, but dbm_open() is not at libc, libndbm, nor at libdb ??])
+	      LIBS="$t_oldLibs -ldb"
+	      AC_TRY_LINK([],[dbm_open();], ac_cv_lib_db_dbm_open=yes,
+					    ac_cv_lib_db_dbm_open=no)
+	      if test "$ac_cv_lib_db_dbm_open" = yes ; then
+		  LIBNDBM="-ldb"
+		  t_found_at="db library"
+	      else
+		  AC_MSG_RESULT([Has <ndbm.h>, but dbm_open() is not at libc, libndbm, nor at libdb ??])
+	      fi
 	    fi
+	    LIBS="$t_oldLibs"
+	  else
+	    AC_MSG_ERROR([config.cache inconsistency! (ndbm) Delete it, and redo!])
 	  fi
-	  LIBS="$t_oldLibs"
-	else
-	  AC_MSG_ERROR([config.cache inconsistency! Delete it, and redo!])
+	else # Has it in the libc!
+	  LIBNDBM=""
+	  t_found_at="libc"
 	fi
-      else # Has it in the libc!
-	LIBNDBM=""
-	t_found_at="libc"
       fi
     fi
   fi
@@ -469,7 +476,7 @@
 	  fi
 	  LIBS="$t_oldLibs"
 	else
-	  AC_MSG_ERROR([config.cache inconsistency! Delete it, and redo!])
+	  AC_MSG_ERROR([config.cache inconsistency! (sdbm) Delete it, and redo!])
 	fi
       else # Has it in the libc!
 	LIBSDBM=""
@@ -485,10 +492,6 @@
 # Umm...
 if test "$ac_cv_header_db_h" = yes ; then
   AC_MSG_RESULT([Note:  BSD DB  support is not really integrated!])
-  if test "$ac_cv_header_ndbm_h" = yes -a "$ac_cv_lib_db_dbm_open" = yes ; then
-    AC_MSG_RESULT([Note2: It looks like your NDBM is actually BSD DB compability wrapper])
-    AC_MSG_RESULT([       at libdb -library.  If so, you will succeed with NDBM databases.])
-  fi
   t_found_at="nowhere"
   if test "$ac_cv_lib_c_dbopen" = yes ; then
     LIBDB=""
@@ -514,7 +517,7 @@
 	  fi
 	  LIBS="$t_oldLibs"
 	else
-	  AC_MSG_ERROR([config.cache inconsistency! Delete it, and redo!])
+	  AC_MSG_ERROR([config.cache inconsistency! (db) Delete it, and redo!])
 	fi
       else # Has it in the libc!
 	LIBDB=""
@@ -527,11 +530,16 @@
 	# Well, both at the same library ( -ldb ), which propably
 	# means that  <ndbm.h>  is just an emulation mode at BSD DB.
 	LIBNDBM=""
+    AC_MSG_RESULT([Note: It looks like your NDBM is actually BSD DB compability wrapper at])
+    AC_MSG_RESULT([      libdb -library.  If so, your NDBM databases are actually BSD DB ones..])
   fi
 fi
 
 AC_SUBST(LIBDBMS)
-LIBDBMS="$LIBNDBM $LIBGDBM $LIBSDBM $LIBDB"
+# GDBM must be last as if we have LIBDB at the system instead of real
+# LIBNDBM, we still have ndbm routines, but want to use (likely)
+# ones from LIBDB instead of LIBGDBM...
+LIBDBMS="$LIBNDBM $LIBSDBM $LIBDB $LIBGDBM"
 
 AC_CHECK_HEADERS(string.h fcntl.h limits.h errno.h unistd.h stdlib.h \
     sys/param.h sys/statfs.h sys/fstyp.h mnttab.h mntent.h utime.h \
Only in zmailer-2.99.39/doc: html
diff -u -r zmailer-2.99.38/include/hostenv.h zmailer-2.99.39/include/hostenv.h
--- zmailer-2.99.38/include/hostenv.h	Mon Jul 15 19:49:14 1996
+++ zmailer-2.99.39/include/hostenv.h	Fri Oct 25 12:18:24 1996
@@ -55,7 +55,9 @@
 # ifndef __STDC__
 #  define __(x) ()
 #  ifdef __GNUC__
-#   define const    __const
+#   ifndef const
+#    define const    __const
+#   endif
 #   define volatile __volatile
 #  else
 #   define const
diff -u -r zmailer-2.99.38/include/libc.h zmailer-2.99.39/include/libc.h
--- zmailer-2.99.38/include/libc.h	Mon Jul 15 16:33:03 1996
+++ zmailer-2.99.39/include/libc.h	Fri Oct 25 21:44:37 1996
@@ -28,6 +28,7 @@
 extern FILE * mail_open __((char *type));
 extern int mail_abort __((FILE *fp));
 extern int mail_close __((FILE *fp));
+extern int mail_close_alternate __((FILE *fp, char *where, char *suffix));
 
 /* mail_alloc.c */
 extern char *mail_alloc __((unsigned int nbytes));
diff -u -r zmailer-2.99.38/include/mail.h zmailer-2.99.39/include/mail.h
--- zmailer-2.99.38/include/mail.h	Tue Sep 17 20:42:56 1996
+++ zmailer-2.99.39/include/mail.h	Sat Oct 26 00:23:01 1996
@@ -42,7 +42,7 @@
 #define _CF_BODYFILE	'b'	/* alternate message file for new body */
 #define _CF_SENDER	's'	/* sender triple (channel, host, user) */
 #define _CF_RECIPIENT	'r'	/* recipient n-tuple, n >= 3 */
-#define _CF_DSNRECIPIENT 'R'	/* DSN view of the recipient addr */
+#define _CF_DSNRETMODE 'R'	/* DSN view of the recipient addr */
 #define _CF_XORECIPIENT	'X'	/* one of XOR set of recipient n-tuples */
 #define _CF_RCPTNOTARY	'N'	/* DSN parameters for previous recipient */
 #define _CF_DSNENVID	'n'	/* DSN 'MAIL FROM<> ENVID=XXXX' data */
diff -u -r zmailer-2.99.38/include/mail.h.in zmailer-2.99.39/include/mail.h.in
--- zmailer-2.99.38/include/mail.h.in	Mon Jul 15 20:06:09 1996
+++ zmailer-2.99.39/include/mail.h.in	Sat Oct 26 00:24:19 1996
@@ -42,7 +42,7 @@
 #define _CF_BODYFILE	'b'	/* alternate message file for new body */
 #define _CF_SENDER	's'	/* sender triple (channel, host, user) */
 #define _CF_RECIPIENT	'r'	/* recipient n-tuple, n >= 3 */
-#define _CF_DSNRECIPIENT 'R'	/* DSN view of the recipient addr */
+#define _CF_DSNRETMODE 'R'	/* DSN view of the recipient addr */
 #define _CF_XORECIPIENT	'X'	/* one of XOR set of recipient n-tuples */
 #define _CF_RCPTNOTARY	'N'	/* DSN parameters for previous recipient */
 #define _CF_DSNENVID	'n'	/* DSN 'MAIL FROM<> ENVID=XXXX' data */
diff -u -r zmailer-2.99.38/include/mailer.h zmailer-2.99.39/include/mailer.h
--- zmailer-2.99.38/include/mailer.h	Thu Aug  1 08:43:04 1996
+++ zmailer-2.99.39/include/mailer.h	Fri Oct 25 19:17:21 1996
@@ -169,10 +169,11 @@
 		eEnvid,		/* SMTP-DSN ENVID string */
 		eFrom,		/* envelope sender address */
 		eFullname,	/* use this as my full name, for local users */
+		eNotaryRet,	/* SMTP-DSN RET token: FULL/HDRS */
 		ePrettyLogin,	/* use this as my pretty login name, ditto. */
 		eRcvdFrom,	/* previous host/user in reverse route */
 		eTo,		/* envelope recipient address */
-		eToDSN,		/* DSN RCPT data entries (NOTIFY,ORCPT,RET) */
+		eToDSN,		/* DSN RCPT data entries (NOTIFY,ORCPT) */
 		eUser,		/* user at previous host in rev route */
 		eVerbose,	/* verbose log filename for "mail -v" */
 		eVia,		/* received via <medium> */
Only in zmailer-2.99.39/include: rfc822.entry
diff -u -r zmailer-2.99.38/include/ta.h zmailer-2.99.39/include/ta.h
--- zmailer-2.99.38/include/ta.h	Mon Aug 19 16:30:00 1996
+++ zmailer-2.99.39/include/ta.h	Fri Oct 25 20:28:00 1996
@@ -19,11 +19,11 @@
 	char		**routermxes;	/* [mea] hostpointers from router */
 };
 
-#define _DSN_RET_NO		0x001
-#define _DSN_RET_YES		0x002
+#define _DSN_RET_FULL		0x001
+#define _DSN_RET_HDRS		0x002
 #define _DSN_NOTIFY_SUCCESS	0x004
 #define _DSN_NOTIFY_FAILURE	0x008
-#define _DSN_NOTIFY_ALWAYS	0x010
+#define _DSN_NOTIFY_DELAY	0x010
 #define _DSN_NOTIFY_NEVER	0x020
 
 /* `convertmode' controls the behaviour of the message conversion:
@@ -42,7 +42,7 @@
 	struct rcpt	*next;
 	struct address	*addr;		/* addr.link is the sender address */
 	char		*orcpt;		/* DSN ORCPT= string */
-	int		dsnflags;	/* DSN  RET=, and NOTIFY= flags */
+	char		*notify;	/* DSN NOTIFY= flags */
 	char		***newmsgheader; /* message header line pointer ptr
 					   that points to an address of
 					      ctldesc->msgheaders[index]
@@ -63,6 +63,7 @@
 	char		*logident;	/* message id for logging */
 	char		*verbose;	/* file for verbose logging */
 	char		*envid;		/* DSN ENVID data */
+	char		*dsnretmode;	/* DSN RET=-mode */
 	long		msgbodyoffset;	/* offset of message body in msgfile */
 	long		msgsizeestimate; /* Estimate of the msg size */
 	int		msgfd;		/* message file I/O descriptor */
@@ -203,3 +204,8 @@
 
 /* warning.c */
 extern int warning __(());
+
+#ifndef CISTREQ
+#define  CISTREQ(x, y)      (cistrcmp((char *)(x), (char *)(y)) == 0)
+#define  CISTREQN(x, y, n)  (cistrncmp((char *)(x), (char *)(y), n) == 0)
+#endif
Only in zmailer-2.99.39/lib: allocate.o
Only in zmailer-2.99.39/lib: cfgets.o
Only in zmailer-2.99.39/lib: cleanenv.o
Only in zmailer-2.99.39/lib: detach.o
Only in zmailer-2.99.39/lib: die.o
Only in zmailer-2.99.39/lib: dottedquad.o
Only in zmailer-2.99.39/lib: emalloc.o
Only in zmailer-2.99.39/lib: esyslib.o
Only in zmailer-2.99.39/lib: hostent.o
Only in zmailer-2.99.39/lib: killprev.o
Only in zmailer-2.99.39/lib: linebuffer.o
Only in zmailer-2.99.39/lib: loginit.o
Only in zmailer-2.99.39/lib: nobody.o
Only in zmailer-2.99.39/lib: prversion.o
Only in zmailer-2.99.39/lib: pwdgrp.o
Only in zmailer-2.99.39/lib: ranny.o
Only in zmailer-2.99.39/lib: rfc822date.o
Only in zmailer-2.99.39/lib: rfc822scan.o
Only in zmailer-2.99.39/lib: selfaddrs.o
Only in zmailer-2.99.39/lib: splay.o
Only in zmailer-2.99.39/lib: stringlib.o
Only in zmailer-2.99.39/lib: strmatch.o
Only in zmailer-2.99.39/lib: symbol.o
Only in zmailer-2.99.39/lib: token.o
Only in zmailer-2.99.39/lib: trusted.o
Only in zmailer-2.99.39/libc: __fopen.o
Only in zmailer-2.99.39/libc: fullname.o
Only in zmailer-2.99.39/libc: getdtblsiz.o
Only in zmailer-2.99.39/libc: getopt.o
Only in zmailer-2.99.39/libc: getzenv.o
diff -u -r zmailer-2.99.38/libc/mail.c zmailer-2.99.39/libc/mail.c
--- zmailer-2.99.38/libc/mail.c	Mon Aug 12 00:50:20 1996
+++ zmailer-2.99.39/libc/mail.c	Fri Oct 25 21:46:25 1996
@@ -438,15 +438,16 @@
 
 /*
  * Close the message file on the indicated stream, and submit
- * it to the SCHEDULER. (For smtpserver->scheduler messages.)
+ * it to alternate directory. (For smtpserver->scheduler messages,
+ * for example.)
  */
 
 int
-mail_close_scheduler(fp)
+mail_close_alternate(fp,where,suffix)
 	FILE *fp;
+	char *where, *suffix;
 {
 	char **messagep, *message, *nmessage, *msgbase;
-	char *transportdir;
 	int eno;
 
 	if (postoffice == NULL) {
@@ -492,12 +493,11 @@
 	else
 		++msgbase;
 
-	transportdir = TRANSPORTDIR;
 	nmessage  = NULL;
 	/* Assert postoffice != NULL */
-	nmessage = mail_alloc(strlen(postoffice)+
-			      strlen(transportdir)+strlen(msgbase)+2+1);
-	sprintf(nmessage, "%s/%s/%s", postoffice, transportdir, msgbase);
+	nmessage = mail_alloc(strlen(postoffice)+1+strlen(where)+1+
+			      strlen(msgbase)+strlen(suffix)+1);
+	sprintf(nmessage, "%s/%s/%s%s", postoffice, where, msgbase, suffix);
 
 	/*
 	 * Unfortunately, rename() doesn't guarantee the same inode will
Only in zmailer-2.99.39/libc: mail.o
Only in zmailer-2.99.39/libc: mail_alloc.o
Only in zmailer-2.99.39/libc: mail_host.o
Only in zmailer-2.99.39/libc: myhostname.o
Only in zmailer-2.99.39/libc: strerror.o
Only in zmailer-2.99.39/libc: strsignal.o
Only in zmailer-2.99.39/libc: whathost.o
diff -u -r zmailer-2.99.38/libident/identuser.c zmailer-2.99.39/libident/identuser.c
--- zmailer-2.99.38/libident/identuser.c	Wed Jul 31 08:52:42 1996
+++ zmailer-2.99.39/libident/identuser.c	Thu Oct 17 23:23:03 1996
@@ -120,17 +120,17 @@
 
  dummy = sizeof(sa);
  if (getsockname(fd,(struct sockaddr*)&sa,&dummy) == -1)
-   return -1;
+   return 1;
  if (sa.sin_family != AF_INET)
   {
    errno = EAFNOSUPPORT;
-   return -1;
+   return 2;
   }
  *local = ntohs(sa.sin_port);
  *inlocal = sa.sin_addr;
  dummy = sizeof(sa);
  if (getpeername(fd,(struct sockaddr*)&sa,&dummy) == -1)
-   return -1;
+   return 3;
  *remote = ntohs(sa.sin_port);
  *inremote = sa.sin_addr;
  return 0;
@@ -222,7 +222,7 @@
  if (s == -1)
  {
    signal(SIGPIPE, old_sig);
-   return 0;
+   return "SOCKFAULT1";
  }
  tv.tv_sec = timeout;
  tv.tv_usec = 0;
@@ -233,14 +233,14 @@
  if (r == -1)
  {
    signal(SIGPIPE, old_sig);
-   CLORETS(0)
+   CLORETS("SOCKSELERR")
  }
  if (!FD_ISSET(s,&wfds))
   {
    close(s);
    errno = ETIMEDOUT;
    signal(SIGPIPE, old_sig);
-   return 0;
+   return "TIMEDOUT";
   }
  retval = ident_sockuser(s,local,remote);
  signal(SIGPIPE, old_sig);
@@ -272,12 +272,12 @@
  if ((fl = fcntl(s,F_GETFL,0)) == -1)
  {
    signal(SIGPIPE, old_sig);
-   CLORETS(0);
+   CLORETS("SOCKFCNTL1");
  }
  if (fcntl(s,F_SETFL,~FNDELAY & fl) == -1)
  {
    signal(SIGPIPE, old_sig);
-   CLORETS(0);
+   CLORETS("SOCKFCNTL2");
  }
  buf = realbuf;
  sprintf(buf,"%u , %u\r\n",(unsigned int) remote,(unsigned int) local);
@@ -287,7 +287,12 @@
    if (w == -1) /* should we worry about 0 as well? */
    {
      signal(SIGPIPE, old_sig);
-     CLORETS(0);
+     saveerrno = errno;
+     close(s);
+     if (errno = ECONNREFUSED)
+       return "NO-IDENT-SERVICE";
+     else
+       return "SOCKWRITE";
    }
    else
     {
@@ -305,7 +310,7 @@
   }
  signal(SIGPIPE, old_sig);
  if (w == -1)
-   CLORETS(0)
+   CLORETS("SOCKREAD")
  *buf = 0;
 
  if (sscanf(realbuf,"%hd,%hd: USERID :%*[^:]:%s",&rremote,&rlocal,ruser) < 3)
@@ -315,13 +320,13 @@
    /* makes sense, right? well, not when USERID failed to match ERROR */
    /* but there's no good error to return in that case */
 
-   return 0;
+   return "IDENT-NONSENSE";
   }
  if ((remote != rremote) || (local != rlocal))
   {
    close(s);
    errno = EIO;
-   return 0;
+   return "IDENT-NONSENSE2";
   }
  /* we're not going to do any backslash processing */
  close(s);
Only in zmailer-2.99.39/libresolv: gethnamaddr.o
Only in zmailer-2.99.39/libresolv: getnetbyaddr.o
Only in zmailer-2.99.39/libresolv: getnetbyname.o
Only in zmailer-2.99.39/libresolv: getnetent.o
Only in zmailer-2.99.39/libresolv: getnetnamadr.o
Only in zmailer-2.99.39/libresolv: herror.o
Only in zmailer-2.99.39/libresolv: hostnamelen.o
Only in zmailer-2.99.39/libresolv: inet_addr.o
Only in zmailer-2.99.39/libresolv: inet_ntoa.o
Only in zmailer-2.99.39/libresolv: inet_ntop.o
Only in zmailer-2.99.39/libresolv: inet_pton.o
Only in zmailer-2.99.39/libresolv: nsap_addr.o
Only in zmailer-2.99.39/libresolv: res_comp.o
Only in zmailer-2.99.39/libresolv: res_data.o
Only in zmailer-2.99.39/libresolv: res_debug.o
Only in zmailer-2.99.39/libresolv: res_init.o
Only in zmailer-2.99.39/libresolv: res_mkquery.o
Only in zmailer-2.99.39/libresolv: res_query.o
Only in zmailer-2.99.39/libresolv: res_send.o
Only in zmailer-2.99.39/libresolv: sethostent.o
Only in zmailer-2.99.39/libs: libident.a
Only in zmailer-2.99.39/libs: libresolv.a
Only in zmailer-2.99.39/libs: libsh.a
Only in zmailer-2.99.39/libs: libta.a
Only in zmailer-2.99.39/libs: libtag
Only in zmailer-2.99.39/libs: libz.a
Only in zmailer-2.99.39/libs: libzc.a
Only in zmailer-2.99.39/libs: libzmailer.a
Only in zmailer-2.99.39/libs: libzmdb.a
Only in zmailer-2.99.39/libsh: builtins.o
Only in zmailer-2.99.39/libsh: execute.o
Only in zmailer-2.99.39/libsh: expand.o
Only in zmailer-2.99.39/libsh: interpret.o
Only in zmailer-2.99.39/libsh: io.o
Only in zmailer-2.99.39/libsh: jobcontrol.o
Only in zmailer-2.99.39/libsh: listtrees.o
Only in zmailer-2.99.39/libsh: listutils.o
Only in zmailer-2.99.39/libsh: mail.o
Only in zmailer-2.99.39/libsh: optimizer.o
Only in zmailer-2.99.39/libsh: path.o
Only in zmailer-2.99.39/libsh: prompt.o
Only in zmailer-2.99.39/libsh: regex.o
Only in zmailer-2.99.39/libsh: sh-in.i
Only in zmailer-2.99.39/libsh: sh-out.i
Only in zmailer-2.99.39/libsh: sh-procs.i
Only in zmailer-2.99.39/libsh: sh.entry
Only in zmailer-2.99.39/libsh: sh.lst
Only in zmailer-2.99.39/libsh: sh.sst.c
Only in zmailer-2.99.39/libsh: sh.sst.h
Only in zmailer-2.99.39/libsh: sslwalker.o
Only in zmailer-2.99.39/libsh: test.o
Only in zmailer-2.99.39/libsh: trap.o
Only in zmailer-2.99.39/libsh: tregexp.o
Only in zmailer-2.99.39/libsh: variables.o
Only in zmailer-2.99.39/libsh: zmsh.o
diff -u -r zmailer-2.99.38/man/smtp.8 zmailer-2.99.39/man/smtp.8
--- zmailer-2.99.38/man/smtp.8	Sun Aug 18 16:59:51 1996
+++ zmailer-2.99.39/man/smtp.8	Fri Sep 20 14:30:21 1996
@@ -6,7 +6,7 @@
 .SH SYNOPSIS
 .B smtp
 [
-.B \-78deErPsVxW
+.B \-78deEHrPsVxW
 ]
 [
 .B \-c
@@ -74,6 +74,9 @@
 .IR gethostname (2)
 or
 .IR uname (2).
+.IP \-H
+Disable the per default active forced 8-bit headers conversion into
+.IR MIME-2 -format.
 .IP \-l\ \fIlogfile\fR
 specifies a log file where the complete SMTP command transaction will be
 copied.  Each line in the log will be prefixed with the process id of
Only in zmailer-2.99.39/proto/cf: TELE-FI.cf
diff -u -r zmailer-2.99.38/proto/mailrm.sh.old zmailer-2.99.39/proto/mailrm.sh.old
--- zmailer-2.99.38/proto/mailrm.sh.old	Wed Aug  7 00:19:30 1996
+++ zmailer-2.99.39/proto/mailrm.sh.old	Thu Sep 12 19:55:28 1996
@@ -1,6 +1,6 @@
 # !/bin/sh -
 
-ZCONFIG=/home/mea/mail/zmailer.conf
+ZCONFIG=/etc/zmailer.conf
 . $ZCONFIG
 
 cd $POSTOFFICE/transport || exit 1
diff -u -r zmailer-2.99.38/proto/newaliases.old zmailer-2.99.39/proto/newaliases.old
--- zmailer-2.99.38/proto/newaliases.old	Wed Aug  7 00:19:30 1996
+++ zmailer-2.99.39/proto/newaliases.old	Thu Sep 12 19:55:28 1996
@@ -1,4 +1,4 @@
-#! /home/mea/mail/bin/router -f
+#! /opt/mail/bin/router -f
 #  /l/mail/bin/router -f
 # This zshell script recreates the traditional aliases file database.
 #
@@ -6,7 +6,7 @@
 # invoking this file, remember the total length of the command's path is
 # limited to 30 characters or so.
 #
-ZCONFIG=/home/mea/mail/zmailer.conf
+ZCONFIG=/etc/zmailer.conf
 
 . $ZCONFIG
 
diff -u -r zmailer-2.99.38/proto/zmailer.sh.old zmailer-2.99.39/proto/zmailer.sh.old
--- zmailer-2.99.38/proto/zmailer.sh.old	Wed Aug  7 00:19:29 1996
+++ zmailer-2.99.39/proto/zmailer.sh.old	Thu Sep 12 19:55:28 1996
@@ -10,7 +10,7 @@
 #	Some hacking by Matti Aarnio, Copyright 1990-1995
 #
 PATH=/bin:/usr/bin:/usr/ucb
-ZCONFIG=/home/mea/mail/zmailer.conf
+ZCONFIG=/etc/zmailer.conf
 
 export PATH
 
diff -u -r zmailer-2.99.38/router/.gdbinit zmailer-2.99.39/router/.gdbinit
--- zmailer-2.99.38/router/.gdbinit	Thu Aug 24 19:41:49 1995
+++ zmailer-2.99.39/router/.gdbinit	Thu Oct 24 14:44:06 1996
@@ -4,4 +4,4 @@
 directory ../libsh
 directory ../libmalloc
 directory ../lib
-cd /usr/spool/postoffice/router
+#cd /var/spool/postoffice/router
diff -u -r zmailer-2.99.38/router/Makefile zmailer-2.99.39/router/Makefile
--- zmailer-2.99.38/router/Makefile	Tue Sep 17 20:42:23 1996
+++ zmailer-2.99.39/router/Makefile	Sat Oct 26 00:19:19 1996
@@ -43,7 +43,7 @@
 
 all $(PROGRAM)-a:	$(TOPDIR)/include/rfc822.entry $(LIBDEB) $(PROGRAM)
 
-$(PROGRAM): $(TOPDIR)/include/rfc822.entry $(LIBDEB) version.o
+$(PROGRAM): $(TOPDIR)/include/rfc822.entry $(LIBDEB) version.o $(OBJS)
 	$(CC) $(CFLAGS) -o $@.x $(OBJS) version.o $(LIB) $(ROUTER_LIB)
 	mv $@.x $@
 
diff -u -r zmailer-2.99.38/router/Makefile.in zmailer-2.99.39/router/Makefile.in
--- zmailer-2.99.38/router/Makefile.in	Fri Aug  9 19:37:44 1996
+++ zmailer-2.99.39/router/Makefile.in	Fri Oct 25 18:51:59 1996
@@ -43,7 +43,7 @@
 
 all $(PROGRAM)-a:	$(TOPDIR)/include/rfc822.entry $(LIBDEB) $(PROGRAM)
 
-$(PROGRAM): $(TOPDIR)/include/rfc822.entry $(LIBDEB) version.o
+$(PROGRAM): $(TOPDIR)/include/rfc822.entry $(LIBDEB) version.o $(OBJS)
 	$(CC) $(CFLAGS) -o $@.x $(OBJS) version.o $(LIB) $(ROUTER_LIB)
 	mv $@.x $@
 
Only in zmailer-2.99.39/router: conf.o
Only in zmailer-2.99.39/router: dateparse.o
Only in zmailer-2.99.39/router: db.o
diff -u -r zmailer-2.99.38/router/functions.c zmailer-2.99.39/router/functions.c
--- zmailer-2.99.38/router/functions.c	Sun Aug 11 21:01:22 1996
+++ zmailer-2.99.39/router/functions.c	Fri Oct 25 19:04:41 1996
@@ -1266,9 +1266,11 @@
 	struct siobuf *osiop;
 	FILE *mfp, *fp, f;
 	char buf[4096];
+	char DSNbuf[4096+200];
 	int fd2;
 	char *olderrors = errors_to;
 	volatile FILE *errstr = stderr;
+	char *notary = NULL;
 
 	extern struct conscell *s_value;
 
@@ -1284,17 +1286,32 @@
 	  switch( il->string[1] ) {
 	    case 'c':
 	      comment = (char*)cdr(il)->string;
+	      if (strchr(comment,'\n') != NULL ||
+		  strchr(comment,'\r') != NULL)
+		errflag = 1;
 	      break;
 	    case 'p':
 	      privilege = atoi((char*)cdr(il)->string);
 	      break;
 	    case 'e':
 	      erroraddress = (char*)cdr(il)->string;
+	      if (strchr(erroraddress,'\n') != NULL ||
+		  strchr(erroraddress,'\r') != NULL)
+		errflag = 1;
 	      break;
 	    case 'E':
 	      if (errors_to != olderrors)
 		free(errors_to);
 	      errors_to = strdup((char*)cdr(il)->string);
+	      if (strchr(errors_to,'\n') != NULL ||
+		  strchr(errors_to,'\r') != NULL)
+		errflag = 1;
+	      break;
+	    case 'N':
+	      notary = (char *)cdr(il)->string;
+	      if (strchr(notary,'\n') != NULL ||
+		  strchr(notary,'\r') != NULL)
+		errflag = 1;
 	      break;
 	    default:
 	      errflag = 1;
@@ -1311,8 +1328,8 @@
 
 	if (errflag || cnt != 3) {
 		fprintf(stderr,
-			"Usage: %s [ -e error-address ] [ -E errors-to-address ] [-p privilege] [ -c comment ] $attribute $localpart $origaddr < /file/path \n",
-			car(avl)->string);
+			"Usage: %s [ -e error-address ] [ -E errors-to-address ] [-p privilege] [ -c comment ] [ -N notarystring ] $attribute $localpart $origaddr < /file/path \n",
+		car(avl)->string);
 		if (errors_to != olderrors)
 		  free(errors_to);
 		errors_to = olderrors;
@@ -1468,6 +1485,7 @@
 		char *av[5];
 		int rc;
 		struct conscell *l, *d, *lrc;
+		char *s, *s2, *se;
 
 		buf[0] = 0;
 		pureAddressBuf(buf,sizeof(buf),ap->a_tokens);
@@ -1478,10 +1496,37 @@
 
 #define use_lapply 1
 #ifdef use_lapply
-		/* XX: We leak these at the moment! */
 		l       = newstring((u_char*)strsave(buf));
 		cdr(l)  = conststring((u_char*)origaddr);
-		cddr(l) = car(attributes);
+		*DSNbuf = 0;
+		if (notary != NULL)
+		  strncpy(DSNbuf,notary,sizeof(DSNbuf)-30);
+		DSNbuf[sizeof(DSNbuf)-30] = 0; /* Be brutal, and chop
+						  off the tail, if it is
+						  too long.. */
+		s2 = strlen(DSNbuf)+DSNbuf;
+		if (s2 > DSNbuf)
+		  strcpy(s2++," ");
+		strcpy(s2,"ORCPT=rfc822;");
+		s2 += strlen(s2);
+		se = DSNbuf + sizeof(DSNbuf)-1; /* BUF-end */
+		s = buf;
+		while (*s) {
+		  u_char c = *s;
+		  if ('!' <= c && c <= '~' && c != '+' && c != '=')
+		    if (s2 < se)
+		      *s2++ = c;
+		  else if (s2 < se) {
+		    sprintf(s2,"+%02X",c);
+		    s2 += 3;
+		  }
+		  ++s;
+		}
+		*s2 = 0;
+		s = build_gensym(privilege,"recipient",DSNbuf,errors_to);
+
+		lrc = newstring((u_char*)strsave(s));
+		cddr(l) = lrc;
 		l = ncons(l);
 
 		deferit = 0;
@@ -1490,6 +1535,7 @@
 		rc = l_apply("rrouter", l);
 		lrc = s_value;
 		s_value = NULL;
+		s_free_tree(l); /* We can clean up the input list */
 #else
 		lrc = router(ap, privilege, "recipient");
 		rc = (lrc == NULL);
Only in zmailer-2.99.39/router: functions.o
diff -u -r zmailer-2.99.38/router/libdb/header.c zmailer-2.99.39/router/libdb/header.c
--- zmailer-2.99.38/router/libdb/header.c	Thu Aug  8 20:58:03 1996
+++ zmailer-2.99.39/router/libdb/header.c	Fri Oct 25 19:15:46 1996
@@ -69,6 +69,7 @@
 { "fullname",		Phrase,		nilUserType,	eFullname	},
 { "identinfo",	nilHeaderSemantics,	nilUserType,	eIdentinfo	},
 { "loginname",		UserAtDomain,	nilUserType,	ePrettyLogin	},
+{ "notaryret",	nilHeaderSemantics,	nilUserType,	eNotaryRet	},
 { "rcvdfrom",		DomainName,	nilUserType,	eRcvdFrom	},
 { "to",			AddressList,	Recipient,	eTo		},
 { "todsn",	nilHeaderSemantics,	Recipient,	eToDSN		},
diff -u -r zmailer-2.99.38/router/prototypes.h zmailer-2.99.39/router/prototypes.h
--- zmailer-2.99.38/router/prototypes.h	Thu Aug  8 21:00:12 1996
+++ zmailer-2.99.39/router/prototypes.h	Thu Oct 24 09:36:38 1996
@@ -127,7 +127,6 @@
 extern RETSIGTYPE sig_hup __((int));
 extern int	run_daemon __((int argc, char *argv[]));
 extern int	gensym;
-extern char	*gs_name;
 extern void	optsave __((int type, struct envelope *e));
 
 /* File: rfc822.c */
@@ -201,6 +200,7 @@
 extern int	n_apply __((char **cpp, int argc, char *argv[]));
 extern struct header *hdr_rewrite __((u_char *name, struct header *h));
 extern void	setenvinfo __((struct envelope *e));
+extern char     *build_gensym __((int uid, char *type, char *DSNstr, char *errors_to));
 extern struct conscell *router __((struct address *a, int uid, char *type));
 extern struct conscell *crossbar __((struct conscell *from, struct conscell *to));
 
Only in zmailer-2.99.39/router: revision
diff -u -r zmailer-2.99.38/router/rfc822.c zmailer-2.99.39/router/rfc822.c
--- zmailer-2.99.38/router/rfc822.c	Tue Aug 20 12:16:11 1996
+++ zmailer-2.99.39/router/rfc822.c	Fri Oct 25 19:42:45 1996
@@ -1121,7 +1121,8 @@
 	int def_uid, header_error, perr;
 	FILE *ofp, *vfp;
 	char vbuf[2048], verbosefile[1024];
-	char *envid = NULL;
+	char *envid;
+	char *notaryret;
 
 	errors_to = NULL; /* to be gotten rid off.. */
 
@@ -1218,6 +1219,12 @@
 	    && h->h_contents.a->a_pname != NULL) {
 		envid = (char*)h->h_contents.a->a_pname;
 	}
+	FindEnvelope(eNotaryRet);
+	notaryret = NULL;
+	if (h != NULL && h->h_contents.a != NULL
+	    && h->h_contents.a->a_pname != NULL) {
+		notaryret = (char*)h->h_contents.a->a_pname;
+	}
 	FindEnvelope(eFrom);
 	if (h == NULL && e->e_trusted) {
 		/* Perhaps  'channel error' ??? */
@@ -1770,6 +1777,9 @@
 	if (envid != NULL)
 		fprintf(ofp, "%c%c%s\n",
 			_CF_DSNENVID, _CFTAG_NORMAL, envid);
+	if (notaryret != NULL)
+		fprintf(ofp, "%c%c%s\n",
+			_CF_DSNRETMODE, _CFTAG_NORMAL, notaryret);
 	if (e->e_messageid != NULL)
 		fprintf(ofp, "%c%c%s\n",
 			_CF_LOGIDENT, _CFTAG_NORMAL, e->e_messageid);
Only in zmailer-2.99.39/router: rfc822.o
Only in zmailer-2.99.39/router: rfc822.sst.c
Only in zmailer-2.99.39/router: rfc822.sst.h
Only in zmailer-2.99.39/router: rfc822hdrs.o
Only in zmailer-2.99.39/router: rfc822walk.o
Only in zmailer-2.99.39/router: router
Only in zmailer-2.99.39/router: router.o
diff -u -r zmailer-2.99.38/router/shliaise.c zmailer-2.99.39/router/shliaise.c
--- zmailer-2.99.38/router/shliaise.c	Tue Jan  9 13:44:53 1996
+++ zmailer-2.99.39/router/shliaise.c	Fri Oct 25 19:01:22 1996
@@ -343,6 +343,49 @@
 }
 
 /*
+ * Build gensym
+ */
+char *
+build_gensym(uid,type,DSNstr,errors_to)
+int uid;
+char *type, *DSNstr, *errors_to;
+{
+	static char gsbuf[30];
+	char buf[20];
+	struct conscell *l, *lc, *tmp;
+
+	/* assemble the default attribute list: (privilege <uid>) */
+	l = conststring((u_char *)"privilege");
+	sprintf(buf, "%d", uid);
+	cdr(l) = newstring((u_char *)strsave(buf));
+	lc = cdr(l);
+	if (type != NULL) {
+		cdr(lc) = conststring((u_char *)"type");
+		lc = cdr(lc);
+		cdr(lc) = newstring((u_char *)strsave(type));
+		lc = cdr(lc);
+	}
+	if (DSNstr != NULL) {
+		cdr(lc) = conststring((u_char *)"DSN");
+		lc = cdr(lc);
+		cdr(lc) = newstring((u_char *)strsave(DSNstr));
+		lc = cdr(lc);
+	}
+	/* See if some "errorsto" definition is available.. */
+	if (errors_to != NULL) {
+		cdr(lc) = conststring((u_char *)"ERR");
+		lc = cdr(lc);
+		cdr(lc) = newstring((u_char *)strsave(errors_to));
+		lc = cdr(lc);
+	}
+	l = ncons(l);
+	sprintf(gsbuf, gs_name, gensym++);
+	/* gX (name in gsbuf) will be freed by free_gensym() later */
+	v_setl(gsbuf, l);
+	return gsbuf;
+}
+
+/*
  * The router function must return three values,
  *	a (channel, host, user) triple.
  *
@@ -361,13 +404,16 @@
 	struct token *last;
 	struct addr *p;
 	struct conscell *l, *lc, *tmp;
-	char buf[30], gsbuf[30];
+	char buf[30], *gsym;
 	struct notary *DSN = NULL;
+	char *DSNstr;
 
 	if (a == NULL)
 		return NULL;
 	t = last = NULL;
 	DSN = a->a_dsn;
+	DSNstr = NULL;
+	if (DSN) DSNstr = DSN->dsn;
 	for (p = a->a_tokens; p != NULL; p = p->p_next)
 		if (p->p_type == anAddress) {
 			/* link up all address tokens together */
@@ -391,43 +437,16 @@
 	if (t->t_pname[0] == '<' && TOKENLEN(t) == 1 && t->t_next == NULL)
 		abort();
 
-	/* assemble the default attribute list: (privilege <uid>) */
-	l = conststring((u_char *)"privilege");
-	sprintf(buf, "%d", uid);
-	cdr(l) = newstring((u_char *)buf);
-	lc = cdr(l);
-	if (type != NULL) {
-		cdr(lc) = conststring((u_char *)"type");
-		lc = cdr(lc);
-		cdr(lc) = newstring((u_char *) type );
-		lc = cdr(l);
-	}
-	if (DSN != NULL && DSN->dsn != NULL) {
-		cdr(lc) = conststring((u_char *)"DSN");
-		lc = cdr(lc);
-		cdr(lc) = conststring((u_char *)DSN->dsn);
-		lc = cdr(lc);
-	}
-	/* See if some "errorsto" definition is available.. */
-	if (errors_to != NULL) {
-		cdr(lc) = conststring((u_char *)"ERR");
-		lc = cdr(lc);
-		cdr(lc) = newstring((u_char *)strsave(errors_to));
-		lc = cdr(lc);
-	}
-	l = ncons(l);
-	sprintf(gsbuf, gs_name, gensym++);
-	/* g0 (name in gsbuf) will be freed by free_gensym() later */
-	v_setl(gsbuf, l);
+	gsym = build_gensym(uid,type,DSNstr,errors_to);
 
 	deferit = 0;
 	v_set(DEFER, "");
-	r = s_rewrite(ROUTER, t, (u_char *)gsbuf);
+	r = s_rewrite(ROUTER, t, (u_char *)gsym);
 #if 0
 	if (deferit) {
 		s_free_tree(s_value);
 		s_value = NULL;
-		r = s_rewrite(DEFERENV, t, (u_char *)gsbuf);
+		r = s_rewrite(DEFERENV, t, (u_char *)gsym);
 	}
 #endif
 	if (r != 0 || s_value == NULL || !LIST(s_value)) {
Only in zmailer-2.99.39/router: shliaise.o
Only in zmailer-2.99.39/router: version.c
Only in zmailer-2.99.39/router: version.o
Only in zmailer-2.99.39/scheduler: agenda.o
Only in zmailer-2.99.39/scheduler: conf.o
Only in zmailer-2.99.39/scheduler: mailq
Only in zmailer-2.99.39/scheduler: mailq.o
diff -u -r zmailer-2.99.38/scheduler/msgerror.c zmailer-2.99.39/scheduler/msgerror.c
--- zmailer-2.99.38/scheduler/msgerror.c	Mon Aug 19 17:29:26 1996
+++ zmailer-2.99.39/scheduler/msgerror.c	Fri Oct 25 22:55:15 1996
@@ -40,7 +40,8 @@
 
 struct not {
 	char *not;
-	char *dsn;
+	char *orcpt;
+	char *notify;
 	char *rcpt;
 	char *rcpntp;
 };
@@ -106,13 +107,13 @@
 	    typetag = type_local;
 	} else
 	  typetag = type_local;
+	if (notary->orcpt)
+	  fprintf(errfp, "Original-Recipient: %s\n", notary->orcpt);
 	fprintf(errfp, "Final-Recipient: %s; %s\n", typetag, rcpt);
 	fprintf(errfp, "Action: %s\n", action);
 	if (status)
 	  fprintf(errfp, "Status: %s\n", status);
 	fprintf(errfp, "Diagnostic-Code: %s\n", diagnostic);
-	if (notary->dsn)
-	  fprintf(errfp, "X-DSN: %s\n", notary->dsn);
 	if (wtt && wtt[0] != 0)
 	  fprintf(errfp, "Remote-MTA: %s\n", wtt);
 	fprintf(errfp, "\n");
@@ -261,11 +262,92 @@
 	for (i = 0; i < cfp->nlines; ++i, ++lp) {
 	  cp = cfp->contents + *lp;
 
-	  /* Line fmt:
-	     <TAGS> offset ':' headeroffset <TAB> NOTARY-DATA <TAB> MESSAGE <NL> */
-
 	  if (!(*cp == _CF_DIAGNOSTIC && *++cp == _CFTAG_NORMAL))
 	    continue;
+
+	  /* Line fmt:
+	     <TAGS> offset ':' headeroffset ':' drptidx <TAB> NOTARY-DATA <TAB> MESSAGE <NL> */
+
+	  cp = cfp->contents + *lp + 2;
+
+	  byteidx = atoi(cp);
+	  while (*cp  && isascii(*cp) && isdigit(*cp))
+	    ++cp;
+	  headeridx = -1;
+	  if (*cp == ':') {
+	    ++cp;
+	    headeridx = atoi(cp);
+	    while (*cp && isascii(*cp) && (isdigit(*cp) || *cp == '-'))
+	      ++cp;
+	  }
+	  drptidx = -1;
+	  if (*cp == ':') {
+	    ++cp;
+	    drptidx = atoi(cp);
+	    while (isascii(*cp) && (isdigit(*cp) || *cp == '-'))
+	      ++cp;
+	  }
+	  if (*cp == ':') {
+	    int offs = atoi(++cp);
+	    if (offs > 0)
+	      dnsrecipient = cfp->contents + offs;
+	    while (isascii(*cp) && (isdigit(*cp) || *cp == '-'))
+	      ++cp;
+	  }
+	  notary = NULL;
+	  if (*cp == '\t') {
+	    notary = ++cp;
+	    while (*cp && *cp != '\t') ++cp;
+	    notary = strnsave(notary, cp-notary); /* Make a copy of it */
+	    ++cp;
+	  }
+	  rcpntpointer = cfp->contents + byteidx + 2 + _CFTAG_RCPTPIDSIZE;
+	  if (notary != NULL && *notary != 0) {
+	    if (!notaries) {
+	      notaryspc = 8;
+	      notaries = (void*)emalloc(sizeof(struct not)*(notaryspc+1));
+	    }
+	    if (notarycnt >= notaryspc) {
+	      notaryspc += 8;
+	      notaries = (void*)erealloc((void*)notaries,
+					 sizeof(struct not)*(notaryspc+1));
+	    }
+	    notaries[notarycnt].not    = notary;
+	    notaries[notarycnt].orcpt  = NULL;
+	    notaries[notarycnt].notify = NULL;
+	    notaries[notarycnt].rcpt   = dnsrecipient;
+	    notaries[notarycnt].rcpntp = rcpntpointer;
+	    if (drptidx > 0) {
+	      char *d = cfp->contents + drptidx;
+	      while (*d) {
+		while (*d != 0 && (*d == ' ' || *d == '\t')) ++d;
+		if (CISTREQN(d,"ORCPT=",6)) {
+		  notaries[notarycnt].orcpt = d+6;
+		  d += 6;
+		  while (*d != 0 && (*d != ' ' && *d != '\t')) ++d;
+		  if (*d) *d++ = 0;
+		  continue;
+		}
+		if (CISTREQN(d,"NOTIFY=",7)) {
+		  notaries[notarycnt].orcpt = d+7;
+		  d += 7;
+		  while (*d != 0 && (*d != ' ' && *d != '\t')) ++d;
+		  if (*d) *d++ = 0;
+		  continue;
+		}
+		/* XX: Other junk at DSN parameter string ? */
+		while (*d != 0 && (*d != ' ' && *d != '\t')) ++d;
+		if (*d) *d++ = 0;
+		continue;
+	      }
+	      if (notaries[notarycnt].notify != NULL &&
+		  CISTREQN(notaries[notarycnt].notify,"NEVER",5))
+		continue; /* Don't report on this recipient! */
+	    }
+	    ++notarycnt;
+	    notaries[notarycnt].not = NULL;
+	  }
+
 	  if (!wroteheader) {
 	    if (*eaddr == '|' /* Nobody's address starts with a pipe ? */ ||
 		(*eaddr == '/' &&
@@ -323,65 +405,19 @@
 	    }
 	    /* fprintf(errfp, "\n"); -- not needed ?? */
 	    wroteheader = 1;
-	  }
-	  
-	  /* Line fmt:
-	     <TAGS> offset ':' headeroffset ':' drptidx <TAB> NOTARY-DATA <TAB> MESSAGE <NL> */
 
-	  cp = cfp->contents + *lp + 2;
-	  byteidx = atoi(cp);
-	  while (*cp  && isascii(*cp) && isdigit(*cp))
-	    ++cp;
-	  headeridx = -1;
-	  if (*cp == ':') {
-	    ++cp;
-	    headeridx = atoi(cp);
-	    while (*cp && isascii(*cp) && (isdigit(*cp) || *cp == '-'))
-	      ++cp;
-	  }
-	  drptidx = -1;
-	  if (*cp == ':') {
-	    ++cp;
-	    drptidx = atoi(cp);
-	    while (isascii(*cp) && (isdigit(*cp) || *cp == '-'))
-	      ++cp;
-	  }
-	  if (*cp == ':') {
-	    int offs = atoi(++cp);
-	    if (offs > 0)
-	      dnsrecipient = cfp->contents + offs;
-	    while (isascii(*cp) && (isdigit(*cp) || *cp == '-'))
-	      ++cp;
-	  }
-	  notary = NULL;
-	  if (*cp == '\t') {
-	    notary = ++cp;
-	    while (*cp && *cp != '\t') ++cp;
-	    notary = strnsave(notary, cp-notary); /* Make a copy of it */
-	    ++cp;
-	  }
-	  rcpntpointer = cfp->contents + byteidx + 2 + _CFTAG_RCPTPIDSIZE;
-	  if (notary != NULL && *notary != 0) {
-	    if (!notaries) {
-	      notaryspc = 8;
-	      notaries = (void*)emalloc(sizeof(struct not)*(notaryspc+1));
-	    }
-	    if (notarycnt >= notaryspc) {
-	      notaryspc += 8;
-	      notaries = (void*)erealloc((void*)notaries,
-					 sizeof(struct not)*(notaryspc+1));
-	    }
-	    notaries[notarycnt].not    = notary;
-	    notaries[notarycnt].dsn    = NULL;
-	    notaries[notarycnt].rcpt   = dnsrecipient;
-	    notaries[notarycnt].rcpntp = rcpntpointer;
-	    if (drptidx > 0) {
-	      notaries[notarycnt].dsn = cfp->contents + drptidx;
-	    }
-	    ++notarycnt;
-	    notaries[notarycnt].not = NULL;
+	  } /* End of failure list processing */
+
+	  if (notaries == NULL) {
+	    /* Oops!  No recipients on which to report anything ?! */
+	    mail_abort(errfp);
+	    close(cfp->fd);
+	    cfp->mid = NULL; /* we don't want to loose the original one! */
+	    free_cfp_memory(cfp);
+	    return;
 	  }
 
+	  
 	  /* Scan to the start of the message text */
 	  while (isascii(*cp) && isspace(*cp))
 	    ++cp;
@@ -465,9 +501,11 @@
 	      fseek(fp,(off_t)0,0);
 	    }
 	  }
-	  /* Copy out the rest with somewhat more efficient method */
-	  while ((n = fread(buf, sizeof buf[0], sizeof buf, fp)) > 0)
-	    fwrite(buf, sizeof buf[0], n, errfp);
+	  if (!cfp->dsnretmode || CISTREQN(cfp->dsnretmode,"FULL",4)) {
+	    /* Copy out the rest (=body) with somewhat more efficient method */
+	    while ((n = fread(buf, sizeof buf[0], sizeof buf, fp)) > 0)
+	      fwrite(buf, sizeof buf[0], n, errfp);
+	  }
 	  fclose(fp);
 	} else {
 	  fprintf(stderr,"Could not open message body file: '%s'\n",path);
@@ -476,7 +514,7 @@
 	fprintf(errfp, "--%s--\n", boundarystr);
 
 	if (no_error_report > 0)
-	  mail_abort(errfp);
+	  mail_close_alternate(errfp,POSTMANDIR,":error-on-error");
 	else
 	  mail_close(errfp);	/* XX: check for error */
 	close(cfp->fd);
Only in zmailer-2.99.39/scheduler: msgerror.o
Only in zmailer-2.99.39/scheduler: pipes.o
Only in zmailer-2.99.39/scheduler: qprint.o
Only in zmailer-2.99.39/scheduler: readconfig.o
Only in zmailer-2.99.39/scheduler: resources.o
Only in zmailer-2.99.39/scheduler: revision
Only in zmailer-2.99.38/scheduler: sc.tar.gz
Only in zmailer-2.99.39/scheduler: scheduler
diff -u -r zmailer-2.99.38/scheduler/scheduler.c zmailer-2.99.39/scheduler/scheduler.c
--- zmailer-2.99.38/scheduler/scheduler.c	Mon Aug 19 17:29:53 1996
+++ zmailer-2.99.39/scheduler/scheduler.c	Fri Oct 25 23:13:48 1996
@@ -1120,6 +1120,8 @@
 		cfp->msgbodyoffset = atoi(s+2);
 	      } else if (*s == _CF_DSNENVID) {
 		/* cfp->envid = strsave(s+2); */
+	      } else if (*s == _CF_DSNRETMODE) {
+		/* cfp->dsnretmode = strsave(s+2); */
 	      } else if (*s == _CF_MESSAGEID) {
 		/* cfp->mid = strsave(s+2); */
 	      } else if (*s == _CF_LOGIDENT) {
@@ -1228,6 +1230,7 @@
 	struct offsort *offarr;
 	int offspc;
 	long ino;
+	int prevrcpt = -1;
 
 	char fpath[128], path[128], path2[128];
 
@@ -1288,8 +1291,12 @@
 	  /* Calculate summary info */
 	  if (cp[-1] == _CF_RECIPIENT) {
 	    cfp->rcpnts_total += 1;
-	    if (*cp == _CFTAG_NOTOK)   cfp->rcpnts_failed += 1;
-	    else if (*cp == _CFTAG_OK) cfp->rcpnts_work   += 1;
+	    if (*cp == _CFTAG_NOTOK) {
+	      cfp->rcpnts_failed += 1;
+	      prevrcpt = -1;
+	    } else if (*cp == _CFTAG_OK) {
+	      cfp->rcpnts_work   += 1;
+	    }
 	  }
 	  if (*cp == _CFTAG_NORMAL ||
 	      *cp == '\n' /* This appears for msg-header entries.. */ ) {
@@ -1327,64 +1334,22 @@
 	      offarr[opcnt].headeroffset = -1;
 	      offarr[opcnt].drptoffset = -1;
 	      offarr[opcnt].sender = latest_sender;
+	      prevrcpt = opcnt;
 	      ++opcnt;
 	      break;
 	    case _CF_RCPTNOTARY:
-	      /* XX: IETF-NOTARY-DRPT DATA! */
-	      offarr[svn].drptoffset = *lp + 2;
-#if 0 /* ---------------------------------------------------------------- */
-	      /* This fragment is pulled from transports/libta/ctlopen.c */
-	      ++s;
-	      while (*s) {
-		while (*s && (*s == ' ' || *s == '\t')) ++s;
-		if (cistrncmp("RET=",s,4)==0) {
-		  s += 4;
-		  if (cistrncmp("YES",s,3)==0) {
-		    rp->dsnflags |= _DSN_RET_YES;
-		    s += 3;
-		  } else if (cistrncmp("NO",s,2)==0) {
-		    rp->dsnflags |= _DSN_RET_NO;
-		    s += 2;
-		  } else 
-		    /* Not YES/NO ??? */
-		    ;
-		  while (*s && *s != ' ' && *s != '\t') ++s;
-		  continue;
-		}
-		if (cistrncmp("NOTIFY=",s,7)==0) {
-		  s += 7;
-		  if (cistrncmp("SUCCESS",s,7)==0) {
-		    rp->dsnflags |= _DSN_NOTIFY_SUCCESS;
-		    s += 7;
-		  } else if (cistrncmp("FAILURE",s,7)==0) {
-		    rp->dsnflags |= _DSN_NOTIFY_FAILURE;
-		    s += 7;
-		  } else if (cistrncmp("ALWAYS",s,6)==0) {
-		    rp->dsnflags |= _DSN_NOTIFY_ALWAYS;
-		    s += 6;
-		  } else if (cistrncmp("NEVER",s,5)==0) {
-		    rp->dsnflags |= _DSN_NOTIFY_NEVER;
-		    s += 5;
-		  } else
-		    /* None of the above ?? */
-		    ;
-		  while (*s && *s != ' ' && *s != '\t') ++s;
-		  continue;
-		}
-		if (cistrncmp("ORCPT=",s,6)==0) {
-		  s += 6;
-		  rp->orcpt = s;
-		  while (*s && *s != ' ' && *s != '\t') ++s;
-		  if (*s) *s++ = 0;
-		  continue;
-		}
-	      }
-#endif /* ---------------------------------------------------------------- */
+	      /* IETF-NOTARY-DRPT DATA! */
+	      if (prevrcpt >= 0)
+		offarr[prevrcpt].drptoffset = *lp + 2;
 	      break;
 	    case _CF_MSGHEADERS:
 	      for (/* we count up.. */; svn < opcnt; ++svn)
 		offarr[svn].headeroffset = *lp + 2;
 	      break;
+	    case _CF_DSNRETMODE:
+	      if (cfp->dsnretmode) free(cfp->dsnretmode);
+	      cfp->dsnretmode = strsave(cp+2);
+	      break;
 	    case _CF_DSNENVID:
 	      if (cfp->envid) free(cfp->envid); /* shouldn't happen.. */
 	      cfp->envid = strsave(cp+2);
@@ -1544,12 +1509,13 @@
 	pvpp = &head;
 	for (i = 0; i < opcnt; ++i) {
 	  channel = bcp + offarr[i].offset /* - 2 */;
+	  while (*channel == ' ') ++channel; /* Skip possible space(s) */
 	  if ((echannel = strchr(channel, ' ')) == NULL) /* error! */
 	    continue;
 	  *echannel = '\0';
 	  strlower(channel);
 	  host = echannel + 1;
-	  while (*host == ' ') ++host;
+	  while (*host == ' ') ++host; /* Skip space */
 #if 1
 	  /* [mea]   channel ((mx.target)(mx.target mx.target)) rest.. */
 	  cp = host;
diff -u -r zmailer-2.99.38/scheduler/scheduler.h zmailer-2.99.39/scheduler/scheduler.h
--- zmailer-2.99.38/scheduler/scheduler.h	Tue Aug 13 10:47:45 1996
+++ zmailer-2.99.39/scheduler/scheduler.h	Fri Oct 25 20:35:56 1996
@@ -78,6 +78,7 @@
 	char	*logident;	/* identification for log entries	     */
 	char	*deliveryform;	/* [mea] Name of delivery error form	     */
 	char	*envid;		/* DSN envid				     */
+	char	*dsnretmode;	/* DSN ret-mode: FULL/HDRS		     */
 	u_long	id;		/* identification # (inode# of control file) */
 	char	*mid;		/* msg identification (name of message file) */
 	int	dirind;		/* -1, if no hashed dir, >= 0, if subdired   */
Only in zmailer-2.99.39/scheduler: scheduler.o
Only in zmailer-2.99.39/scheduler: threads.o
Only in zmailer-2.99.39/scheduler: transport.o
diff -u -r zmailer-2.99.38/scheduler/update.c zmailer-2.99.39/scheduler/update.c
--- zmailer-2.99.38/scheduler/update.c	Mon Aug 19 17:30:34 1996
+++ zmailer-2.99.39/scheduler/update.c	Mon Sep 30 11:48:56 1996
@@ -635,7 +635,7 @@
 	  /* addres / action / status / diagnostic / wtt */
 	  sprintf(buf,"%s\001%s\001%s\001%s",
 		  "\003", /* XX: recipient address! XX: MAGIC INFO! */
-		  "failure",
+		  "failed",
 		  "4.0.0 (unspecified timeout failure)",
 		  "smtp; 400 (Expired after ");
 	  saytime((u_long)(vp->ce_expiry - vp->cfp->ctime), buf, 0);
Only in zmailer-2.99.39/scheduler: update.o
Only in zmailer-2.99.39/scheduler: version.c
Only in zmailer-2.99.39/scheduler: version.o
Only in zmailer-2.99.39/smtpserver: debugreport.o
Only in zmailer-2.99.39/smtpserver: fdstatfs.o
Only in zmailer-2.99.39/smtpserver: loadaver.o
Only in zmailer-2.99.39/smtpserver: revision
Only in zmailer-2.99.39/smtpserver: rfc821scn.o
Only in zmailer-2.99.39/smtpserver: smtpserver
diff -u -r zmailer-2.99.38/smtpserver/smtpserver.c zmailer-2.99.39/smtpserver/smtpserver.c
--- zmailer-2.99.38/smtpserver/smtpserver.c	Mon Aug 19 17:43:39 1996
+++ zmailer-2.99.39/smtpserver/smtpserver.c	Fri Oct 25 21:46:53 1996
@@ -500,11 +500,11 @@
 	    openlog("smtpserver", 0);
 #endif /* LOG_MAIL */
 
-	    if (ident_flag != 0) {
-	      setrfc1413ident(0);
-	    } else {
+	    if (ident_flag != 0)
+	      setrfc1413ident(0,&raddr);
+	    else
 	      strcpy(ident_username, "IDENT-NOT-QUERIED");
-	    }
+
 	    sprintf(ident_username+strlen(ident_username),
 		    "@%s (port %d)",rhostname, rport);
 #ifdef	LOG_INFO
@@ -674,11 +674,11 @@
 		openlog("smtpserver", 0);
 #endif /* !LOG_MAIL */
 
-		if (ident_flag != 0) {
-		  setrfc1413ident(0);
-		} else {
+		if (ident_flag != 0)
+		  setrfc1413ident(msgfd,&raddr);
+		else
 		  strcpy(ident_username, "IDENT-NOT-QUERIED");
-		}
+
 		sprintf(ident_username+strlen(ident_username),
 			"@%s (port %d)", rhostname, rport);
 #ifdef	LOG_INFO
@@ -898,6 +898,87 @@
 }
 
 
+
+
+
+char *xtext_string(str)
+char *str;
+{
+	/* Verify that the input is valid RFC 1981 XTEXT string! */
+	char *str0 = str;
+
+	while (*str) {
+	  unsigned char c = *str;
+
+	  if (c == ' ' || c == '\t')
+	    break;
+
+	  if ('!' <= c && c <= '~' && c != '+' && c != '=')
+	    ; /* is ok! */
+	  else if (c == '+') {
+	    c = *++str;
+	    if (!(('0' <= c && c <= '9') || ('A' <= c && c <= 'F'))) {
+	      goto err;
+	    }
+	    c = *++str;
+	    if (!(('0' <= c && c <= '9') || ('A' <= c && c <= 'F'))) {
+	      goto err;
+	    }
+	  } else {
+	    goto err;
+	  }
+	  ++str;
+	}
+	if (str == str0) {
+	err:
+	  rfc821_error_ptr = str;
+	  return NULL;
+	}
+	return str;
+}
+
+char *rfc822atom(str)
+char *str;
+{
+	char *str0 = str;
+	while (*str != 0) {
+	  u_char c = *str;
+	  /* XX: SHOULD do this with a charmap test! */
+	  if (c <= ' ' || c > 126 ||
+	      c == '(' || c == ')' ||
+	      c == '<' || c == '>' ||
+	      c == ',' || c == ';' ||
+	      c == ':' || c == '\\' ||
+	      c == '"' || c == '[' || c == ']') {
+	    if (str > str0)
+	      return str;
+	    goto err;
+	  }
+	  ++str;
+	}
+	if (str == str0) {
+	err:
+	  rfc821_error_ptr = str;
+	  return NULL;
+	}
+	return str;
+}
+
+char *orcpt_string(str)
+char *str;
+{
+	/* Verify that the input is valid RFC 1981 XTEXT string! */
+	str = rfc822atom(str);
+
+	if (str == NULL) return NULL;
+	if (*str != ';') {
+	  rfc821_error_ptr = str-1;
+	  return NULL;
+	}
+	return xtext_string(++str);
+}
+
+
 /* SMTP-server verb subroutines */
 
 void
@@ -992,10 +1073,10 @@
 	  type(-250,NULL, "8BITMIME");
 	  type(-250,NULL, "PIPELINING");
 	  type(-250,NULL, "CHUNKING"); /* RFC 1830 */
-	  type(-250,NULL, "ENHANGEDSTATUSCODES");
+	  type(-250,NULL, "ENHANCEDSTATUSCODES");
 	  type(-250,NULL, "EXPN");
 	  type(-250,NULL, "VRFY");
-	  type(-250,NULL, "XDSN"); /* XX: Change to "DSN" when all parts of it function! */
+	  type(-250,NULL, "X-DSN"); /* XX: Change to "DSN" when all parts of it function! */
 	  type(-250,NULL, "X-RCPTLIMIT 10000"); /* VERY HIGH figure, normal is 100 */
 	  type(-250,NULL, "X-TURNME");
 	  type(-250,NULL, "ETRN");
@@ -1013,6 +1094,7 @@
 	char *s;
 	int rc;
 	char *drpt_envid;
+	char *drpt_ret;
 	char *bodytype = NULL;
 
 	/* For ESMTP SIZE-option use we need to know
@@ -1087,13 +1169,31 @@
 	++cp;		/* Skip the initial '<' */
 	*(s-1) = 0;	/* Scrub the final  '>' */
 
-	/* BODY=8BITMIME SIZE=nnnn ENVID=xxxxxx */
+	/* BODY=8BITMIME SIZE=nnnn ENVID=xxxxxx RET=xxxx */
 	sizeoptval = -1;
 	sizeoptsum = -1;
 	drpt_envid = NULL;
+	drpt_ret   = NULL;
 	rc = 0;
 	while (*s) {
 	  while (*s && (*s == ' '||*s == '\t')) ++s;
+	  if (CISTREQN("RET=",s,4)) {
+	    if (drpt_ret) {
+	      type(501,m554,"RET-param double defined!");
+	      return;
+	    }
+	    s += 4;
+	    drpt_ret = s;
+	    if (CISTREQN("FULL",s,4) ||
+		CISTREQN("HDRS",s,4))
+	      s += 4;
+	    if (*s && *s != ' ' && *s != '\t') {
+	      type(501,m454,"RET-param data error");
+	      return;
+	    }
+	    if (*s) *s++ = '\0';
+	    continue;
+	  }
 	  if (CISTREQN("BODY=",s,5)) {
 	    /* Actually we do not use this data... */
 	    s += 5;
@@ -1113,7 +1213,7 @@
 	      s += 4;
 	    }
 	    if (*s && *s != ' ' && *s != '\t') {
-	      type(455, m454, "BODY-param data error, must be one of: 8BITMIME/BINARYMIME/7BIT");
+	      type(455, m554, "BODY-param data error, must be one of: 8BITMIME/BINARYMIME/7BIT");
 	      rc = 1;
 	      break;
 	    }
@@ -1134,7 +1234,7 @@
 	      ++s;
 	    }
 	    if (*s && *s != ' ' && *s != '\t') {
-	      type(501,m454,"SIZE-param data error");
+	      type(501,m554,"SIZE-param data error");
 	      rc = 1;
 	      break;
 	    }
@@ -1148,23 +1248,23 @@
 	      break;
 	    }
 	    drpt_envid = s+6;
-	    while (*s && *s != ' ' && *s != '\t') {
-	      if (*s < 33 || *s > 126) {
-		type(501,m554,"ENVID data contains illegal characters!");
-		rc = 1;
-		break;
-	      }
-	      ++s;
+	    s = xtext_string(s+6);
+	    if (s == NULL) {
+	      type821err(-501,m554,buf,"Invalid ENVID value '%s'", drpt_envid);
+	      type(501,m554,"ENVID data contains illegal characters!");
+	      rc = 1;
+	      break;
 	    }
 	    *s++ = 0;
-	    if (strlen(drpt_envid) < 6) {
-	      type(501,m454,"ENVID= missing data!");
+	    if (*drpt_envid == 0) {
+	      type(501,m554,"ENVID= without data!");
 	      rc = 1;
 	      break;
 	    }
 	    continue;
 	  }
 	  type(555,m454,"Unknown MAIL FROM:<> parameter: %s",s);
+	  rc = 1;
 	  break;
 	}
 	if (rc != 0) return; /* Error(s) in previous loop.. */
@@ -1210,6 +1310,8 @@
 	  fprintf(mfp, "from <%s>\n", cp);
 	if (drpt_envid != NULL)
 	  fprintf(mfp, "envid %s\n", drpt_envid);
+	if (drpt_ret != NULL)
+	  fprintf(mfp, "notaryret %s\n", drpt_ret);
 
 	sender_ok = 0; /* Set it, when we are sure.. */
 
@@ -1233,12 +1335,13 @@
 	rcpt_count = 0;
 }
 
+
 void
 smtp_rcpt(buf,cp)
 char *buf, *cp;
 {
 	char *s;
-	char *drpt_notify, *drpt_ret, *drpt_orcpt;
+	char *drpt_notify, *drpt_orcpt;
 
 	if (state != Recipient && state != RecipientOrData) {
 	  switch (state) {
@@ -1299,7 +1402,6 @@
 	}
 
 	drpt_notify = NULL;
-	drpt_ret    = NULL;
 	drpt_orcpt  = NULL;
 
 	while (*s) {
@@ -1312,34 +1414,21 @@
 	    }
 	    drpt_notify = s;
 	    s += 7;
-	    if (CISTREQN("SUCCESS",s,7))
-	      s += 7;
-	    else if (CISTREQN("FAILURE",s,7))
-	      s += 7;
-	    else if (CISTREQN("ALWAYS",s,6))
-	      s += 6;
-	    else if (CISTREQN("NEVER",s,5))
-	      s += 5;
-	    if (*s && *s != ' ' && *s != '\t') {
-	      type(455,m454,"NOTIFY-param data error");
-	      return;
-	    }
-	    if (*s) *s++ = '\0';
-	    continue;
-	  }
-	  if (CISTREQN("RET=",s,4)) {
-	    if (drpt_ret) {
-	      type(501,m554,"RET-param double defined!");
-	      return;
+	    while (*s) {
+	      if (CISTREQN("SUCCESS",s,7))
+		s += 7;
+	      else if (CISTREQN("FAILURE",s,7))
+		s += 7;
+	      else if (CISTREQN("DELAY",s,5))
+		s += 5;
+	      else if (CISTREQN("NEVER",s,5))
+		s += 5;
+	      if (*s != ',')
+		break;
+	      ++s;
 	    }
-	    drpt_ret = s;
-	    s += 4;
-	    if (CISTREQN("YES",s,3))
-	      s += 3;
-	    else if (CISTREQN("NO",s,2))
-	      s += 2;
 	    if (*s && *s != ' ' && *s != '\t') {
-	      type(501,m454,"RET-param data error");
+	      type(455,m454,"NOTIFY-param data error");
 	      return;
 	    }
 	    if (*s) *s++ = '\0';
@@ -1351,13 +1440,14 @@
 	      return;
 	    }
 	    drpt_orcpt = s;
-	    while (*s && *s != ' ' && *s != '\t')
-	      ++s;
-	    if (*s) *s++ = '\0';
-	    if (strlen(drpt_orcpt) < 7) {
+	    s = orcpt_string(s+6);
+	    if (s == NULL) {
+	      type821err(-501,m454,buf,"Invalid ORCPT value '%s'", drpt_orcpt);
 	      type(501,m454,"ORCPT-param data error!");
 	      return;
 	    }
+	    if (s && *s != 0) *s = '\0';
+	    ++s;
 	    continue;
 	  }
 	  type(555,"Unknown RCPT TO:<> parameter: %s",s);
@@ -1379,13 +1469,24 @@
 	}
 
 	/* IETF-NOTARY DSN data: */
-	if (drpt_orcpt || drpt_notify || drpt_ret) {
-	  fputs("todsn",mfp);
-	  if (drpt_notify) fprintf(mfp, " %s", drpt_notify);
-	  if (drpt_ret)    fprintf(mfp, " %s", drpt_ret);
-	  if (drpt_orcpt)  fprintf(mfp, " %s", drpt_orcpt);
-	  fputs("\n",mfp);
+	fputs("todsn",mfp);
+	if (drpt_notify) fprintf(mfp, " %s", drpt_notify);
+	if (drpt_orcpt) {
+	  fprintf(mfp, " %s", drpt_orcpt);
+	} else {
+	  char *s = cp;
+	  fputs(" ORCPT=rfc822;",mfp);
+	  while (*s) {
+	    u_char c = *s;
+	    if ('!' <= c && c <= '~' && c != '+' && c != '=')
+	      putc(c,mfp);
+	    else
+	      fprintf(mfp,"+%02X",c);
+	    ++s;
+	  }
 	}
+	putc('\n',mfp);
+
 	/* Normal "RCPT TO:<>" data: */
 	fprintf(mfp, "to <%s>\n", cp);
 	if (sizeoptval < 0)
@@ -1426,7 +1527,7 @@
 	fprintf(mfp,"%c%c%s\n",_CF_TURNME,_CFTAG_NORMAL,cp);
 	/* printf("050-My uid=%d/%d\r\n",getuid(),geteuid()); */
 	runasrootuser();
-	if (mail_close_scheduler(mfp)) {
+	if (mail_close_alternate(mfp,TRANSPORTDIR,"")) {
 	  type(452,m400,"Failed to initiate TURNME request;  Permission denied?");
 	} else {
 	  type(-250,m200,"A TURNME request is initiated - lets hope the system");
@@ -2679,8 +2780,8 @@
 	printf("%03d-%s ", code < 0 ? -code : code,status);
 	if (logfp != NULL)
 	  fprintf(logfp, "%dw\t%03d-%s ", pid, code,status);
-	if (strlen(inbuf)>3)
-	  while (*s && s < rfc821_error_ptr) {
+	if (((int)(rfc821_error_ptr - s)) < 200)
+	  while (s < rfc821_error_ptr) {
 	    ++s;
 	    putc(' ',stdout);
 	    if (logfp != NULL)
@@ -3025,26 +3126,29 @@
 }
 
 static void
-setrfc1413ident(sd)
-unsigned int sd;
+setrfc1413ident(sd,raddr)
+int sd;
+struct sockaddr_in *raddr;
 {
     char *cp;
     struct in_addr	ident_inlocal;
     struct in_addr	ident_inremote;
     unsigned short	ident_local;
     unsigned short	ident_remote;
+    int rc;
 
-    strncpy(ident_username, "UNKNOWN", MAXHOSTNAMELEN);
-    if (ident_fd2(sd, &ident_inlocal, &ident_inremote,
-		 &ident_local, &ident_remote) == -1) {
-	    return;
+    if ((rc = ident_fd2(sd, &ident_inlocal, &ident_inremote,
+			&ident_local, &ident_remote)) != 0) {
+      sprintf(ident_username, "IDENT-FD2-FAULT-%d-%d", rc, errno);
+      return;
     } else {
-	    cp = ident_tcpuser3(&ident_inlocal, &ident_inremote,
-			       ident_local,   ident_remote,
-			       IDENT_TIMEOUT);
-	    if ( cp != (char *) NULL ) {
-		    strncpy(ident_username, cp, MAXHOSTNAMELEN);
-	    }
+      cp = ident_tcpuser3(&ident_inlocal, &ident_inremote,
+			  ident_local,   ident_remote,
+			  IDENT_TIMEOUT);
+      if (cp != NULL)
+	strncpy(ident_username, cp, MAXHOSTNAMELEN);
+      else
+	strncpy(ident_username, "IDENT-CALL-FAULT", MAXHOSTNAMELEN);
     }
 }
 
Only in zmailer-2.99.39/smtpserver: smtpserver.o
Only in zmailer-2.99.39/smtpserver: version.c
Only in zmailer-2.99.39/smtpserver: version.o
Only in zmailer-2.99.39/smtpserver: wantconn.o
Only in zmailer-2.99.39/ssl: ssl
Only in zmailer-2.99.39/support/vacation: convtime.o
Only in zmailer-2.99.39/support/vacation: vacation
diff -u -r zmailer-2.99.38/support/vacation/vacation.SH zmailer-2.99.39/support/vacation/vacation.SH
--- zmailer-2.99.38/support/vacation/vacation.SH	Tue Sep  4 08:23:47 1990
+++ zmailer-2.99.39/support/vacation/vacation.SH	Thu Sep 12 22:09:31 1996
@@ -45,6 +45,9 @@
 	rm $HOME/.forward
 	;;
 *)
-	exec $realprog $@
+	#exec $realprog $@
+	echo "$0: Wrong usage!"
+	echo "  $0 $@"
+	echo "Parameter is either: start  or  stop!"
 	;;
 esac
Only in zmailer-2.99.39/support/vacation: vacation.o
diff -u -r zmailer-2.99.38/support/vacation/vacation.sh zmailer-2.99.39/support/vacation/vacation.sh
--- zmailer-2.99.38/support/vacation/vacation.sh	Sun Aug 18 20:14:45 1996
+++ zmailer-2.99.39/support/vacation/vacation.sh	Sat Oct 26 00:28:30 1996
@@ -45,6 +45,9 @@
 	rm $HOME/.forward
 	;;
 *)
-	exec $realprog $@
+	#exec $realprog $@
+	echo "$0: Wrong usage!"
+	echo "  $0 $@"
+	echo "Parameter is either: start  or  stop!"
 	;;
 esac
Only in zmailer-2.99.39/transports/errormail: errormail
diff -u -r zmailer-2.99.38/transports/errormail/errormail.c zmailer-2.99.39/transports/errormail/errormail.c
--- zmailer-2.99.38/transports/errormail/errormail.c	Mon Aug 19 17:48:21 1996
+++ zmailer-2.99.39/transports/errormail/errormail.c	Fri Oct 25 22:55:50 1996
@@ -281,7 +281,7 @@
 	fputc('\n', mfp);
 	for (rp = dp->recipients; rp != NULL; rp = rp->next) {
 	  /* If not prohibited, print it! */
-	  if ((rp->dsnflags & _DSN_NOTIFY_NEVER) == 0) {
+	  if (rp->notify == NULL || !CISTREQN(rp->notify,"NEVER",5)) {
 	    fprintf(mfp, "error: %s: %s\n",
 		    rp->addr->host, rp->addr->user);
 	    ++reportcnt;
@@ -319,7 +319,7 @@
 	  static char const *type_rfc   = "RFC822";
 	  static char const *type_local = "X-LOCAL";
 
-	  if ((rp->dsnflags & _DSN_NOTIFY_NEVER) != 0)
+	  if (rp->notify != NULL && CISTREQN(rp->notify,"NEVER",5))
 	    continue;
 	  rcpt = rp->addr->user;
 	  if (strchr(rcpt,'@') != NULL) {
@@ -328,11 +328,11 @@
 	      typetag = type_local;
 	  } else
 	    typetag = type_local;
+	  if (rp->orcpt != NULL)
+	    fprintf(mfp, "Original-Recipient: %s\n",rp->orcpt);
 	  fprintf(mfp, "Final-Recipient: %s; %s\n", typetag, rcpt);
 	  fprintf(mfp, "Action: failed\n");
 	  fprintf(mfp, "Diagnostic-Code: X-LOCAL; 500 (%s)\n", rp->addr->host );
-	  if (rp->orcpt != NULL)
-	    fprintf(mfp, "Original-Rcpt: %s\n",rp->orcpt);
 	  fprintf(mfp, "\n");
 	}
 
@@ -348,8 +348,8 @@
 	/* write the (new) headers with local "Received:"-line.. */
 	writeheaders(rp,mfp,"\n",0,0);
 
-	/* If the DSN RET=NO is in effect, don't copy the msg body! */
-	if ((rp->dsnflags & _DSN_RET_NO) == 0) {
+	/* If the DSN RET=HDRS is in effect, don't copy the msg body! */
+	if (!dp->dsnretmode || CISTREQN(dp->dsnretmode,"FULL",4)) {
 
 	  /* Copy out the rest with somewhat more efficient method */
 	  lastchar = 0;
Only in zmailer-2.99.39/transports/errormail: errormail.o
Only in zmailer-2.99.39/transports/errormail: revision
Only in zmailer-2.99.39/transports/errormail: version.c
Only in zmailer-2.99.39/transports/errormail: version.o
Only in zmailer-2.99.39/transports/hold: hold
diff -u -r zmailer-2.99.38/transports/hold/hold.c zmailer-2.99.39/transports/hold/hold.c
--- zmailer-2.99.38/transports/hold/hold.c	Mon Aug 19 17:48:46 1996
+++ zmailer-2.99.39/transports/hold/hold.c	Fri Oct 25 22:39:30 1996
@@ -256,17 +256,17 @@
 	    case EX_SOFTWARE:
 	      action = "failed";
 	      status = "5.0.0 (ZMailer internal protocol error)";
-	      diagnostics = "500 (Protocol failure inside ZMAILER! AARGH!)";
+	      diagnostics = "x-local; 500 (Protocol failure inside ZMAILER! AARGH!)";
 	      break;
 	    case EX_TEMPFAIL:
 	      action = "delayed";
 	      status = "4.4.3 (Temporary routing lookup failure)";
-	      diagnostics = "466 (Temporary routing lookup failure)";
+	      diagnostics = "x-local; 466 (Temporary routing lookup failure)";
 	      break;
 	    default:
 	      action = "failed";
 	      status = "4.4.0 (Unknown ZMailer HOLD status ** CAN'T HAPPEN)";
-	      diagnostics = "500 (Unknown HOLD return code **CAN'T HAPPEN**)";
+	      diagnostics = "x-local; 500 (Unknown HOLD return code **CAN'T HAPPEN**)";
 	      break;
 	    }
 	    notaryreport(rp->addr->user,action,status,diagnostics);
@@ -287,7 +287,7 @@
 	    if (rp->status == EX_OK) {
 	      notaryreport(rp->addr->user,"delayed",
 			   "4.3.1 (System spool full?)",
-			   "400 (Cannot resubmit anything, out of spool space?)");
+			   "x-local; 400 (Cannot resubmit anything, out of spool space?)");
 	      diagnostic(rp, EX_TEMPFAIL, 0,
 			 "cannot resubmit anything!");
 	    }
@@ -303,29 +303,20 @@
 	  fprintf(mfp, "from <%s>\n", dp->senders->user);
 	if (dp->envid != NULL)
 	  fprintf(mfp, "envid %s\n", dp->envid);
-	
+	if (dp->dsnretmode)
+	  fprintf(mfp, "notaryret %s\n", dp->dsnretmode);
+
 	for (rp = dp->recipients; rp != NULL; rp = rp->next)
 	  if (rp->status == EX_OK) {
 	    fprintf(mfp, "to <%s>\n", rp->addr->user);
-	    if (rp->dsnflags != 0 || rp->orcpt != NULL) {
+	    if (rp->notify || rp->orcpt) {
 
 	      fputs("todsn",mfp);
 	      if (rp->orcpt != NULL)
 		fprintf(mfp," ORCPT=%s",rp->orcpt);
 
-	      if (rp->dsnflags & _DSN_RET_YES)
-		fputs(" RET=YES",mfp);
-	      else if (rp->dsnflags & _DSN_RET_NO)
-		fputs(" RET=NO",mfp);
-
-	      if (rp->dsnflags & _DSN_NOTIFY_SUCCESS)
-		fputs(" NOTIFY=SUCCESS",mfp);
-	      else if (rp->dsnflags & _DSN_NOTIFY_FAILURE)
-		fputs(" NOTIFY=FAILURE",mfp);
-	      else if (rp->dsnflags & _DSN_NOTIFY_ALWAYS)
-		fputs(" NOTIFY=ALWAYS",mfp);
-	      else if (rp->dsnflags & _DSN_NOTIFY_NEVER)
-		fputs(" NOTIFY=NEVER",mfp);
+	      if (rp->notify)
+		fprintf(mfp," NOTIFY=%s", rp->notify);
 
 	      putc('\n',mfp);
 	    }
@@ -353,7 +344,7 @@
 	  if (rp->status == EX_OK) {
 	    notaryreport(rp->addr->user,"relayed",
 			 "2.2.0 (Relayed via deferral channel)",
-			 "250 (Relayed via deferral channel)");
+			 "x-local; 250 (Relayed via deferral channel)");
 	    diagnostic(rp, code, 0, cp);
 	  }
 }
Only in zmailer-2.99.39/transports/hold: hold.o
Only in zmailer-2.99.39/transports/hold: revision
Only in zmailer-2.99.39/transports/hold: version.c
Only in zmailer-2.99.39/transports/hold: version.o
Only in zmailer-2.99.39/transports/libta: buildbndry.o
diff -u -r zmailer-2.99.38/transports/libta/ctlopen.c zmailer-2.99.39/transports/libta/ctlopen.c
--- zmailer-2.99.38/transports/libta/ctlopen.c	Thu Aug 15 17:44:38 1996
+++ zmailer-2.99.39/transports/libta/ctlopen.c	Fri Oct 25 21:21:35 1996
@@ -212,7 +212,7 @@
 	char *mfpath;
 	int i, n;
 	struct address *ap;
-	struct rcpt *rp = NULL;
+	struct rcpt *rp = NULL, *prevrp = NULL;
 	struct stat stbuf;
 	char ***msgheaders = NULL;
 	char ***msgheaderscvt = NULL;
@@ -330,9 +330,10 @@
 	d.rcpnts_total = 0;
 	d.rcpnts_remaining = 0;
 	d.rcpnts_failed = 0;
-	d.logident = "none";
-	d.envid   = NULL;
-	d.verbose = NULL;
+	d.logident   = "none";
+	d.envid      = NULL;
+	d.dsnretmode = NULL;
+	d.verbose    = NULL;
 
 	/* run through the file and set up the information we need */
 	for (i = 0; i < n; ++i) {
@@ -355,8 +356,12 @@
 	    ++s;
 	    /* Calculate statistics .. Scheduler asks for it.. */
 	    d.rcpnts_total += 1;
-	    if (*s == _CFTAG_NOTOK)   d.rcpnts_failed    += 1;
-	    else if (*s != _CFTAG_OK) d.rcpnts_remaining += 1;
+	    if (*s == _CFTAG_NOTOK) {
+	      d.rcpnts_failed    += 1;
+	      prevrp = NULL;
+	    } else if (*s != _CFTAG_OK) {
+	      d.rcpnts_remaining += 1;
+	    }
 
 	    if (*s != _CFTAG_NORMAL || d.senders == NULL)
 	      break;
@@ -409,56 +414,34 @@
 	    rp->next = d.recipients;
 	    rp->desc = &d;
 	    rp->orcpt = NULL;
-	    rp->dsnflags = 0;
+	    rp->notify = NULL;
 	    d.recipients = rp;
 	    rp->status = EX_OK;
 	    rp->newmsgheader = NULL;
+	    prevrp = rp;
 	    break;
 	  case _CF_RCPTNOTARY:
 	    /*  IETF-NOTARY-DSN  DATA */
 	    ++s;
-	    while (*s) {
-	      while (*s && (*s == ' ' || *s == '\t')) ++s;
-	      if (cistrncmp("RET=",s,4)==0) {
-		s += 4;
-		if (cistrncmp("YES",s,3)==0) {
-		  rp->dsnflags |= _DSN_RET_YES;
-		  s += 3;
-		} else if (cistrncmp("NO",s,2)==0) {
-		  rp->dsnflags |= _DSN_RET_NO;
-		  s += 2;
-		} else 
-		  /* Not YES/NO ??? */
-		  ;
-		while (*s && *s != ' ' && *s != '\t') ++s;
-		continue;
-	      }
-	      if (cistrncmp("NOTIFY=",s,7)==0) {
-		s += 7;
-		if (cistrncmp("SUCCESS",s,7)==0) {
-		  rp->dsnflags |= _DSN_NOTIFY_SUCCESS;
-		  s += 7;
-		} else if (cistrncmp("FAILURE",s,7)==0) {
-		  rp->dsnflags |= _DSN_NOTIFY_FAILURE;
+	    if (prevrp != NULL) {
+	      while (*s) {
+		while (*s && (*s == ' ' || *s == '\t')) ++s;
+		if (cistrncmp("NOTIFY=",s,7)==0) {
 		  s += 7;
-		} else if (cistrncmp("ALWAYS",s,6)==0) {
-		  rp->dsnflags |= _DSN_NOTIFY_ALWAYS;
+		  prevrp->notify = s;
+		  while (*s && *s != ' ' && *s != '\t') ++s;
+		  if (*s) *s++ = 0;
+		  continue;
+		}
+		if (cistrncmp("ORCPT=",s,6)==0) {
 		  s += 6;
-		} else if (cistrncmp("NEVER",s,5)==0) {
-		  rp->dsnflags |= _DSN_NOTIFY_NEVER;
-		  s += 5;
-		} else
-		  /* None of the above ?? */
-		  ;
-		while (*s && *s != ' ' && *s != '\t') ++s;
-		continue;
-	      }
-	      if (cistrncmp("ORCPT=",s,6)==0) {
-		s += 6;
-		rp->orcpt = s;
+		  prevrp->orcpt = s;
+		  while (*s && *s != ' ' && *s != '\t') ++s;
+		  if (*s) *s++ = 0;
+		  continue;
+		}
+		/* XX: BOO! Unknown value! */
 		while (*s && *s != ' ' && *s != '\t') ++s;
-		if (*s) *s++ = 0;
-		continue;
 	      }
 	    }
 	    break;
@@ -533,6 +516,9 @@
 	    break;
 	  case _CF_DSNENVID:
 	    d.envid = s+2;
+	    break;
+	  case _CF_DSNRETMODE:
+	    d.dsnretmode = s+2;
 	    break;
 	  case _CF_BODYOFFSET:
 	    d.msgbodyoffset = (long)atoi(s+2);
Only in zmailer-2.99.39/transports/libta: ctlopen.o
Only in zmailer-2.99.39/transports/libta: diagnostic.o
Only in zmailer-2.99.39/transports/libta: dnsgetrr.o
Only in zmailer-2.99.39/transports/libta: emptyline.o
Only in zmailer-2.99.39/transports/libta: lockaddr.o
Only in zmailer-2.99.39/transports/libta: markoff.o
Only in zmailer-2.99.39/transports/libta: mime2headers.o
Only in zmailer-2.99.39/transports/libta: mimeheaders.o
Only in zmailer-2.99.39/transports/libta: myuucpname.o
Only in zmailer-2.99.39/transports/libta: nonblocking.o
Only in zmailer-2.99.39/transports/libta: prversion.o
Only in zmailer-2.99.39/transports/libta: routermxes.o
Only in zmailer-2.99.39/transports/libta: stringlib.o
Only in zmailer-2.99.39/transports/libta: wantout.o
Only in zmailer-2.99.39/transports/libta: warning.o
Only in zmailer-2.99.39/transports/libta: writeheaders.o
Only in zmailer-2.99.39/transports/mailbox: lock.o
Only in zmailer-2.99.39/transports/mailbox: mailbox
diff -u -r zmailer-2.99.38/transports/mailbox/mailbox.c zmailer-2.99.39/transports/mailbox/mailbox.c
--- zmailer-2.99.38/transports/mailbox/mailbox.c	Thu Aug 22 11:12:08 1996
+++ zmailer-2.99.39/transports/mailbox/mailbox.c	Fri Oct 25 22:38:08 1996
@@ -640,7 +640,7 @@
 	  if ((pw = getpwuid(uid)) == NULL) {
 	    notaryreport(file,"failed",
 			 "5.2.1 (Target file has no known owner)",
-			 "510 (Target file has no known owner)");
+			 "x-local; 510 (Target file has no known owner)");
 	    DIAGNOSTIC(rp, EX_NOPERM,
 		       "File \"%s\" has no owner", file);
 	    return 1;
@@ -657,7 +657,7 @@
 	case L_MAXTRYS:
 	  notaryreport(file,"delayed",
 		       "4.4.5 (Mailbox unlocking fails)",
-		       "450 (Mailbox unlocking fails)");
+		       "x-local; 450 (Mailbox unlocking fails)");
 	  DIAGNOSTIC(rp, EX_TEMPFAIL, "\"%s\" is locked", file);
 	  return 1;
 	case L_NAMELEN:
@@ -694,7 +694,7 @@
 	  sprintf(mbuf, "\"%s\": %s", file, strerror(errno));
 	  notaryreport(file,"delayed",
 		       "4.4.5 (File locking with dotlock failed)",
-		       "450 (File locking with dotlock failed)");
+		       "x-local; 450 (File locking with dotlock failed)");
 	  DIAGNOSTIC(rp, errno == EBUSY ? EX_TEMPFAIL :
 		     (errno == EACCES ? EX_NOPERM : EX_UNAVAILABLE),
 		     "can't dotlock %s", mbuf);
@@ -714,7 +714,7 @@
 	  alarm(0);
 	  notaryreport(file,"delayed",
 		       "4.4.5 (File locking with NFS lock failed)",
-		       "450 (File locking with NFS lock failed)");
+		       "x-local; 450 (File locking with NFS lock failed)");
 	  DIAGNOSTIC(rp, EX_TEMPFAIL,
 		     "nfs lock() can't nfslock \"%s\"", file);
 	  return 1;
@@ -737,7 +737,7 @@
 	  alarm(0);
 	  notaryreport(file,"delayed",
 		       "4.4.5 (File locking with  lockf  failed)",
-		       "450 (File locking with  lockf  failed)");
+		       "x-local; 450 (File locking with  lockf  failed)");
 	  DIAGNOSTIC(rp, EX_TEMPFAIL,
 		     "can't lockf() \"%s\"", file);
 	  return 1;
@@ -758,7 +758,7 @@
 	  alarm(0);
 	  notaryreport(file,"delayed",
 		       "4.4.5 (File locking with  flock  failed)",
-		       "450 (File locking with  flock  failed)");
+		       "x-local; 450 (File locking with  flock  failed)");
 	  DIAGNOSTIC(rp, EX_TEMPFAIL,
 		     "can't flock() \"%s\"", file);
 	  return 1;
@@ -814,7 +814,7 @@
 	  if (uid == nobody) {
 	    notaryreport("?program?", "failed",
 			 "5.2.1 (Mail to program disallowed w/o proper privileges)",
-			 "550 (Mail to program disallowed w/o proper privileges)");
+			 "x-local; 550 (Mail to program disallowed w/o proper privileges)");
 	    DIAGNOSTIC(rp, EX_UNAVAILABLE,
 		       "mail to program disallowed", 0);
 	    return;
@@ -829,13 +829,13 @@
 	    if (propably_x400(rp->addr->user)) {
 	      notaryreport(rp->addr->user,"failed",
 			   "5.1.4 (this feels like a misplaced X.400 address -- no support for them)",
-			   "550 (this feels like a misplaced X.400 address -- no support for them)");
+			   "x-local; 550 (this feels like a misplaced X.400 address -- no support for them)");
 	      DIAGNOSTIC(rp, EX_UNAVAILABLE,
 			 "This appears to be a misplaced X.400 address, no support for them", 0);
 	    } else {
 	      notaryreport(rp->addr->user,"failed",
 			   "5.2.1 (Mail to file disallowed w/o proper privileges)",
-			   "550 (mail to file disallowed w/o proper privileges)");
+			   "x-local; 550 (mail to file disallowed w/o proper privileges)");
 	      DIAGNOSTIC(rp, EX_UNAVAILABLE,
 			 "mail to file disallowed", 0);
 	    }
@@ -882,13 +882,13 @@
 	      if (propably_x400(rp->addr->user)) {
 		notaryreport(rp->addr->user,"failed",
 			     "5.1.4 (this feels like a misplaced X.400 address -- no support for them)",
-			     "550 (this feels like a misplaced X.400 address -- no support for them)");
+			     "x-local; 550 (this feels like a misplaced X.400 address -- no support for them)");
 		DIAGNOSTIC(rp, EX_UNAVAILABLE,
 			   "This appears to be a misplaced X.400 address, no support for them", 0);
 	      } else {
 		notaryreport(rp->addr->user,"failed",
 			     "5.1.1 (User does not exist)",
-			     "550 (User does not exist)");
+			     "x-local; 550 (User does not exist)");
 		if (at) *at = 0;
 		if (plus) *plus = '+';
 		DIAGNOSTIC(rp, EX_NOUSER,
@@ -921,7 +921,7 @@
 	    char *mailbox = getzenv("MAILBOX");
 	    notaryreport(rp->addr->user,"failed",
 			 "4.3.5 (System mailbox configuration is wrong, we are in deep trouble..)",
-			 "466 (System mailbox configuration is wrong!  No such directory!  Aargh!)");
+			 "x-local; 466 (System mailbox configuration is wrong!  No such directory!  Aargh!)");
 	    DIAGNOSTIC(rp, EX_TEMPFAIL,
 		       "System mailbox configuration is wrong!  No such directory (%s)!  Aargh!",maildirs[0]);
 #ifdef  LOG_PID
@@ -971,7 +971,7 @@
 	if (exstat(rp, file, &st, lstat) < 0) {
 	  notaryreport(rp->addr->user,"failed",
 		       "4.2.0 (User's mailbox disappeared, will retry)",
-		       "466 (User's mailbox disappeared, will retry)");
+		       "x-local; 466 (User's mailbox disappeared, will retry)");
 	  DIAGNOSTIC(rp, EX_TEMPFAIL,
 		     "mailbox file \"%s\" disappeared", file);
 	  return;
@@ -984,7 +984,7 @@
 	if (strcmp(file,"/dev/null") == 0) {
 	  notaryreport(rp->addr->user,"delivery",
 		       "2.2.0 (delivery successfull)",
-		       "250 (Delivered successfully)");
+		       "x-local; 250 (Delivered successfully)");
 	  DIAGNOSTIC(rp, EX_OK, (char *)NULL, 0);
 	  return;
 	}
@@ -993,7 +993,7 @@
 	  /* XX: may want to deliver to named pipes */
 	  notaryreport(rp->addr->user,"failed",
 		       "5.2.1 (Attempting to deliver into non-regular file)",
-		       "500 (Attempting to deliver into non-regular file)");
+		       "x-local; 500 (Attempting to deliver into non-regular file)");
 	  DIAGNOSTIC(rp, EX_UNAVAILABLE,
 		     "attempted delivery to special file \"%s\"",
 		     file);
@@ -1003,7 +1003,7 @@
 	if (st.st_nlink > 1) {
 	  notaryreport(rp->addr->user,"failed",
 		       "4.2.1 (Destination file ambiguous)",
-		       "500 (Destination file has more than one name..)");
+		       "x-local; 500 (Destination file has more than one name..)");
 	  DIAGNOSTIC(rp, EX_UNAVAILABLE,
 		     "too many links to file \"%s\"", file);
 	  return;
@@ -1038,7 +1038,7 @@
 	    rp->status = EX_UNAVAILABLE;
 	  notaryreport(file,"failed",
 		       "4.2.1 (File open for append failed)",
-		       "500 (File open for append failed)");
+		       "x-local; 500 (File open for append failed)");
 	  DIAGNOSTIC(rp, rp->status, fmtbuf, file);
 	  setrootuid(rp);
 	  return;
@@ -1061,7 +1061,7 @@
 	    s2.st_nlink != 1) {
 	    notaryreport(file,"delayed",
 			 "4.4.5 (Lost race for mailbox file)",
-			 "450 (Lost race for mailbox file)");
+			 "x-local; 450 (Lost race for mailbox file)");
 	    DIAGNOSTIC(rp, EX_TEMPFAIL,
 		       "lost race for mailbox \"%s\"", file);
 	    close(fdmail);
@@ -1239,7 +1239,7 @@
 	  fclose(fp);		/* this closes fdmail */
 	  notaryreport(rp->addr->user,"delivery",
 		       "2.2.0 (Delivered successfully)",
-		       "250 (Delivered successfully)");
+		       "x-local; 250 (Delivered successfully)");
 	  DIAGNOSTIC(rp, EX_OK, (char *)NULL, 0);
 	}
 #if	defined(HAVE_SOCKET)
@@ -1318,7 +1318,7 @@
 	    || writeheaders(rp,fp,"\n",convert_qp,0) < 0) {
 	  notaryreport(rp->addr->link->user, "failed",
 		       "4.2.2 (Write to user's mailbox failed)",
-		       "500 (Write to user's mailbox failed)");
+		       "x-local; 500 (Write to user's mailbox failed)");
 	  DIAGNOSTIC(rp, EX_IOERR,
 		     "header write to \"%s\" failed", file);
 #ifdef HAVE_FTRUNCATE
@@ -1658,7 +1658,7 @@
 	if (fd == -1) {
 	  notaryreport(rp->addr->user, "failed",
 		       "4.3.1 (can't create user spool mailbox file)",
-		       "466 (can't create user spool mailbox file)");
+		       "x-local; 466 (can't create user spool mailbox file)");
 	  DIAGNOSTIC(rp, EX_CANTCREAT, "can't create \"%s\"", *filep);
 	}
 	/* otherwise the message was printed by createfile() */
@@ -1684,7 +1684,7 @@
 	    *cp = '\0';
 	    if (exstat(rp, file, &st, stat) < 0) {
 	      *cp = '/';
-	      sprintf(msg,"466 (*INVOCATION BUG* Can't create user spool mailbox file: \"%s\", Directory stat() error: %s)",
+	      sprintf(msg,"x-local; 466 (*INVOCATION BUG* Can't create user spool mailbox file: \"%s\", Directory stat() error: %s)",
 		      file,strerror(errno));
 	      *cp = 0;
 	      notaryreport(rp->addr->user, "failed",
@@ -1697,7 +1697,7 @@
 	      if (!setupuidgid(rp, uid, st.st_gid)) {
 		notaryreport(rp->addr->user, "failed",
 			     "4.3.5 (The mailbox configuration is faulty)",
-			     "466 (*INVOCATION BUG* The mailbox directory is group writable, but can't change my gid to it)");
+			     "x-local; 466 (*INVOCATION BUG* The mailbox directory is group writable, but can't change my gid to it)");
 		DIAGNOSTIC(rp, i,
 			   "failed changing group id to create file in \"%s\"",
 			   file);
@@ -1728,7 +1728,7 @@
 	else /* if (saverrno == ENOENT) */
 	  i = EX_CANTCREAT;
 	/* convoluted to maintain 4 arguments to DIAGNOSTIC */
-	sprintf(msg, "466 (error [%s] creating \"%%s\")", strerror(saverrno));
+	sprintf(msg, "x-local; 466 (error [%s] creating \"%%s\")", strerror(saverrno));
 	notaryreport(rp->addr->user, "failed",
 		     "4.3.0 (Other mailsystem error)",
 		     msg);
Only in zmailer-2.99.39/transports/mailbox: mailbox.o
Only in zmailer-2.99.39/transports/mailbox: revision
Only in zmailer-2.99.39/transports/mailbox: version.c
Only in zmailer-2.99.39/transports/mailbox: version.o
Only in zmailer-2.99.39/transports/sm: revision
Only in zmailer-2.99.39/transports/sm: sm
diff -u -r zmailer-2.99.38/transports/sm/sm.c zmailer-2.99.39/transports/sm/sm.c
--- zmailer-2.99.38/transports/sm/sm.c	Mon Aug 19 17:50:03 1996
+++ zmailer-2.99.39/transports/sm/sm.c	Fri Oct 25 22:38:46 1996
@@ -399,7 +399,7 @@
 	  for (rp = startrp; rp != endrp; rp = rp->next) {
 	    notaryreport(rp->addr->user,"failed",
 			 "4.3.0 (Out of system resources, pipe creation failed)",
-			 "400 (pipe creation error, out of system resources ?)");
+			 "x-local; 400 (pipe creation error, out of system resources ?)");
 	    diagnostic(rp, EX_OSERR, 0,
 		       "cannot create pipe from \"%s\"",
 		       mp->command);
@@ -410,7 +410,7 @@
 	  for (rp = startrp; rp != endrp; rp = rp->next) {
 	    notaryreport(rp->addr->user,"failed",
 			 "4.3.0 (Out of system resources, pipe creation failed)",
-			 "400 (pipe creation error, out of system resources ?)");
+			 "x-local; 400 (pipe creation error, out of system resources ?)");
 	    diagnostic(rp, EX_OSERR, 0,
 		       "cannot create pipe to \"%s\"",
 		       mp->command);
@@ -448,7 +448,7 @@
 	  for (rp = startrp; rp != endrp; rp = rp->next) {
 	    notaryreport(rp->addr->user,"failed",
 			 "4.3.0 (Out of system resources, fork failed)",
-			 "400 (fork failure, out of system resources ?)");
+			 "x-local; 400 (fork failure, out of system resources ?)");
 	    diagnostic(rp, EX_OSERR, 0, "cannot fork");
 	  }
 	  return;
@@ -556,7 +556,7 @@
 	    notaryreport(rp->addr->user,"failed",
 			 /* Could indicate: 4.3.1 - mail system full ?? */
 			 "4.3.0 (Write to target failed for some reason)",
-			 "400 (Write to target failed for some reason)");
+			 "x-local; 400 (Write to target failed for some reason)");
 	    diagnostic(rp, i, 0, "write error");
 	  }
 	  /* just to make sure nothing will get delivered */
@@ -612,11 +612,11 @@
 	  if (i == EX_OK)
 	    notaryreport(rp->addr->user, "relayed",
 			 "2.2.0",
-			 "250 Delivered");
+			 "x-local; 250 Delivered");
 	  else
 	    notaryreport(rp->addr->user, "failed",
 			 "4.3.0",
-			 "430 Unknown error");
+			 "x-local; 430 Unknown error");
 	  diagnostic(rp, i, 0, "%s", buf);
 	}
 	/* XX: still need to deal with MO_STRIPQUOTES */
Only in zmailer-2.99.39/transports/sm: sm.o
Only in zmailer-2.99.39/transports/sm: version.c
Only in zmailer-2.99.39/transports/sm: version.o
Only in zmailer-2.99.39/transports/smtp: mprobe
Only in zmailer-2.99.39/transports/smtp: mprobe.o
Only in zmailer-2.99.39/transports/smtp: revision
Only in zmailer-2.99.39/transports/smtp: smtp
diff -u -r zmailer-2.99.38/transports/smtp/smtp.c zmailer-2.99.39/transports/smtp/smtp.c
--- zmailer-2.99.38/transports/smtp/smtp.c	Fri Aug 23 10:08:52 1996
+++ zmailer-2.99.39/transports/smtp/smtp.c	Fri Oct 25 20:32:49 1996
@@ -210,6 +210,7 @@
 #define ESMTP_8BITMIME   0x0002
 #define ESMTP_DSN        0x0004
 #define ESMTP_PIPELINING 0x0008
+#define ESMTP_ENHSTATUS  0x0010
 
 int  ehlo_capabilities = 0;
 long ehlo_sizeval      = 0;
@@ -839,10 +840,13 @@
 	  s += strlen(s);
 	}
 	/* DSN parameters ... */
-	if ((ehlo_capabilities & ESMTP_DSN) &&
-	    startrp->desc->envid != NULL) {
-	  sprintf(s," ENVID=%s",startrp->desc->envid);
-	  s += strlen(s);
+	if (ehlo_capabilities & ESMTP_DSN) {
+	  if (startrp->desc->envid != NULL) {
+	    sprintf(s," ENVID=%s",startrp->desc->envid);
+	    s += strlen(s);
+	  }
+	  if (startrp->desc->dsnretmode != NULL)
+	    sprintf(s, "RET=%s", startrp->desc->dsnretmode);
 	}
 
 	smtp_flush(); /* Flush in every case */
@@ -902,21 +906,11 @@
 	  s = SMTPbuf + strlen(SMTPbuf);
 
 	  if (ehlo_capabilities & ESMTP_DSN) {
-	    if (rp->dsnflags & _DSN_RET_NO)
-	      strcat(s, " RET=NO");
-	    else if (rp->dsnflags & _DSN_RET_YES)
-	      strcat(s, " RET=YES");
-
-	    if (rp->dsnflags & _DSN_NOTIFY_SUCCESS)
-	      strcat(s, " NOTIFY=SUCCESS");
-	    else if (rp->dsnflags & _DSN_NOTIFY_FAILURE)
-	      strcat(s, " NOTIFY=FAILURE");
-	    else if (rp->dsnflags & _DSN_NOTIFY_ALWAYS)
-	      strcat(s, " NOTIFY=ALWAYS");
-	    else if (rp->dsnflags & _DSN_NOTIFY_NEVER)
-	      strcat(s, " NOTIFY=NEVER");
-
-	    s += strlen(s);
+	    if (rp->notify) {
+	      strcat(s, " NOTIFY=");
+	      strcat(s,rp->notify);
+	      s += strlen(s);
+	    }
 	    if (rp->orcpt != NULL) {
 	      sprintf(s, " ORCPT=%s", rp->orcpt);
 	    }
@@ -1538,9 +1532,11 @@
 	if (r != NULL) *r = 0;
 	if (strcmp(buf,"8BITMIME")==0) {
 	  ehlo_capabilities |= ESMTP_8BITMIME;
-	} else if (strcmp(buf,"XDSN")==0 ||
+	} else if (strcmp(buf,"X-DSN")==0 ||
 		   strcmp(buf,"DSN")==0) {
 	  ehlo_capabilities |= ESMTP_DSN;
+	} else if (strncmp(buf,"ENHANCEDSTATUSCODES",19)==0) {
+	  ehlo_capabilities |= ESMTP_ENHSTATUS;
 	} else if (strncmp(buf,"PIPELINING",10)==0) {
 	  ehlo_capabilities |= ESMTP_PIPELINING;
 	} else if (strncmp(buf,"SIZE ",5)==0 ||
Only in zmailer-2.99.39/transports/smtp: smtp.o
Only in zmailer-2.99.39/transports/smtp: version.c
Only in zmailer-2.99.39/transports/smtp: version.o
diff -u -r zmailer-2.99.38/utils/fullnamealiasmaker.perl zmailer-2.99.39/utils/fullnamealiasmaker.perl
--- zmailer-2.99.38/utils/fullnamealiasmaker.perl	Tue Jul 27 13:14:50 1993
+++ zmailer-2.99.39/utils/fullnamealiasmaker.perl	Thu Sep 12 20:29:09 1996
@@ -1,298 +1,79 @@
-#!/usr/local/bin/perl
-#
-#  THIS PIECE OF CODE IS COPIED AS IS FROM University of Turku INTERNAL
-#  ACCOUNT MANAGEMENT SUBSYSTEM.  You undoubtly need to alter this somewhat..
-#
-
+#!/usr/bin/perl
 #
 #  Combines various   /etc/passwd  files from multiple hosts, and
-#  also  /net/sara/disk1/admin/kayttajat  data into complete
+#  also  /net/kontu/disk0/admin/kayttajat  data into complete
 #  all encompassing database for mailer.
 #
 
 #
-# Resulting database is processed (at mailhost) thru  makendbm
-# ($MAILSHARE/bin/makendbm) to create final database for mailer.
-#
-
-#
 # Order of host names in following data is important.
-# VAX-group is handled separately.
+# Kontu is handled separately.
 #
 # Host LATER in list overrides whatever hosts before have defined.
 #
-@HOSTS = ("hcc","fomalhaut","vega","sirius","polaris");
+@HOSTS = (`uname -n`);
 @FILES = ();
+$PWFILE="PWFILE";
 
 %uid2emailu = ();
 %uid2email = ();
 %email2uid = ();
 %realname2email = ();
-$maildb = "/usr/local/mail/db";
-$saradir = "/net/sara/disk1/admin";
-$makendbm = "/usr/local/mail/bin/makendbm";
 
 umask 0177;
-chdir "/usr/local/etc";
+chdir "/opt/mail/db";
 
-if ($ARGV[0] eq "DEBUG") { goto kontu_works; }
-
-foreach $host (@HOSTS) {
-
-    #
-    #  We collect password files at first.
-    #
-
-    local($FN)="passwd.".$host;
-    unlink("$FN.new");
-    printf "Combining host: $host\n";
-    if ($host ne "polaris") {
-	$rc = system("/usr/ucb/rcp $host:/etc/passwd $FN.new");
-    } else {
-	$rc = system("/usr/bin/ypcat passwd >$FN.new");
-    }
-    if ($rc == 0 ) {
-	rename("$FN.new","$FN");
-    } else {
-	printf "Can't combine host: $host\n";
-    }
-    @FILES = (@FILES,"$FN");
-} # For each..
-
-$rc = system("/usr/local/etc/passwd-tool.exe @FILES > passwd.yp.new");
-#if ($rc == 0) {
-rename("passwd.yp.new","passwd.yp");
-system("chmod 644 passwd.yp");
-#	printf "Combining successfull\n";
-system("/bin/cp passwd.yp $saradir/passwd");
-#} # if bypass..
-# else {
-#	printf("Combining not successfull, rc=0x%x\n",$rc);
-#}
-{
-    local($host)="Kontu - kayttajat-file";
-    local($FN)="passwd.kayttajat";
-    unlink("$FN.new");
-#	printf "Combining host: $host\n";
-    local($rc) = system("cp $saradir/kayttajat $FN.new");
-    if ($rc == 0 ) {
-	rename("$FN.new","$FN");
-    } else {
-	printf "Can't combine host: $host\n";
-    }
-    @FILES = (@FILES,"$FN");
-}
-
-
-for $host (@HOSTS) {
-    #
-    #  Parse each passwd file for userid and Real.Name
-    #
-    local($polaris)=($host eq "polaris");
-    if (open($PWFILE,"< passwd.$host")) {
+if (open($PWFILE,"< passwd")) {
 #printf("Opened  passwd.$host  $polaris\n");
-	local($line,@pwd,@realnames,$realname);
-	while($line = <$PWFILE>) {
-	    next if $line =~ /^#/;
-	    @pwd = split(/:/,$line);
-	    # $pwd[0]  is userid
-	    # $pwd[4]  is real.name
-	    @realnames = & gen_realnames($pwd[4]);
-	    local($uu) = "$pwd[0]\@$host.utu.fi";
-#printf("Real names for user $pwd[0]: ".join('/',@realnames)."\n");
-	    if ($polaris == 0) {
-		$uid2emailu{$pwd[0]} = $uu;
-		$uid2email{$pwd[0]} = $uu;
-		$email2uid{$uu} = $pwd[0];
-		for $realname (@realnames) {
-		    $realname2email{$realname} = $uu;
-		}
-	    } else {
-		$uid2emailu{$pwd[0]} = $uu;
-		$email2uid{$uu} = $pwd[0];
-		for $realname (@realnames) {
-		    $realname2email{$realname} = "$pwd[0]\@utu.fi";
-		}
-	    }
-	}
-	close($PWFILE);
-    }
-}  # For $host ..
-
-kontu_works:;
-#printf "---------------- kontu.kayttajat ----------------\n";
-{
-    local ($fn) = "passwd.kayttajat";
-    local ($INPFILE);
-    open($INPFILE,"< $fn");
-    local ($line);
-    local(@realnames,$realname);
-    while ($line = <$INPFILE>) {
-	chop($line);		# 
-	local($lastname,@namepart)=split(' ',substr($line,0,31));
-	local($vmsuser)=substr($line,31,12);
-	local($unixuser)=substr($line,44,8);
-	local($vmsgroup)=substr($line,53,9);
-	local($unixgroup)=substr($line,62,8);
-	local($rest)=substr($line,79);
-	$lastname  =~ s/,//;
-	$vmsuser   =~ s/ //g;
-	$vmsuser   =~ tr/A-Z/a-z/;
-	$vmsgroup  =~ s/ //g;
-	$unixuser  =~ s/ //g;
-	$unixgroup =~ s/ //g;
-	$rest      =~ s/ //g;
-#	$luser="$lastname:@namepart:$vmsuser:$vmsgroup:$unixuser:$unixgroup:$rest";printf("Kontu luserline /$luser/\n");
-	@realnames = & gen_realnames("@namepart $lastname");
+    local($line,@pwd,@realnames,$realname);
+    while($line = <$PWFILE>) {
+	next if $line =~ /^#/;
+	@pwd = split(/:/,$line);
+	# $pwd[0]  is userid
+	# $pwd[4]  is real.name
+	@realnames = & gen_realnames($pwd[4]);
+	local($uu) = "$pwd[0]";
 #printf("Real names for user $pwd[0]: ".join('/',@realnames)."\n");
-	if (length($unixuser)>0) {
-	    #if (defined($uid2email{$unixuser})) {
-	    #printf "Unix user $unixuser already on Polaris: $uid2email{$unixuser}\n";
-	    #delete $uid2email{$unixuser};
-	    #}
-	    if (!defined($email2uid{"$unixuser\@utu.fi"})) {
-		$email2uid{"$unixuser\@utu.fi"} = $unixuser; }
-	}		       
-	if (length($vmsuser)>0) {	# Kontu uname
-	    local($vv)="$vmsuser\@sara.utu.fi";
-	    if (!defined($uid2emailu{$vmsuser}) && ($vmsuser ne $unixuser)) {
-		$uid2emailu{$vmsuser} = $vv;
-		$uid2email{$vmsuser} = $vv; }
-	    if (!defined($email2uid{$vv})) {
-		$email2uid{$vv} = $vmsuser; }
-	    if (!defined($realname2email{$realname})) {
-		$realname2email{$realname} = $vv; }
-	}
-	for $realname (@realnames) {
-	    if (length($unixuser)>0) {	# UNIX uname
-		if (!defined($realname2email{$realname})) {
-		    $realname2email{$realname} = "$unixuser\@utu.fi";
-		}
-	    }
-	    if (length($vmsuser)>0) { # Kontu uname
-		local($vv)="$vmsuser\@sara.utu.fi";
-		if (!defined($uid2email{$vmsuser}) && ($vmsuser ne $unixuser)){
-		    $uid2email{$vmsuser} = $vv;
-		}
-		if (!defined($email2uid{$vv})) {
-		    $email2uid{$vv} = $vmsuser;
-		}
-		if (!defined($realname2email{$realname})) {
-		    $realname2email{$realname} = $vv;
-		}	       
-	    }
-	}
-    }
-    close($INPFILE);
-
-    # Handle OR_* users.
-    $fn = "passwd.kayttajat";
-    if(!open($INPFILE,"/usr/bin/grep OR_ $fn |")) {
-	die "Cannot grep $fn, stopped";
-    }
-    while ($line = <$INPFILE>) {
-	chop($line);
-	local($lastname,@namepart)=split('_',substr($line,0,31));
-	# An underscore in the name?
-	if($#namepart < 0) {
-	    next;	# Nope!  Skip this one.
-	}
-	local($vmsuser)=substr($line,31,12);
-	local($unixuser)=substr($line,44,8);
-	local($vmsgroup)=substr($line,53,9);
-	local($unixgroup)=substr($line,62,8);
-	local($rest)=substr($line,79);
-	$vmsuser   =~ s/ //g;
-	$vmsuser   =~ tr/A-Z/a-z/;
-	$vmsgroup  =~ s/ //g;
-	$unixuser  =~ s/ //g;
-	$unixgroup =~ s/ //g;
-	$rest      =~ s/ //g;
-#	$luser="$lastname:@namepart:$vmsuser:$vmsgroup:$unixuser:$unixgroup:$rest";printf("Kontu luserline /$luser/\n");
-	@realnames = & gen_realnames("@namepart $lastname");
-#printf("Real names for user $pwd[0]: ".join('/',@realnames)."\n");
-	if (length($unixuser)>0) {
-	    #if (defined($uid2email{$unixuser})) {
-	    #printf "Unix user $unixuser already on Polaris: $uid2email{$unixuser}\n";
-	    #delete $uid2email{$unixuser};
-	    #}
-	    if (!defined($email2uid{"$unixuser\@utu.fi"})) {
-		$email2uid{"$unixuser\@utu.fi"} = $unixuser;
-	    }
-	}
-	if (length($vmsuser)>0) {	# Kontu uname
-	    local($vv)="$vmsuser\@sara.utu.fi";
-	    if (!defined($uid2emailu{$vmsuser}) && ($vmsuser ne $unixuser)) {
-		$uid2emailu{$vmsuser} = $vv;
-		$uid2email{$vmsuser} = $vv;
-	    }
-	    if (!defined($email2uid{$vv})) {
-		$email2uid{$vv} = $vmsuser;
-	    }
-	    if (!defined($realname2email{$realname})) {
-		$realname2email{$realname} = $vv;
-	    }
-	}
+	$uid2emailu{$pwd[0]} = $uu;
+	$uid2email{$pwd[0]} = $uu;
+	$email2uid{$uu} = $pwd[0];
 	for $realname (@realnames) {
-	    if (length($unixuser)>0) {	# UNIX uname
-		if (!defined($realname2email{$realname})) {
-		    $realname2email{$realname} = "$unixuser\@utu.fi";
-		}
-	    }
-	    if (length($vmsuser)>0) {	# Kontu uname
-		local($vv)="$vmsuser\@sara.utu.fi";
-		if (!defined($uid2email{$vmsuser}) && ($vmsuser ne $unixuser)){
-		    $uid2email{$vmsuser} = $vv;
-		}
-		if (!defined($email2uid{$vv})) {
-		    $email2uid{$vv} = $vmsuser;
-		}
-		if (!defined($realname2email{$realname})) {
-		    $realname2email{$realname} = $vv;
-		}
-	    }
+		$realname2email{$realname} = $uu;
 	}
     }
-    close($INPFILE);
-
+    close($PWFILE);
 }
-
-
 {
-#	local(REALNAMES,UID2EMAIL,EMAIL2UID);
-    unlink("passwd.realnames");
-    open(REALNAMES,"> passwd.realnames");
-    unlink("passwd.uid2email");
-    open(UID2EMAIL,"> passwd.uid2email");
-    unlink("passwd.email2uid");
-    open(EMAIL2UID,"> passwd.email2uid");
-    local($key,$value);
-    while(($key,$value) = each %realname2email) {
-	if($key eq '' || $key =~ /^-/ || !($key =~ /\./)) {
-	    ;
-	} else {
-	    printf REALNAMES "$key\t\t$value\n";
-	}
-    }
-    while(($key,$value) = each %email2uid) {
-	printf EMAIL2UID "$key\t\t$value\n";
-    }
-    while(($key,$value) = each %uid2email) {
-	printf UID2EMAIL "$key\t\t$value\n";
-    }
-
-    close(REALNAMES);
-    close(EMAIL2UID);
-    close(UID2EMAIL);
-    if( -f "$maildb/fullnames.exceptions") {
-	system("/usr/bin/cat >>passwd.realnames $maildb/fullnames.exceptions");
-    }
-    system("sort passwd.realnames >$maildb/fullnames.castor");
-    system("sort passwd.uid2email >$maildb/fullname-uids.castor");
-    system($makendbm." $maildb/fullnames $maildb/fullnames.castor");
-    system("/bin/cp  $maildb/fullnames.castor $saradir/fullnamealiases");
+	local($dummy,$REALNAMES,$UID2EMAIL,$EMAIL2UID)=(0,1,2,3);
+	local($key,$value);
+	unlink("passwd.email2uid");
+	open($EMAIL2UID,"> passwd.email2uid");
+	while(($key,$value) = each %email2uid) {
+		printf $EMAIL2UID "$key\t\t$value\n";
+	}
+	unlink("passwd.uid2email");
+	open($UID2EMAIL,"> passwd.uid2email");
+	while(($key,$value) = each %uid2email) {
+		printf $UID2EMAIL "$key\t\t$value\n";
+	}
+	unlink("passwd.realnames");
+	open($REALNAMES,"> passwd.realnames") || die "can't open passwd.realnames";
+	select($REALNAMES);
+	while(($key,$value) = each %realname2email) {
+		printf "$key\t\t$value\n"
+			unless ($key eq '' || $key =~ /^-/ || !($key =~ /\./));
+	}
+
+	close($REALNAMES);
+	close($EMAIL2UID);
+	close($UID2EMAIL);
+	umask 022;
+	system("sort passwd.realnames > fullnames");
+	system("/p/mail/bin/makendbm fullnames fullnames");
+	system("sort passwd.uid2email > fullname-uids");
 }
 exit(0);
+
 
 #
 # Generic parser routines
diff -u -r zmailer-2.99.38/utils/make-incore.sh zmailer-2.99.39/utils/make-incore.sh
--- zmailer-2.99.38/utils/make-incore.sh	Fri Aug 23 20:55:21 1996
+++ zmailer-2.99.39/utils/make-incore.sh	Fri Oct 25 12:21:52 1996
@@ -12,9 +12,8 @@
 
 if [ ! -f "$INFILE" ]; then exit 1; fi
 
-cat $INFILE |			\
 (
 	echo "# generated script from '$INFILE' into '$OUTFILE' at `date`"
 	echo "relation -lt incore -d pathalias -s 0 $DBASE"
 	awk '/^[^#]/{printf "db add '$DBASE' '\''%s'\'' '\''%s'\''\n",$1,$2}' 
-) > $OUTFILE
+) < $INFILE > $OUTFILE
diff -u -r zmailer-2.99.38/utils/makendbm/Makefile zmailer-2.99.39/utils/makendbm/Makefile
--- zmailer-2.99.38/utils/makendbm/Makefile	Tue Sep 17 20:42:43 1996
+++ zmailer-2.99.39/utils/makendbm/Makefile	Sat Oct 26 00:19:34 1996
@@ -25,13 +25,14 @@
 all: $(PROGS)
 
 makendbm: makendbm.o
-	$(CC) $(CFLAGS) -o makendbm makendbm.o
+	$(CC) $(CFLAGS) -o makendbm makendbm.o $(LIBS)
 
 ndbmlook: ndbmlook.o
-	$(CC) $(CFLAGS) -o ndbmlook ndbmlook.o
+	$(CC) $(CFLAGS) -o ndbmlook ndbmlook.o $(LIBS)
 
 clean:
 	-rm -f *.o $(PROGS) *~
+
 distclean: clean
 	-rm -f Makefile
 
diff -u -r zmailer-2.99.38/utils/makendbm/Makefile.in zmailer-2.99.39/utils/makendbm/Makefile.in
--- zmailer-2.99.38/utils/makendbm/Makefile.in	Thu Aug  8 18:14:16 1996
+++ zmailer-2.99.39/utils/makendbm/Makefile.in	Tue Oct 22 18:59:46 1996
@@ -25,13 +25,14 @@
 all: $(PROGS)
 
 makendbm: makendbm.o
-	$(CC) $(CFLAGS) -o makendbm makendbm.o
+	$(CC) $(CFLAGS) -o makendbm makendbm.o $(LIBS)
 
 ndbmlook: ndbmlook.o
-	$(CC) $(CFLAGS) -o ndbmlook ndbmlook.o
+	$(CC) $(CFLAGS) -o ndbmlook ndbmlook.o $(LIBS)
 
 clean:
 	-rm -f *.o $(PROGS) *~
+
 distclean: clean
 	-rm -f Makefile
 
Only in zmailer-2.99.39/utils/makendbm: makendbm
diff -u -r zmailer-2.99.38/utils/makendbm/makendbm.c zmailer-2.99.39/utils/makendbm/makendbm.c
--- zmailer-2.99.38/utils/makendbm/makendbm.c	Fri Aug  9 18:40:03 1996
+++ zmailer-2.99.39/utils/makendbm/makendbm.c	Thu Sep 12 20:49:12 1996
@@ -11,10 +11,10 @@
 #include <ctype.h>
 #include <sys/types.h>
 #include <fcntl.h>
-#ifdef HAVE_NDBM
+#ifdef HAVE_NDBM_H
 #include <ndbm.h>
 #else
-#ifdef HAVE_GDBM
+#ifdef HAVE_GDBM_H
 #include <gdbm.h>
 #else
 	error:error:Only NDBM and GDBM supported! (NDBM primarily)
@@ -39,10 +39,10 @@
 {
   fprintf(stderr,"Usage: %s database.name [infilename|-]\n",prog);
   fprintf(stderr,"  If no infilename is defined, database.name is assumed.\n");
-#ifdef HAVE_NDBM
+#ifdef HAVE_NDBM_H
   fprintf(stderr,"  (NDBM appends  .pag, and .dir  into actual db file names..)\n");
 #else /* GDBM.. */
-  fprintf(stderr,"  (GDBM DOES NOT append .pag, nor .dir  into actual db file names..)\n");
+  fprintf(stderr,"  (GDBM appends .pag, to the actual db file name..)\n");
 #endif
   fprintf(stderr," Error now: %s",err);
   if (errno > 0 && errno < sys_nerr)
@@ -58,7 +58,7 @@
 {
   char *dbasename = NULL;
   FILE *infile = NULL;
-#ifdef HAVE_NDBM
+#ifdef HAVE_NDBM_H
   DBM *dbmfile;
 #else
   GDBM_FILE dbmfile;
@@ -78,10 +78,12 @@
 
   if (infile == NULL) usage(argv[0],"bad infile",errno);
 
-#ifdef HAVE_NDBM
+#ifdef HAVE_NDBM_H
   dbmfile = dbm_open(dbasename, O_RDWR|O_CREAT|O_TRUNC, 0644);
 #else
   /* Play loose .. don't do syncs while writing */
+  dbasename = strcpy(malloc(strlen(dbasename)+8),dbasename);
+  strcat(dbasename,".pag"); /* ALWAYS append this */
   dbmfile = gdbm_open(dbasename, 0, GDBM_NEWDB|GDBM_FAST, 0644);
 #endif
   if (dbmfile == NULL)
@@ -98,7 +100,7 @@
 void
 create_dbase(infile,dbmfile)
 FILE *infile;
-#ifdef HAVE_NDBM
+#ifdef HAVE_NDBM_H
 DBM *dbmfile;
 #else
 GDBM_FILE dbmfile;
@@ -140,7 +142,7 @@
 	  dat.dptr  = s;
 	  dat.dsize = strlen(s)+1;
 
-#ifdef HAVE_NDBM
+#ifdef HAVE_NDBM_H
 	  rc = dbm_store(dbmfile, key, dat, DBM_INSERT);
 #else
 	  rc = gdbm_store(dbmfile, key, dat, GDBM_INSERT);
Only in zmailer-2.99.39/utils/makendbm: makendbm.o
Only in zmailer-2.99.39/utils/makendbm: ndbmlook
diff -u -r zmailer-2.99.38/utils/makendbm/ndbmlook.c zmailer-2.99.39/utils/makendbm/ndbmlook.c
--- zmailer-2.99.38/utils/makendbm/ndbmlook.c	Mon Jul 15 21:53:41 1996
+++ zmailer-2.99.39/utils/makendbm/ndbmlook.c	Thu Sep 12 20:38:44 1996
@@ -11,10 +11,10 @@
 #include <ctype.h>
 #include <sys/types.h>
 #include <fcntl.h>
-#ifdef HAVE_NDBM
+#ifdef HAVE_NDBM_H
 #include <ndbm.h>
 #else
-#ifdef HAVE_GDBM
+#ifdef HAVE_GDBM_H
 #include <gdbm.h>
 #else
 	error:error:Only NDBM and GDBM supported! (NDBM primarily)
@@ -34,7 +34,7 @@
 int errno;
 {
   fprintf(stderr,"Usage: %s database.name key\n",prog);
-#ifdef HAVE_NDBM
+#ifdef HAVE_NDBM_H
   fprintf(stderr,"  (NDBM appends  .pag, and .dir  into actual db file names..)\n");
 #else /* GDBM.. */
   fprintf(stderr,"  (GDBM DOES NOT append .pag, nor .dir  into actual db file names..)\n");
@@ -55,7 +55,7 @@
   FILE *infile = NULL;
   datum key;
   datum result;
-#ifdef HAVE_NDBM
+#ifdef HAVE_NDBM_H
   DBM *dbmfile;
 #else
   GDBM_FILE dbmfile;
@@ -63,7 +63,7 @@
 
   if (argc != 3) usage(argv[0],"wrong number of arguments",0);
   dbasename = argv[1];
-#ifdef HAVE_NDBM
+#ifdef HAVE_NDBM_H
   dbmfile = dbm_open(dbasename, O_RDONLY, 0644);
 #else
   dbmfile = gdbm_open(dbasename, 0, GDBM_READER, 0);
@@ -74,7 +74,7 @@
   key.dptr = argv[2];
   key.dsize = strlen(argv[2]) +1;
 
-#ifdef HAVE_NDBM
+#ifdef HAVE_NDBM_H
   result = dbm_fetch(dbmfile,key);
 #else
   result = gdbm_fetch(dbmfile,key);
@@ -85,7 +85,7 @@
   }
   printf("siz:%d, dat: %s\n",result.dsize,result.dptr);
 
-#ifdef HAVE_NDBM
+#ifdef HAVE_NDBM_H
   dbm_close(dbmfile);
 #else
   gdbm_close(dbmfile);
Only in zmailer-2.99.39/utils/makendbm: ndbmlook.o
Only in zmailer-2.99.39: zmailer.Config
