/*
**  USEFUL.H -- Some useful stuff.
**
**	@(#)useful.h	4.1		7/25/83
*/

#ifndef makedev
# include <sys/types.h>
#endif

#ifdef SYSV
# define index strchr
# define rindex strrchr
# define bcopy(a,b,c) memcpy(b,a,c)
#endif

/* support for bool type */
typedef char	bool;
# define TRUE	1
# define FALSE	0

# ifndef NULL
# define NULL	0
# endif NULL

/* bit hacking */
# define bitset(bit, word)	(((word) & (bit)) != 0)

/* some simple functions */
# ifndef max
# define max(a, b)	((a) > (b) ? (a) : (b))
# define min(a, b)	((a) < (b) ? (a) : (b))
# endif max

/* assertions */
# ifndef NASSERT
# define ASSERT(expr, msg, parm)\
	if (!(expr))\
	{\
		fprintf(stderr, "assertion botch: %s:%d: ", __FILE__, __LINE__);\
		fprintf(stderr, msg, parm);\
	}
# else NASSERT
# define ASSERT(expr, msg, parm)
# endif NASSERT

/* sccs id's */
# ifndef lint
#  ifdef __STDC__
#   define SCCSID(arg)  static char SccsId[] = "" ## arg ; /* ANSI notation */
#  else
#   define SCCSID(arg)	static char SccsId[] = "arg";
# endif
# else lint
#  define SCCSID(arg)
# endif lint

/* define the types of some common functions */
extern char	*strcpy(), *strncpy();
extern char	*strcat(), *strncat();
extern char	*index(), *rindex();
extern int	errno;
extern time_t	time();
extern char	*ctime();
# ifndef V6
extern char	*getenv();
# endif V6
# ifndef VMUNIX
typedef unsigned short	u_short;
typedef long		u_long;
typedef char		u_char;
typedef int		void;
# endif VMUNIX

# define LONG_MAX 0x7FFFFFFFL
