/*
 *	Copyright 1994 Matti Aarnio
 *	This is part of the ZMailer (2.99+), and available with
 *	the rules of the main program itself
 */

#include "hostenv.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>


#ifdef	USE_STATVFS
# include <sys/statvfs.h>
# define FSTATFS fstatvfs /* Existence of this means (usually) SYSV code */
# define STATFSTYPE struct statvfs
#else	/* !USE_STATVFS */
#ifdef	SYSV
# include <sys/statfs.h>
# define FSTATFS fstatfs /* Existence of this means (usually) SYSV code */
# define STATFSTYPE struct statfs
#else /* Hmm.. Assuming it appears on all NON-SysV systems.. */
#ifdef ULTRIX
	/* From: James S MacKinnon <jmack@Phys.UAlberta.Ca> */
# include <sys/types.h>
# include <sys/stat.h>
# include <sys/param.h>
# include <sys/mount.h>
# include <netinet/in.h>
# include <nfs/nfs_clnt.h>
# include <nfs/vfs.h>
# define FSTATFS statfs	/* Existence of this means (usually) SYSV code */
# define STATFSTYPE struct statfs
#else /* !ULTRIX */
#ifdef bsdi
# include <sys/types.h>
# include <sys/mount.h>
# include <sys/param.h>
/* # define FSTATFS fstatfs */ /* nonexistence of this means BSD code */
# define STATFSTYPE struct statfs
#else /* !bsdi */
# include <sys/vfs.h>
/* # define FSTATFS fstatfs */ /* nonexistence of this means BSD code */
# define STATFSTYPE struct statfs
#endif /* !BSD */
#endif /* !ULTRIX */
#endif /* !SYSV */
#endif /* !USE_STATVFS */

long fd_statfs(fd)
int fd;
{
	STATFSTYPE statbuf;	/* SysV and BSD definitions differ..	*/
	long availspace = 0;
	int rc;

	/* Query the available space on the filesystem where the
	   currently open (int fd) file is located.  This call
	   should be available on all systems, and given valid
	   parametrization, never fail... */

#if defined(__linux__)
	if ((rc = fstatfs(fd, &statbuf)) == 0) {
	  availspace = statbuf.f_bavail * statbuf.f_bsize;
	}
#else
#if defined(ULTRIX)
	if ((rc = FSTATFS(fd, &statbuf)) == 0) {
	  availspace = statbuf.f_bavail * statbuf.f_bsize;
	}
#else
#if defined(FSTATFS)
	if ((rc = FSTATFS(fd, &statbuf)) == 0) {
	  availspace = statbuf.f_bavail * statbuf.f_frsize;
	}
#else /* none of the previous  -- SVR3 stuff... */
	if ((rc = fstatfs(fd, &statbuf,sizeof statbuf, 0)) == 0){
	  availspace = statbuf.f_bfree * statbuf.f_bsize;
	}
#endif
#endif
#endif
	return availspace;
}
