/*
 *	Copyright 1990 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */
/*
 *	Matti E Aarnio 1994 -- write (new) multiline headers to the file
 *      This is part of the Zmailer
 *
 *	TODO: auto-wrapping/widening of (continued) headers to given
 *	      width! That is, to enable to limit header width to 80
 *	      chars is such is needed somewhere (like BITNET)..
 */

#include <stdio.h>
#include "hostenv.h"
#include "ta.h"

int
writeheaders(rp,fp,newline,use_cvt,maxwidth)
	struct rcpt *rp;
	FILE *fp;
	char *newline;
	int use_cvt, maxwidth;
{
	char **msgheaders = *(rp->newmsgheader);
	int newlinelen = strlen(newline);
	int hsize = 0;

	/* If asked for, and they are available,
	   use converted headers */
	if (use_cvt)
	  if (*(rp->newmsgheadercvt) != NULL)
	    msgheaders = *(rp->newmsgheadercvt);

	if (!msgheaders) return -1;

	while (*msgheaders && !ferror(fp)) {
		int linelen = strlen(*msgheaders);
		if (fwrite(*msgheaders,1,linelen,fp) != linelen)
			return -1;
		hsize += linelen;
		if (fwrite(newline,1,newlinelen,fp) != newlinelen)
			return -1;
		++msgheaders;
	}
	if (fwrite(newline,1,newlinelen,fp) != newlinelen)
		return -1;
	hsize += newlinelen;
	return hsize;
}
