/*
 *  cfgets() -- A routine for Zmailer  libz.a -library.
 *
 *  Count how many chars are stored into the buffer, EOF if
 *  failed...
 *
 *  By Matti Aarnio <mea@utu.fi> on 26-Sep-94
 */

#include <stdio.h>

int cfgets(s, n, stream)
	char *s;
	int n;
	FILE *stream;
{
	int cnt = 0;
	int c;

	while (n > 0 && (c = getc(stream)) != EOF) {
	  *s++ = c;
	  ++cnt;
	  if (c == '\n')
	    break;
	}
	if (cnt == 0 && c == EOF)
	  return EOF;
	return cnt;
}
