/*
 *  Header file for Alpha trace.
 *  $Id: trace.h,v 1.11 1993/12/21 23:51:35 anthony Exp $
 */

#ifndef __TRACE_H_INCLUDED
#define __TRACE_H_INCLUDED
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <wait.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/fault.h>
#include <sys/procfs.h>
#include <machine/reg.h>
#define  COMPAT_43		/* for some extra system calls */
#include <sys/syscall.h>

char *rd_buf(long, size_t);

struct syscallent {
    int syscallnum; /* number of system call */
    char *returns; /* what it returns */
    int numargs; /* number of arguments it takes */
    int (*printargsfunc)(long, long *, int, char *); /* function to print arguments */
    int (*printretfunc)(long, long, int, long *); /* function to print arguments */
};

/* Dont look at this - its disgusting, disgusting stuff */
#define TP_PROTO(X,Y,Z)    int  Y ## X (long sysCallno,\
	long *sysArgs,int sysNumargs,char *sysFormat); \
	int Z ## X (long sysCallno,long sysReturn,int sysErrno, long *cmdArgs);
#define TRACE_PRINT_PROTO(x) TP_PROTO(x,printargs_,printret_)


TRACE_PRINT_PROTO(gen)
TRACE_PRINT_PROTO(accept)
TRACE_PRINT_PROTO(bind)
TRACE_PRINT_PROTO(connect)
TRACE_PRINT_PROTO(flock)
TRACE_PRINT_PROTO(getitimer)
TRACE_PRINT_PROTO(ioctl)
TRACE_PRINT_PROTO(lseek)
TRACE_PRINT_PROTO(mmap)
TRACE_PRINT_PROTO(open)
TRACE_PRINT_PROTO(read)
TRACE_PRINT_PROTO(recv)
TRACE_PRINT_PROTO(recvfrom)
TRACE_PRINT_PROTO(select)
TRACE_PRINT_PROTO(send)
TRACE_PRINT_PROTO(sendto)
TRACE_PRINT_PROTO(setitimer)
TRACE_PRINT_PROTO(sigaction)
TRACE_PRINT_PROTO(sigreturn)
TRACE_PRINT_PROTO(socket)
TRACE_PRINT_PROTO(table)
TRACE_PRINT_PROTO(write)

#endif
