/* 
 * print_io : print_ routines for open() read() flock() lseek() calls
 * Author: Anthony Baxter <anthony@aaii.oz.au>
 * $Id: print_io.c,v 1.4 1993/12/14 07:24:00 anthony Exp $
 */
#include <string.h>
#include <sys/fcntl.h>
#include "trace.h"
#include "sysname.h"

extern FILE *outfp;
extern int max_string;


int printargs_open(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
    char open_flags_b[100], *open_flags = open_flags_b;
    int oflag=(int)sysArgs[1];

    if(!oflag)
	strcpy(open_flags, "O_RDONLY");

    if(oflag&O_WRONLY) {
	strcpy(open_flags, "O_WRONLY");
    } else if(oflag&O_RDWR) {
	strcpy(open_flags, "O_RDWR");
    } else {
	strcpy(open_flags, "O_RDONLY");
    }

    if(oflag&O_CREAT) strcat(open_flags,"|O_CREAT"); 
    if(oflag&O_EXCL) strcat(open_flags,"|O_EXCL"); 
    if(oflag&O_NOCTTY) strcat(open_flags,"|O_NOCTTY"); 
    if(oflag&O_TRUNC) strcat(open_flags,"|O_TRUNC"); 
    if(oflag&O_SYNC) strcat(open_flags,"|O_SYNC"); 
    if(oflag&O_APPEND) strcat(open_flags,"|O_APPEND"); 
    if(oflag&O_NONBLOCK) strcat(open_flags,"|O_NONBLOCK"); 
    if(oflag&O_NDELAY) strcat(open_flags,"|O_NDELAY"); 
    
    fprintf(outfp,"open (");
    p_arg('s',sysArgs[0],255);
    fprintf(outfp,", %s, 0%o) = ",open_flags,sysArgs[2]);
    return(1);
}

int printret_open(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{
    if(sysReturn!=-1)
        fprintf(outfp,"%d\n",(int)sysReturn);
    else
        fprintf(outfp,"-1 (%s)\n",sys_errlist[sysErrno]);
    return 1;
} 

/* 
 * 
 * print_ routines for read()
 * 
 */

extern FILE *outfp;
extern int max_string;

static long strp = 0;  /* want these two to hang around */


int printargs_read(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
    /* store address of return buffer */
    strp = sysArgs[1];
    fprintf(outfp,"read (%d, 0x%x, %d) = ",sysArgs[0],sysArgs[1],sysArgs[2]);
    return(1);
}

int printret_read(long sysCallno, long sysReturn, int sysErrno, long *sysargs)
{
    if(sysReturn!=-1) {
        fprintf(outfp,"%d",(int)sysReturn);
	if (strp != 0) {
	    fprintf(outfp," [, ");
	    p_arg('b', strp, sysReturn);
	    fprintf(outfp,", ]");
	}
    } else
        fprintf(outfp,"-1 (%s)",sys_errlist[sysErrno]);

    fputc('\n', outfp);
    return(1);
} 

/*
 * Print for write.
 */

int printargs_write(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
	fprintf(outfp,"write (%d, 0x%p [",sysArgs[0],sysArgs[1]);
	p_arg('b', sysArgs[1], sysArgs[2]);
	fprintf(outfp,"], %d) = ",sysArgs[2]);
	return 1;
}

/* 
 * Print for flock.
 */

#include <sys/file.h>

int printargs_flock(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
    char flock_args_b[20], *flock_args=flock_args_b;

    *flock_args = 0;
    if(sysArgs[1]&LOCK_SH) strcat(flock_args,"share"); 
    if(sysArgs[1]&LOCK_EX) strcat(flock_args,"excl"); 
    if(sysArgs[1]&LOCK_NB) strcat(flock_args,"|nonblock"); 
    if(sysArgs[1]&LOCK_UN) strcat(flock_args,"unlock"); 
    fprintf(outfp,"flock ( %d, %s ) = ",sysArgs[0],flock_args);
    return(1);
}

/* 
 * Arguments are:
 *  sysCallno:  the number of the system call.
 *  sysReturn:  what it returned.
 *   sysErrno:  errno, if system call failed, else 0.
 */
int printret_flock(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{
    if(sysReturn!=-1)
	fprintf(outfp,"%d\n",(int)sysReturn);
    else
	fprintf(outfp,"-1 (%s)\n",sys_errlist[sysErrno]);
    return(1);
} 

/* 
 * lseek.
 */
   
int printargs_lseek(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
    char *whence;
    switch(sysArgs[2]) {
	case SEEK_SET: whence="SEEK_SET"; break;
	case SEEK_CUR: whence="SEEK_CUR"; break;
	case SEEK_END: whence="SEEK_END"; break;
	default: whence="????";
    }
    fprintf(outfp,"lseek (%d, %d, %s) = ",sysArgs[0],sysArgs[1],whence);
    return(1);
}

int printret_lseek(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{
    if(sysReturn!=-1)
	fprintf(outfp,"%d\n",(int)sysReturn);
    else
	fprintf(outfp,"-1 (%s)\n",sys_errlist[sysErrno]);
    return(1);
} 
