#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <ctype.h>
#ifdef __UNIX__
#ifdef USG
#include <termio.h>
#else
#include <sgtty.h>
#endif
#endif
#ifdef __MSDOS__
#include <conio.h>     /* for getch() */
#endif
#include "us.h"

/*
 *  Simple program for selecting articles offline from a summary
 *  file generated by uqwk.
 *
 *  Steve Belczyk, 08/93
 *
 *  MS-DOS adaptation by Dick Grady, grady@world.std.com, 08/93
 *  Compile with the Compact or Large memory model.
 */

#ifdef __STDC__
main (int argc, char *argv[])
#else
main (argc, argv)
int argc;
char *argv[];
#endif
{
	char *sub_file;

	/* Init stuff */
	grp_list = NULL;
	short_file = 0;
#ifdef __MSDOS__
	progname = "US";
#else
	progname = argv[0];
#endif

	/* Check options */
	if (argc != 2)
	{
		fprintf (stderr, "usage: %s subfile\n", progname);
		exit (0);
	}
	sub_file = argv[1];

	/* Read subject file */
	ReadSub (sub_file);

	/* Do selection */
	Select ();

	/* Write back out */
	WriteSub (sub_file);
}

#ifdef __STDC__
void ReadSub (char *fn)
#else
ReadSub (fn)
char *fn;
#endif
/*
 *  Read subjects file
 */
{
	FILE *fd;
	struct grp_ent *cur_grp;

	/* Try to open it */
	if (NULL == (fd = fopen (fn, "r")))
	{
		fprintf (stderr, "%s: can't open %s\n", progname, fn);
		exit (0);
	}

	printf ("%s: Threading newsgroups, please wait...\n", progname);
	fflush (stdout);

	/* Show no group yet */
	cur_grp = NULL;

	/* Read through it */
	while (NULL != Fgets (buf, BUF_LEN, fd))
	{
		/* First char determines type of line */
		switch (buf[0])
		{
		case '*':
			/* New newsgroup */
			cur_grp = AddGroup (&buf[4]);
			break;

		case '0': case '1': case '2': case '3': case '4':
		case '5': case '6': case '7': case '8': case '9':

			 /* New article */
			AddArticle (cur_grp);
			break;

		default:
			break;
		}
	}
	fclose (fd);

	/* Count threads in each group */
	CountThreads();
}

#ifdef __STDC__
struct grp_ent *AddGroup (char *name)
#else
struct grp_ent *AddGroup (name)
char *name;
#endif
/*
 *  Add a new group to the list
 */
{
	struct grp_ent *gp;

	/* Get new group */
	gp = AllocGroup (name);

	/* Add to list */
	if (grp_list == NULL)
	{
		/* First one */
		grp_list = gp;
		gp->next = NULL;
		last_gp = gp;
	}
	else
	{
		/* Add to end */
		last_gp->next = gp;
		gp->next = NULL;
		last_gp = gp;
	}
	return (gp);
}

#ifdef __STDC__
struct grp_ent *AllocGroup (char *name)
#else
struct grp_ent *AllocGroup (name)
char *name;
#endif
/*
 *  Allocate space for a new
 */
{
	struct grp_ent *gp;

	/* Get space for entry */
	gp = (struct grp_ent *) malloc (sizeof (struct grp_ent));
	if (gp == NULL) OutOfMemory();

	/* Get space for name */
	gp->name = (char *) malloc (1 + strlen (name));
	if (gp->name == NULL) OutOfMemory();

	/* Set stuff */
	strcpy (gp->name, name);
	gp->threads = 0;
	gp->articles = 0;
	gp->done = 0;
	gp->thr_list = NULL;

	return (gp);
}

#ifdef __STDC__
int AddArticle (struct grp_ent *gp)
#else
AddArticle (gp)
struct grp_ent *gp;
#endif
/*
 *  Add new article to given group (line is in buf)
 */
{
	char artnum[101];
	char *c1;
	char *c2;
	struct thr_ent *tp;
	struct art_ent *ap;

	if (gp == NULL) return (0);

	/* Get the article number */
	c1 = buf;
	c2 = artnum;
	while( *c1 != '\0' && *c1 != ':' )
		*c2++ = *c1++;
	*c2 = '\0';

	/* Skip over ':' */
	c1++;

	/* Move buf back so we just have subject */
	c2 = &buf[0];
	while (*c1)
	{
		*c2 = *c1;
		c1++; c2++;
	}
	*c2 = *c1;		/* Get the null */

	/* Remove any re:, Re:, or RE: */
	UnRe();

	/* Find this thread, or make a new one */
	tp = FindThread (gp);

	/* Get space for new article */
	ap = AllocArticle ();
	ap->num = (char *) malloc (strlen(artnum)+1);
	if (ap->num == NULL) OutOfMemory();
	strcpy(ap->num, artnum);
	ap->next = tp->art_list;
	tp->art_list = ap;
	return (0);
}

#ifdef __STDC__
int UnRe (void)
#else
UnRe ()
#endif
/*
 *  Remove any Re:
 */
{
	char *c1, *c2;

	c1 = c2 = &buf[0];

	/* Figure out how many characters to shift */
	if (!strncmp (buf, "RE:  ", 5) ||
	    !strncmp (buf, "Re:  ", 5) ||
	    !strncmp (buf, "re:  ", 5) )
	{
		c1 = c2 + 5;
	}
	else if (!strncmp (buf, "RE: ", 4) ||
		 !strncmp (buf, "Re: ", 4) ||
		 !strncmp (buf, "re: ", 4) )
	{
		c1 = c2 + 4;
	}
	else if (!strncmp (buf, "RE:", 3) ||
		 !strncmp (buf, "Re:", 3) ||
		 !strncmp (buf, "re:", 3) )
	{
		c1 = c2 + 3;
	}

	/* Never mind if no Re: */
	if (c1 == c2) return (0);

	/* Now shift over Re: */
	while (*c1) *c2++ = *c1++;
	*c2 = *c1;	/* Get null */
	return (0);
}

#ifdef __STDC__
struct thr_ent *FindThread (struct grp_ent *gp)
#else
struct thr_ent *FindThread (gp)
struct grp_ent *gp;
#endif
/*
 *  Find spot for current subject (in buf)
 */
{
	struct thr_ent *tp, *ttp, *ltp;
	int compare;

	/* Loop through threads */
	ltp = NULL;
	for (tp=gp->thr_list; tp!=NULL; ltp=tp, tp=tp->next)
	{
		/* Compare with this subject */
		compare = strcmp (buf, tp->subject);

		if (compare > 0)
		{
			/* New subject lower than current, just go on */
			continue;
		}
		else if (compare == 0)
		{
			/* Found a match! */
			tp->count++;
			return (tp);
		}
		else if (compare < 0)
		{
			/* Need a new one in front of this one */
			ttp = AllocThread ();

			if (ltp == NULL)
			{
				/* None before this one */
				gp->thr_list = ttp;
				ttp->next = tp;
				return (ttp);
			}
			else
			{
				ltp->next = ttp;
				ttp->next = tp;
				return (ttp);
			}
		}
	}

	/* If got here, need new one at end */
	ttp = AllocThread ();

	if (ltp == NULL)
	{
		/* First one */
		gp->thr_list = ttp;
		ttp->next = NULL;
		return (ttp);
	}
	else
	{
		/* Add to end */
		ltp->next = ttp;
		ttp->next = NULL;
		return (ttp);
	}
}

#ifdef __STDC__
char *Fgets (char *c, int n, FILE *fd)
#else
char *Fgets (c, n, fd)
char *c;
int n;
FILE *fd;
#endif
/*
 *  Same as fgets, but changes trailing linefeed to a null
 */
{
	char *p;

	if (NULL == fgets (c, n, fd)) return (NULL);

	for (p=c; *p; p++)
	{
		if (*p == '\r') *p = 0;
		if (*p == '\n') *p = 0;
	}

	return (c);
}

#ifdef __STDC__
void OutOfMemory(void)
#else
OutOfMemory()
#endif
{
	fprintf (stderr, "%s: out of memory\n", progname);
	exit (0);
}

#ifdef __STDC__
struct art_ent *AllocArticle (void)
#else
struct art_ent *AllocArticle ()
#endif
{
	struct art_ent *ap;

	ap = (struct art_ent *) malloc (sizeof (struct art_ent));
	if (ap == NULL) OutOfMemory();

	ap->next = NULL;
	return (ap);
}

#ifdef __STDC__
struct thr_ent *AllocThread (void)
#else
struct thr_ent *AllocThread ()
#endif
{
	struct thr_ent *tp;

	if (NULL == (tp = (struct thr_ent *)
			malloc (sizeof (struct thr_ent)))) OutOfMemory();

	if (NULL == (tp->subject = (char *)
			malloc (1+strlen(buf)))) OutOfMemory();

	strcpy (tp->subject, buf);
	tp->count = 1;
	tp->next = NULL;
	tp->art_list = NULL;
	tp->want = UNDECIDED;
	return (tp);
}

#ifdef __STDC__
void CountThreads (void)
#else
CountThreads ()
#endif
/*
 *  Count threads in each group 
 */
{
	struct grp_ent *gp;
	struct thr_ent *tp;

	for (gp=grp_list; gp!=NULL; gp=gp->next)
	{
		gp->threads = 0;

		for (tp=gp->thr_list; tp!=NULL; tp=tp->next)
		{
			gp->threads++;
			gp->articles += tp->count;
		}
	}
}

#ifdef __STDC__
void WriteSub (char *fn)
#else
WriteSub (fn)
char *fn;
#endif
/*
 *  Write out edited subjects file
 */
{
	FILE *fd;
	struct grp_ent *gp;
	struct thr_ent *tp;

	/* Open it */
	if (NULL == (fd = fopen (fn, "w")))
	{
		fprintf (stderr, "%s: can't open %s for write\n",
					progname, fn);
		exit (0);
	}

	/* Loop through groups */
	for (gp=grp_list; gp!=NULL; gp=gp->next)
	{
		fprintf (fd, "\n*** %s\n", gp->name);

		/* Loop through threads */
		for (tp=gp->thr_list; tp!=NULL; tp=tp->next)
		{
			if (tp->want == YES)
			{
				/* Write articles recursively */
				wa (fd, tp->art_list, tp->subject);
			}
		}
	}
	fclose (fd);
}

#ifdef __STDC__
int wa (FILE *fd, struct art_ent *ap, char *subj)
#else
wa (fd, ap, subj)
FILE *fd;
struct art_ent *ap;
char *subj;
#endif
{
	if (ap == NULL) return (0);

	/* Write the rest of them */
	wa (fd, ap->next, subj);

	/* Write this one */
	if (short_file)
	{
		fprintf (fd, "%s\n", ap->num);
	}
	else
	{
		fprintf (fd, "%s:%s\n", ap->num, subj);
	}
	return (0);
}

#ifdef __STDC__
int Select (void)
#else
Select ()
#endif
/*
 *  Let user pick and choose threads
 */
{
	int n, key;
	struct grp_ent *gp, *tgp;
	struct thr_ent *tp;

	gp = grp_list;

	/* Never mind if no groups */
	if (gp == NULL)
	{
		printf ("Sorry, no groups with unread news.\n");
		return (0);
	}

	/* Print banner of first five groups */
	n = 5;
	printf ("\n");
	while (n && (gp != NULL))
	{
		printf ("%3d threads (%3d articles) in %s\n",
				gp->threads, gp->articles, gp->name);
		n--;
		gp = gp->next;
	}
	if (gp != NULL) printf ("etc...\n");
	gp = grp_list;
	printf ("\n");

	/* Set to read single characters */
#ifdef __UNIX__
	ChMode();
#endif

	/* Process commands forever */
	while (1)
	{
		if (gp == NULL) gp = grp_list;

		/* Put prompt */
		if (gp->done)
			printf ("(DONE) ");
		else
			printf ("       ");
		printf ("%3d thds (%d arts) in %s, do now? [ynq] ",
				gp->threads, gp->articles, gp->name);

		/* Get command */
		key = GetKey ();

		switch (key)
		{
		case 'q':	/* Quit */
#ifdef __UNIX__
			NoChMode();
#endif
			return (0);

		case 'Q':	/* Quit, write short selection file */
			short_file = 1;
#ifdef __UNIX__
			NoChMode();
#endif
			return (0);

		case 'X':	/* Exit, no write */
#ifdef __UNIX__
			NoChMode();
#endif
			exit (0);

		case 'y':	/* Do group now */
		case ' ':
		case 0:
			DoGroup (gp);
			gp = gp->next;
			break;

		case 'n':	/* Next group */
			if (gp->next == NULL)
			{
				printf ("Last group.\n");
			}
			else
			{
				gp = gp->next;
			}
			break;

		case 'p':	/* Previous group */
			if (gp == grp_list)
			{
				printf ("First group.\n");
			}
			else
			{
				for (tgp=grp_list;tgp->next!=gp;tgp=tgp->next);
				gp = tgp;
			}
			break;

		case '^':	/* First group */
			gp = grp_list;
			break;

		case '$':	/* Last group */
			for (gp=grp_list; gp->next!=NULL; gp=gp->next);
			break;

		case 'h':	/* Help */
		case '?':
			GrHelp();
			break;

		case '=':	/* List all groups */
			tgp = grp_list;
			n = ROWS;
			printf ("\n");

			while (tgp != NULL)
			{
				if (tgp->done)
					printf ("(DONE) ");
				else
					printf ("       ");
				printf ("%3d thds (%3d arts) in %s\n",
				   tgp->threads, tgp->articles, tgp->name);
				n--;
				if (n == 0)
				{
					printf ("Any key to continue: ");
					key = GetKey();
					if (key == 'q') break;
					n = ROWS;
				}
				tgp = tgp->next;
			}
			printf ("\n");
			break;

		case 'C':	/* Catch up */
			for (tp=gp->thr_list; tp!=NULL; tp=tp->next)
			{
				tp->want = NO;
			}
			gp->done = 1;
			gp = gp->next;
			break;

		case 'M':	/* Mark all as wanted */
			for (tp=gp->thr_list; tp!=NULL; tp=tp->next)
			{
				tp->want = YES;
			}
			gp->done = 1;
			gp = gp->next;
			break;

		case 'd':	/* Done */
			gp->done = 1;
			gp = gp->next;
			break;

		case 'u':	/* Undone */
			gp->done = 0;
			gp = gp->next;
			break;

		case 's':	/* Statistics */
			Stats();
			break;

		default:
			printf ("No such command.  h for help.\n");
			break;
		}
	}
}

#ifdef __STDC__
int GetKey (void)
#else
int GetKey ()
#endif
{
	int c;
/***
	Fgets (buf, BUF_LEN, stdin);
	c = 0xff & buf[0];
***/
#ifdef __MSDOS__
	c = 0xff & getch();
	putchar ('\n');
	return (c);
#else
	c = 0xff & getchar();
	printf ("\n");
	fflush (stdout);
	return (c);
#endif
}

#ifdef __STDC__
void GrHelp (void)
#else
GrHelp()
#endif
/*
 *  Print help for group selection level
 */
{
	printf ("\n");
	printf ("y    Do this group now.\n");
	printf ("n    Next group.\n");
	printf ("p    Previous group.\n");
	printf ("^    Go to first group.\n");
	printf ("$    Go to last group.\n");
	printf ("=    List all groups.\n");
	printf ("h    Help.\n");
	printf ("d    Mark group as done.\n");
	printf ("u    Mark group as not done.\n");
	printf ("C    Catchup, mark all threads as unwanted.\n");
	printf ("M    Mark all threads as wanted.\n");
	printf ("s    Statistics.\n");
	printf ("q    Quit and write selection file.\n");
	printf ("Q    Quit and write short selection file.\n");
	printf ("X    Quick exit, don't write selection file.\n");
	printf ("\n");
}

#ifdef __STDC__
int DoGroup (struct grp_ent *gp)
#else
DoGroup (gp)
struct grp_ent *gp;
#endif
{
	struct thr_ent *tp, *ttp;
	int n, key;

	printf ("\n");
	tp = gp->thr_list;

	/* Process command forever */
	while (1)
	{
		if (tp == NULL)
		{
			gp->done = 1;
			putchar('\n');
			return (0);
		}

		/* Give prompt */
		if (tp->want == YES)
			printf ("Y ");
		else
			printf ("N ");
		printf ("(%d) ", tp->count);
		printf ("\"%s\", want? [ynq] ", tp->subject);

		/* Get command */
		key = GetKey();

		switch (key)
		{
		case 'y':	/* Yes, want it */
		case ' ':
		case 0:
			tp->want = YES;
			tp = tp->next;
			break;

		case 'n':	/* No */
			tp->want = NO;
			tp = tp->next;
			break;

		case 'N':	/* Next, no change */
			tp = tp->next;
			break;

		case 'p':	/* Previous thread */
			if (tp == gp->thr_list)
			{
				printf ("First thread.\n");
			}
			else
			{
				for (ttp = gp->thr_list;
				     ttp->next != tp;
				     ttp = ttp->next);
				tp = ttp;
			}
			break;

		case '^':	/* First thread */
			tp = gp->thr_list;
			break;

		case '$':	/* Last thread */
			for (tp=gp->thr_list; tp->next!=NULL; tp=tp->next);
			break;

		case 'q':	/* Quit, mark done */
			gp->done = 1;
			putchar('\n');
			return (0);

		case 'Q':	/* Quit, mark not done */
			gp->done = 0;
			putchar('\n');
			return (0);

		case 'X':	/* Quick exit */
#ifdef __UNIX__
			NoChMode();
#endif
			exit (0);

		case 'h':	/* Help */
		case '?':
			ThHelp();
			break;

		case '=':	/* List all threads */
			ttp = gp->thr_list;
			n = ROWS;
			printf ("\n");

			while (ttp != NULL)
			{
				if (ttp->want == YES)
					printf ("Y ");
				else
					printf ("N ");
				printf ("(%d) ", ttp->count);
				printf ("\"%s\"\n", ttp->subject);

				n--;
				if (n == 0)
				{
					printf ("Any key to continue: ");
					key = GetKey();
					if (key == 'q') break;
					n = ROWS;
				}
				ttp = ttp->next;
			}
			printf ("\n");
			break;

		case 's':	/* Statistics */
			Stats();
			break;

		default:
			printf ("No such command, h for help.\n");
			break;
		}
	}
}

#ifdef __STDC__
void ThHelp(void)
#else
ThHelp()
#endif
/*
 *  Help for thread selection
 */
{
	printf ("\n");
	printf ("y    Yes, download this thread.\n");
	printf ("n    No, don't want this thread.\n");
	printf ("N    Next thread.\n");
	printf ("p    Previous thread.\n");
	printf ("^    First thread.\n");
	printf ("$    Last thread.\n");
	printf ("=    Print all threads.\n");
	printf ("h    Help.\n");
	printf ("s    Statistics.\n");
	printf ("q    Quit group, mark done.\n");
	printf ("Q    Quit group, mark not done.\n");
	printf ("X    Quick exit, don't write selection file.\n");
	printf ("\n");
}

#ifdef __STDC__
void Stats(void)
#else
Stats()
#endif
/*
 *  Print article and thread counts
 */
{
	struct grp_ent *gp;
	struct thr_ent *tp;
	int tot_arts, tot_thds, sel_arts, sel_thds;

	tot_arts = tot_thds = sel_arts = sel_thds = 0;

	/* Loop through groups */
	for (gp=grp_list; gp!=NULL; gp=gp->next)
	{
		/* Loop through threads for this group */
		for (tp=gp->thr_list; tp!=NULL; tp=tp->next)
		{
			/* Maintain counts */

			tot_arts += tp->count;
			tot_thds++;

			if (tp->want == YES)
			{
				sel_arts += tp->count;
				sel_thds++;
			}
		}
	}

	printf ("Threads:  %3d total, %3d selected.\n", tot_thds, sel_thds);
	printf ("Articles: %3d total, %3d selected.\n", tot_arts, sel_arts);
}

#ifndef __MSDOS__

#ifdef __STDC__
void ChMode(void)
#else
ChMode()
#endif
/*
 *  Set tty to return single characters
 */
{
#ifdef USG
	ioctl(0, TCGETA, &oldtty);
	ioctl(0, TCGETA, &newtty);
	newtty.c_iflag &= ~(IGNBRK|INLCR|IGNCR|ICRNL|IUCLC);
	newtty.c_iflag |=  (BRKINT);
	newtty.c_oflag &= ~(OLCUC|OCRNL|ONOCR|ONLRET|TAB3);
	newtty.c_oflag |=  (OPOST|ONLCR);
	newtty.c_lflag &= ~(ICANON|XCASE|ECHO|ECHOE|ECHOK|ECHONL);
	newtty.c_lflag |=  (ISIG);
	newtty.c_cc[VMIN] = 1;
	newtty.c_cc[VTIME] = 0;
	ioctl(0, TCSETAF, &newtty);
#else
	ioctl(0, TIOCGETP, &oldtty);
	ioctl(0, TIOCGETP, &newtty);

	newtty.sg_flags &= ~ECHO;	/* Don't echo */
	newtty.sg_flags |= CBREAK;	/* Go into cbreak mode */
	ioctl(0, TIOCSETP, &newtty);
#endif
}

#ifdef __STDC__
void NoChMode(void)
#else
NoChMode()
#endif
/*
 *  Set tty back to normal
 */
{
#ifdef USG
	(void) ioctl(0, TCFLSH, 0);
	(void) ioctl(0, TCSETAW, &oldtty);
#else
	(void) ioctl(0, TIOCFLUSH, (struct sgttyb *)0);
	(void) ioctl(0, TIOCSETP, &oldtty);
#endif
}
#endif  /* not _MSDOS__ */
