/*
 *  Header for us (uqwk selector)
 */

#define US_VERSION "1.0"

#define BUF_LEN	(4096)
#define YES	(2)
#define NO	(1)
#define UNDECIDED (0)
#define ROWS	(23)

/* This is the stuff we remember about each newsgroup */
struct grp_ent
{
	char *name;		/* Group name */
	int threads;		/* Number of threads */
	int articles;		/* Number of articles */
	int done;		/* Done with group? */
	struct thr_ent *thr_list; /* Pointer to threads list */
	struct grp_ent *next;	/* Pointer to next */
} *grp_list, *last_gp;

/* This is the stuff we remember about each thread */
struct thr_ent
{
	int count;		/* Number of articles in thread */
	int want;		/* Does user want this thread */
	char *subject;		/* Thread's subject */
	struct art_ent *art_list; /* Pointer to article list */
	struct thr_ent *next;	/* Pointer to next */
};

/* This is the stuff we remember about each article */
struct art_ent
{
	int num;		/* Article number */
	struct art_ent *next;	/* Pointer to next */
};

#ifdef __UNIX__
#ifdef USG
struct termio oldtty, newtty;
#else
struct sgttyb oldtty, newtty;
#endif
#endif

/* Function Prototypes */
#ifdef __STDC__
void ReadSub (char *fn);
struct grp_ent *AddGroup (char *name);
struct grp_ent *AllocGroup (char *name);
int AddArticle (struct grp_ent *gp);
int UnRe (void);
struct thr_ent *FindThread (struct grp_ent *gp);
char *Fgets (char *c, int n, FILE *fd);
void OutOfMemory(void);
struct art_ent *AllocArticle (void);
struct thr_ent *AllocThread (void);
void CountThreads (void);
void WriteSub (char *fn);
int wa (FILE *fd, struct art_ent *ap, char *subj);
int Select (void);
int GetKey (void);
void GrHelp(void);
int DoGroup (struct grp_ent *gp);
void ThHelp(void);
void Stats(void);
void ChMode(void);
void NoChMode(void);
#else
struct grp_ent *AddGroup ();
struct grp_ent *AllocGroup ();
int AddArticle ();
int UnRe ();
struct thr_ent *FindThread ();
char *Fgets ();
struct art_ent *AllocArticle ();
struct thr_ent *AllocThread ();
int wa ();
int Select ();
int GetKey ();
int DoGroup ();
#endif

char buf[BUF_LEN];		/* General purpose buffer */
char *progname;			/* Program name */

int short_file;			/* Want short selection file? */
