/*
#ident	"@(#)smail/src:RELEASE-3_2_0_120:smail.h,v 1.23 2004/08/17 19:36:12 woods Exp"
 */

/*
 *    Copyright (C) 1987, 1988 Ronald S. Karr and Landon Curt Noll
 *    Copyright (C) 1992  Ronald S. Karr
 * 
 * See the file COPYING, distributed with smail, for restriction
 * and warranty information.
 */

/*
 * smail.h:
 *	miscellaneous general macros used in the smail source files.
 */

/*
 * typedefs for general use
 *
 * WARNING: be damn sure these are private!
 */

/*
 * This is a special type used to keep the width and alignment of the storage
 * for boolean configuration attributes the same regardless of whether they're
 * main config file attributes (and thus each stored in separate variables, or
 * they are combined in a driver's private flags variable.
 *
 * We use an "unsigned long int" so as to accommodate at least 32 bits on even
 * "small" platforms.
 */
typedef unsigned long int	smail_bool_t;	/* boolean flags */

/*
 * #defines for general use
 */

#undef TRUE				/* SunOS-5 defines this in <rpc/types.h> */
#define TRUE		1		/* All true wisdom is found on T-shirts */
#undef FALSE				/* SunOS-5 defines this in <rpc/types.h> */
#define FALSE		0		/* This fortune is false */
#define SUCCEED		0		/* function succeeded (XXX deprecate!) */
#define FAIL		(-1)		/* function failed */

#define EQ(a, b)	(strcmp((a), (b)) == 0) /* TRUE if strings a and b equal */
#define EQIC(a, b)	(strcmpic((a), (b)) == 0) /* as EQ() but case is insignificant */

/*
 * compare a header name 'nm' with a header field 'hf' to see if names match
 * return TRUE if match, FALSE if no match
 */
#define HDREQ(nm, hf)	(!strncmpic((nm), (hf), strlen((nm))) &&	\
			 ((hf)[strlen((nm))] == ':' ||			\
			  isspace((int) (hf)[strlen((nm))])))
/*
 * size for various names used in the configuration tables read from
 * the startup file, or compiled in with default.c.
 */
#define	CONFIG_NAMSIZ	16		/* 15 chars plus a nul byte */

/*
 * return the integer offset from the start of a given structure type
 * to a given tag.  (XXX should use (void *), especially for __STDC__)
 */
#define OFFSET(type, tag) \
    (int) ((char *) (&((struct type *) 0)->tag) - (char *) (struct type *) 0)

/* FIXME: get rid of this ugly hack! */
/* return the number of elements in an array. */
#define TABLESIZE(table) \
    (sizeof(table) / sizeof((table)[0]))

/* FIXME: get rid of this ugly hack! */
/* return a pointer to the end of a table. */
#define ENDTABLE(table) \
    ((table) + TABLESIZE(table))

/*
 * #defines for portability (may be used in other headers)
 */

#if !defined(sgi) && !defined(__STDC__)
/* damned SGI compiler complains if you undef an ANSI thing!!! */
# ifdef	NULL				/* make sure NULL is 0 */
#  undef NULL
# endif
# define NULL		0		/* the one true C `nil' pointer value */
#endif

#undef BELL
#if defined(__STDC__)
# define BELL		'\a'
#else
# define BELL		'\007'
#endif

#ifndef __P		/* in *BSD's <sys/cdefs.h>, included by everything! */
# if ((__STDC__ - 0) > 0) || defined(__cplusplus)
#  define __P(protos)	protos		/* full-blown ANSI C */
# else
#  define __P(protos)	()		/* traditional C */
# endif
#endif

#ifndef volatile	/* in *BSD's <sys/cdefs.h>, included by everything! */
# if !defined(__STDC__) && !defined(__cplusplus)/* ((__STDC__ - 0) > 0) ??? */
#  define volatile	/* NOTHING (most compilers won't optimize global variables) */
# endif
#endif

#ifndef const		/* in *BSD's <sys/cdefs.h>, included by everything! */
# if ((__STDC__ - 0) <= 0) && !defined(__cplusplus)
#  define const		/* NOTHING */
# endif
#endif

/* adapt for GCC's lack of adherence to lint's standard ARGSUSED comment */
#ifdef __GNUC__
# define GCC_UNUSED_HACK	__attribute__((unused))
#else
# define GCC_UNUSED_HACK	/* nothing */
#endif

/* NetBSD gained strsignal(3) sometime just prior to 1.0 */
#if defined(__NetBSD_Version__) && (__NetBSD_Version__ >= 100000000)
# define HAVE_STRSIGNAL		1
#endif
/* Note that __NetBSD_Version__ is only in 1.3.3 and -current >= 1.3C */
#if !defined(__NetBSD_Version__) && defined(NetBSD) && (NetBSD >= 1994100)
# define HAVE_STRSIGNAL		1
#endif

/* FreeBSD gained strsignal(3) sometime just prior to 4.0 */
#if defined(__FreeBSD_version) && (__FreeBSD_version >= 400017)
# define HAVE_STRSIGNAL		1
#endif

/* 
 * Local Variables:
 * c-file-style: "smail"
 * End:
 */
