#! /bin/sh
#
#	mkRelease.sh -- generate a new release
#
# Once upon a time I did this all by hand, step by step...
#
# Now the steps to create a full release are reduced to just the following:
#
#	- make sure all changes have been committed
#
#	- make a preview release with ./myPreview.sh and test it using the
#	  pkgsrc infrastructure
#
#	- write a RELEASE-${VERSION} (that's the about-to-be-released version)
#	  release notes file (use previous README-FIRST as a template)
#
#	- update pkgsrc/mail/smail module (should have just been tested with a
#	  preview release, but remember to update DISTNAME _now_) (this script
#	  does check that the setting matches smail-${VERSION} before doing
#	  anything)
#
#	- run this script
#
#	- re-link the symlinks and archive the old version on ftp.planix.com
#
#	- retest pkgsrc/mail/smail
#
#	- update ~/public_html/projects/smail.html and publish it
#
#	- post the README-FIRST file to UseNet and smail3-users
#
#	- go tell FreshMeat.net about it!
#
#ident "@(#)smail:RELEASE-3_2_0_120:mkRelease.sh,v 1.10 2004/08/27 06:57:51 woods Exp"

# NOTE: must be run from within an up-to-date CVS working directory

# by default the new version is the current level less the "-Pre" suffix
#
VERSION=$(awk '/^3/ {sub(/-Pre/, "", $1); print $1;}' level)

# this might not be a good idea -- and if it is it'll need a LOT more work!
# 
# MINOR: increment minor #, go to two levels
# PATCH: increment patch #, go to three levels
#
# and NEXT always goes to BETA of next patch level
#
# Still need to detect true PREV:
#
# 	- simplistic approach:  just get head of tags list
#
#	- better:  use PREV of same TYPE
#
# automatically choose "PATCH" if there's a sticky branch tag?
#
TYPE=${TYPE:-"BETA"}
case $TYPE in
BETA)
	PREV=$(echo ${VERSION} | awk -F . '{printf("%d.%d.%d.%d\n", $1, $2, $3, $4 - 1);}')
	NEXT=$(echo ${VERSION} | awk -F . '{printf("%d.%d.%d.%d\n", $1, $2, $3, $4 + 1);}')
	;;
*)
	echo "$0: Don't know how to make a ${TYPE} release yet!" 1>&2
	exit 1
esac

TAG=RELEASE-$(echo ${VERSION} | sed 's/\./_/g')
PREV_TAG=RELEASE-$(echo ${PREV} | sed 's/\./_/g')

ARCHIVE_DIR="/most/var/spool/ftp/pub/local"
DISTFILES="/most/distfiles"
RELEASE_DIR="/work/woods/release.d"

if [ ! -r level -o ! -d ${RELEASE_DIR} -o ! -d ${ARCHIVE_DIR} ] ; then
	echo "$0: pre-requisite files or directories are missing!" 1>&2
	exit 1
fi

if [ ! -f RELEASE-${VERSION} ] ; then
	echo "$0: you haven't written new ${TYPE} release notes in RELEASE-${VERSION} yet!" 1>&2
	exit 1
fi

if [ "$(echo /usr/pkgsrc/mail/smail/patches/p*)" != '/usr/pkgsrc/mail/smail/patches/p*' ]; then
	echo "$0: there should not be any patches in pkgsrc/mail/smail!" 1>&2
	exit 1
fi

#
#	NOTICE!!!  At this point we're "committed"!
#

(
	sed 1q level
	echo ${VERSION} $(date)
) > level.new
mv level.new level

cvs commit -m "- this is release ${VERSION}" level || exit 1

cvs tag ${TAG} . || exit 1

# uses "level" too so must be run before updating "level" again
#
sh ./mkChangeLog.sh

(
	sed 1q level
	echo ${NEXT}-Pre $(date)
) > level.new
mv level.new level

cvs commit -m "- post ${VERSION} -- get ready to preview release ${NEXT}" level || exit 1

( 
	echo ""
	echo "Release ${VERSION} generated:  $(date)"
) >> RELEASE-${VERSION}

OPWD=$(/bin/pwd)

cd ${RELEASE_DIR} || exit 1

cvs rdiff -u -kv -r ${PREV_TAG} -r ${TAG} m-smail > smail-${PREV}-${VERSION}.diffs
gzip -v smail-${PREV}-${VERSION}.diffs

cvs export -kv -r ${TAG} -d smail-${VERSION} m-smail || exit 1

# keep a copy of these inside the archive too....
cp ${OPWD}/ChangeLog-${VERSION} smail-${VERSION}/ || exit 1
cp ${OPWD}/RELEASE-${VERSION} smail-${VERSION}/ || exit 1

cp ${OPWD}/RELEASE-${VERSION} smail-${VERSION}-README.FIRST || exit 1

pax -w -z -f ${ARCHIVE_DIR}/smail-${VERSION}.tar.gz smail-${VERSION} || exit 1

cp smail-${VERSION}-README.FIRST ${ARCHIVE_DIR}
cp smail-${VERSION}/README ${ARCHIVE_DIR}/smail-${VERSION}-README
cp smail-${VERSION}/ChangeLog-${VERSION} ${ARCHIVE_DIR}/smail-${VERSION}.ChangeLog
cp smail-${PREV}-${VERSION}.diffs.gz ${ARCHIVE_DIR}

cp ${ARCHIVE_DIR}/smail-${VERSION}.tar.gz ${DISTFILES} || exit 1
rm -f ${DISTFILES}/smail-${PREV}.tar.gz ${DISTFILES}/smail-*-Pre-*.tar.gz

(
	cd /usr/pkgsrc/mail/smail
	ed Makefile <<_EOF_
,s/^DISTNAME/#DISTNAME/p
1
/^DISTNAME =	smail-[0-9.]*$/p
s/smail-[0-9.]*$/smail-${VERSION}/p
s/^#*//p
w
q
_EOF_
	make makesum mps
)

rm -f ${ARCHIVE_DIR}/smail-pkgsrc.shar
(
	cd /usr/pkgsrc/mail/smail
	shar DESCR Makefile distinfo INSTALL PLIST files/ files/mailer.conf
) > ${ARCHIVE_DIR}/smail-pkgsrc.shar

cd ${ARCHIVE_DIR} || exit 1

# leave the old README.FIRST
# XXX if making BETA then should leave whatever old RELEASE points to
#
rm smail-${PREV}.tar.gz smail-${PREV}-README smail-${PREV}.ChangeLog smail-*-${PREV}.diffs.gz

FILES="smail-${VERSION}-README.FIRST smail-${VERSION}-README smail-${VERSION}.tar.gz smail-${VERSION}.ChangeLog smail-${PREV}-${VERSION}.diffs.gz smail-pkgsrc.shar"

md5 ${FILES} > smail-${VERSION}.md5

echo rm smail-${TYPE}.tar.gz
echo ln -s smail-${VERSION}.tar.gz smail-${TYPE}.tar.gz
rm smail-${TYPE}.tar.gz
ln -s smail-${VERSION}.tar.gz smail-${TYPE}.tar.gz

echo rm smail.tar.gz
echo ln -s smail-${VERSION}.tar.gz smail.tar.gz
rm smail.tar.gz
ln -s smail-${VERSION}.tar.gz smail.tar.gz

echo rm README-${TYPE}
echo ln -s smail-${VERSION}-README README-${TYPE}
rm smail-README-${TYPE}
ln -s smail-${VERSION}-README smail-README-${TYPE}

echo rm README.FIRST-${TYPE}
echo ln -s smail-${VERSION}-README.FIRST README.FIRST-${TYPE}
rm smail-README.FIRST-${TYPE}
ln -s smail-${VERSION}-README.FIRST smail-README.FIRST-${TYPE}

echo rm README
echo ln -s smail-${VERSION}-README README
rm smail-README
ln -s smail-${VERSION}-README smail-README

echo rm README.FIRST
echo ln -s smail-${VERSION}-README.FIRST README.FIRST
rm smail-README.FIRST
ln -s smail-${VERSION}-README.FIRST smail-README.FIRST

# XXX if making a PATCH or a RELEASE then remove old BETA links...

# XXX ftp.planix.com runs OpenSSH, which rarely wants to do scp with me so
# echo the command out to make it easy to re-do the transfer some other way

echo ""
echo "About to run the command:"
echo "    scp ${FILES} smail-${VERSION}.md5 ftp.planix.com:/u5/ftp/pub/Smail/"

scp ${FILES} smail-${VERSION}.md5 ftp.planix.com:/u5/ftp/pub/Smail/

echo ""
echo "OK, if that worked then we're almost done!"
echo ""
echo "First go re-link as above and archive the old version on ftp.planix.com ..."
echo ""
echo "Then re-test the pkgsrc module and update ~/public_html/projects/smail.html"
echo ""
echo "... then go tell FreshMeat.net, smail3-users, and UseNet !!!"
