#! /bin/sh
:
#ident	"@(#)contrib:RELEASE-3_2_0_110:bouncemail.sh,v 1.2 2000/02/03 02:32:15 woods Exp"
#
#	bouncemail.sh - bounce a mail message
#
# Written by Greg A. Woods while at Nirv Centre / Web Networks <woods@web.net>
# Contributed to the public domain.
#

umask 022

argv0=`basename $0`

USAGE="Usage: $argv0 [-v] message_queue_id"

case "$1" in
-v*)
	verbose="$1"
	shift
	;;
esac

if [ $# -ne 1 ] ; then
	echo $USAGE
	exit 2
fi

if expr "`id`" : '^uid=0(root)' >/dev/null ; then
	:
else
	echo "$argv0:  ERROR:  you must be root to do this!"
	exit 1
fi

# really should be "spool_dir", but that's empty
#
spool_dir=`smail -bP spool_dirs`

# WARNING: the use of $spool_dir/tmp may be special to our
# local config?
#
tmpconfig=$spool_dir/tmp/tc$$

(echo "hi there\c" ; echo " ") >$tmpconfig
# Configure checks to make sure grep returns a status...
if grep c $tmpconfig >/dev/null 2>&1 ; then
	nl=''
	n='-n'
	c=''
else
	nl='\n'
	n=''
	c='\c'
fi
rm -f $tmpconfig

echo "You are about to bounce the following message back to the sender:"
mailq $1

echo $n "Do you want to continue? [n] $c"

read ans junk
case "$ans" in
y*|Y*)
	;;
*)
	echo "$argv0: Aborting..."
	exit 1
	;;
esac

config_file=`smail -bP config_file`

cp $config_file $tmpconfig
echo "retry_duration=0" >> $tmpconfig
trap 'rc=$?; rm -f $tmpconfig; exit $rc' 0 1 2 3 15

smail $verbose -oC $tmpconfig -q $1

exit $?
