#! /bin/sh
:
#
# This script tries to generate a file "iobpeek.h" which defines one
# macro, IOB_MAYBE_EMPTY_P.  The macro can be called with one
# argument, a stdio input stream, and must return a non-zero value if
# the stream's buffer is empty.  If there are characters in the input
# buffer, it *should* return zero.

#ident	"@(#)smail/src:RELEASE-3_2_0_100:geniobpeek.sh,v 1.5 1997/05/09 20:26:46 woods Exp"

# work around brain-damaged Ultrix shell
if test -z "$foo" -a -r /bin/sh5
then
  export foo; foo=bar; exec /bin/sh5 $0 "$1" "$2"
fi

CC=$1; shift
CFLAGS=$1; shift
ECHO=echo
#ECHO=:

rm -f ,testfile

try ()
{
  echo foo bar > ,testfile
  empty_test="$1"
  $ECHO "Trying $empty_test"
  rm -f ,iobtest.c
  cat > ,iobtest.c <<EOM
#include <stdio.h>

#define IOB_MAYBE_EMPTY_P(stream) $empty_test

main (argc, argv) int argc; char **argv;
{
  FILE * in = fopen(",testfile", "r");
  int c;
  if (! in) { fprintf (stderr, "Couldn't open test file\n"); exit (1); }
  if (! IOB_MAYBE_EMPTY_P (in)) {
    fprintf (stderr, "Buffer not empty after fopen()\n"); exit (1);
  }
  c = getc(in);
  if (c != 'f') { fprintf (stderr, "Read error\n"); exit (1); }
  if (IOB_MAYBE_EMPTY_P (in)) {
    fprintf (stderr, "Buffer empty after reading one char\n"); exit (1);
  }
  return 0;
}
EOM

  $CC $CFLAGS -o ,iobtest ,iobtest.c >/dev/null 2>&1 || \
    { $ECHO "  nope, that didn't work...  hmmm..."; return 1 ; }
  if ./,iobtest
  then
    $ECHO "  Got it!"
    cat > iobpeek.h <<EOM
/* iobpeek.h - DO NOT EDIT!
   Automatically generated by geniobpeek.sh */
#define IOB_MAYBE_EMPTY_P(stream) $empty_test

/* ESMTP Pipelining can be supported on this platform */
#ifndef NO_HAVE_ESMTP_PIPELINING
#define HAVE_ESMTP_PIPELINING
#endif
EOM
    status=0
  else
    status=1
  fi
  rm -f ,iobtest ,iobtest.c ,testfile
  return $status
}

# IRIX, SunOS 4, Solaris 2
try '((stream)->_cnt == 0)' && exit 0
# Older systems may have this
try '((stream)->cnt == 0)' && exit 0
# SCO OSR5
try '((stream)->__cnt == 0)' && exit 0
# Linux
try '((stream)->_IO_read_ptr >= (stream)->_IO_read_end)' && exit 0
# GNU libc 1.08.1
try '((stream)->bufp >= (stream)->__get_limit)' && exit 0
# BSDI-1.1 - thanks to Jon Diekema <diekema@cideas.com>
try '((stream)->_r <= 0)' && exit 0

cat > iobpeek.h <<EOM
/* iobpeek.h - DO NOT EDIT!
   Automatically generated by geniobpeek.sh */

/* ESMTP Pipelining is not supported on this platform */
#define NO_HAVE_ESMTP_PIPELINING
#undef HAVE_ESMTP_PIPELINING
#define IOB_MAYBE_EMPTY_P(f) 1
EOM

# NOTE: recent mail from Simon arrived
#	From: Simon Leinen <simon@instrumatic.ch>
#
cat 1>&2 <<EOM
*** Error: could not find out how to check for an empty stdio stream
***        buffer on this system.  Please notify Simon Leinen
***        <simon@lia.di.epfl.ch> of this problem.
***
*** Smail will build without ESMTP pipelining support
EOM
exit 0
