#ifndef lint
static char *rcsid = "@(#) $Id: queue.c,v 1.2 95/07/22 12:45:18 listserv Exp $";
static char *copid = "@(#) Copyright (C) 1993  Christophe Wolfhugel & Herve Schauer Consultants";
#endif
/*
**  ML - A Unix Mailing Lists manager.
**
**  Copyright (C) 1994  Christophe Wolfhugel & Herve Schauer Consultants
**
**  Please read the files COPYRIGHT and AUTHORS for the extended
**  copyrights refering to this file.
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 1, or (at your option)
**  any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <fcntl.h>
#include <sysexits.h>
#include "conf.h"
#ifdef FAKESYSLOG
# include "fakesyslog.h"
#else
# include <syslog.h>
#endif

static char	qfile[32];
static char	buf[16384];
static int	i, fd;

/*
** Main loop.
*/
void
main(int argn, char **argv)
{
   openlog("queue", LOG_PID, LOG_AUTH);
   if (argn != 2) {
      syslog(LOG_NOTICE, "Invalid number of arguments");
      exit(EX_TEMPFAIL);
   }
   if (chdir(TULPDIR) == -1) {
      syslog(LOG_NOTICE, "Can't chdir to %s: %m", TULPDIR);
      exit(EX_TEMPFAIL);
   }
   if (chdir(QUEUE_DIR) == -1) {
      syslog(LOG_NOTICE, "Can't chdir to %s: %m", QUEUE_DIR);
      exit(EX_TEMPFAIL);
   }
   umask(UMASK);
   sleep(1);
   sprintf(qfile, "%ld.%d", time(NULL), getpid());
   qfile[2] = 'T';
   fd = open(qfile + 2, O_CREAT|O_WRONLY, 0600);
   if (fd == -1) {
      syslog(LOG_NOTICE, "Could not open %s: %m", qfile +2);
      exit(EX_TEMPFAIL);
   }
   write(fd, "X-Listserv-To: ", 15);
   write(fd, argv[1], strlen(argv[1]));
   write(fd, "\n", 1);
   while ((i = read(fileno(stdin), buf, sizeof buf)) > 0)
      write(fd, buf, i);
   close(fd);
   rename(qfile + 2, qfile + 3);
   exit(0);
}
