# This file defines the services supported by the local MESH installation
# and some important configuration variables
# many of these lines are uncommented and may need customization
# to use

# first add the services source directory to the tcl library path
#
lappend auto_path [glob ~/src/services]

# now define the log file for requests (comment out if you don't want it)
#
#set servlog [glob ~/servlog]

# if you want some administrator to be Cc'ed on ServiceMail errors,
# uncomment this line and set the administrator to be his/her address or
# alias
#
#set administrator servicemail-bugs

# next define all services
#
#                external-name   internal-name   source-file
#
#define-service   latex2ps          dolatex       ~/src/services/latex2ps.tcl
#define-service   archive-request   dofetch       ~/src/services/archive-request.tcl
#define-service   get               dofetch       ~/src/services/archive-request.tcl
#define-service   uudecode          uudecode      ~/src/services/uudecode.tcl
#define-service   mbsend            mbsend        ~/src/services/mbsend.tcl
#define-service   ps2paper          doprint       ~/src/services/ps2paper.tcl
#define-service   fax               fax           ~/src/services/fax.tcl
#define-service   listserv          listserv      ~/src/services/listserv.tcl
#define-service   subscribe         subscribe     ~/src/services/subscribe.tcl
define-service   help              help          ~/src/services/help.tcl
define-service   info              help          ~/src/services/help.tcl
define-service   services          list-services ~/src/services/services.tcl
#define-service   finger            finger        ~/src/services/finger.tcl
#define-service   man               man           ~/src/services/man.tcl
define-service   "Re:"             re            ~/src/services/Re.tcl
#define-service  stock-download     stock-download ~/src/services/stock-download.tcl
#define-service  stock		   stock	 ~/src/services/stock.tcl
define-service  echo		   echo          ~/src/services/echo.tcl
#define-service  dis                dodis         ~/src/services/dis.tcl
#define-service  directory          directory     ~/src/services/directory.tcl
#define-service  register           register      ~/src/services/register.tcl
#define-service  find               find          ~/src/services/find.tcl
#define-service  retrieve           retrieve      ~/src/services/retrieve.tcl
#define-service  anon-ftp           ftp           ~/src/services/ftp.tcl
#define-service  source             source        ~/src/services/source.tcl
#define-service  notification       notification  ~/src/services/notification.tcl
#define-service  filter             mfilter       ~/src/services/filter.tcl

# patterns need an external-name and a tcl expression
#
#define-pattern  help \
#      { [regexp -nocase "^services-help" [getfield $envelope TO]] }
