# userdefs.pl -- sample userdefs.
# SCCS Status     : @(#)@ ud_sample1.pl	1.3
# Author          : Johan Vromans
# Created On      : Fri Dec 18 22:29:57 1992
# Last Modified By: Johan Vromans
# Last Modified On: Fri Jan  1 18:01:30 1993
# Update Count    : 19
# Status          : Use at your own risk

# How to implement Mail Server extensions.
#
#  1. Write a subroutine to parse the command.
#     See 'pr_parse.pl' for lots of examples.
#     Any work should be pushed on the @workq.
#  2. Add a command verb to $cmd_tbl, pointing to this routine.
#     The command verb must be in ALL UPPERCASE.
#  3. Write a subroutine to execute the command.
#     See 'pr_dowork.pl' for lots of examples.
#  4. Add a command verb to $exe_tbl, pointing to this routine.
#     Since the Mail Server uses uppercase command verbs, 
#     please use a lowercase verb.
#  5. Add a help message using &add_help.
#
# As an example, the following code adds the 'REPORT' command to the
# Mail Server.

sub cmd_report {			# step 1.
    # Check syntax.
    # $cmd is the command verb, upcased.
    # @cmd has the remainder of the command.
    return &errmsg ("Usage: $cmd") unless @cmd == 0;

    # Push exe command on work queue.
    push (@workq, &zp ('r'));

    # Feedback.
    print STDOUT ("=> Okay\n");
    1;
}

$cmd_tbl{'REPORT'} = 'cmd_report';	# step 2.

sub exe_report {			# step 3.
    &do_unix ("$libdir/report -usage");
    1;
}

$exe_tbl{'r'} = 'exe_report';		# step 4.

&add_help ('REPORT',			# step 5.
	   'Generate a mail server usage report.');

################ 1 ################
1;
