#!/usr/local/bin/perl
# report.pl -- make mail server report
# SCCS Status     : @(#)@ report	3.14
# Author          : Johan Vromans
# Created On      : Sat May  2 14:23:10 1992
# Last Modified By: Johan Vromans
# Last Modified On: Fri Dec 25 16:22:32 1992
# Update Count    : 67
# Status          : Unknown, Use with caution!

# Read the mail server logfile, and create a report.

$my_name = "report";
$my_version = "3.14";
#
################ Common stuff ################

$libdir = $ENV{"MSERVLIB"} || "/usr/local/lib/mserv";
unshift (@INC, $libdir);

################ Options handling ################

&options if @ARGV > 0 && $ARGV[0] =~ /^-+[^-]+/;
require "ms_common.pl";
$opt_usage = 1 unless $opt_errors;
@ARGV = ( $logfile ) unless @ARGV > 0;
$now = time;

################ Preamble ################

require "$libdir/rfc822.pl";

format std_hdr =
Mail Server Report for @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<     @>>>>>>>>>>>>
"$thismonth 19$year -- by $report_type", "Page $%"

                                                         1111111111222222222233
@<<<<<<<<<<<<<<<<<<<                 Type Total 1234567890123456789012345678901
$report_type
-------------------------------------------------------------------------------
.

format std_out =
^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< @ @>>>> @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$item, $type, $count, $seq
 ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<~~
$item
.

################ Main ################

$logfile = $ARGV[0] if @ARGV == 1;

open (LOG, $logfile) || die ("$my_name: Cannot open $logfile [$!]\n");

$curmonth = "";
@mnames = split (/,/, "January,February,March,April,May,June," .
		"July,August,September,October,November,December");

# Form pattern for the known libraries so we can easily
# strip them off the names of the requests.
$libpat = "(";
foreach $lib ( @libdirs ) {
    $lib =~ s/(\W)/\\\1/g;
    $libpat .= $lib . "|";
}
chop ($libpat);
$libpat .= ")";

# Process logfile.
$msgcnt = 0;
while ( <LOG> ) {

    # 891002 19:48 M "Neil Dixon <neil@yc1>" /u2/goodies/gwm/INDEX U1/1 32678
    #    0     1   2             3                  4                5    6

    # Note: $size is not used (yet).
    ($date, $time, $type, $user, $pkg, $part, $size) = 
	/^(\S+)\s+(\S+)\s(\S+)\s+"([^\042]+)"\s+(.+)\s+(\S+\/\d+)\s+(\S+)$/;

    unless ( defined $user ) {	# Assume error record.

	next unless $opt_errors;

	($date, $time, $msg) = 
	    /^(\S+)\s+(\S+)\s+(.+)$/;
	$date .= " " . $time;
	next if $since && $date lt $since; 

	if ( $msgcnt == 0 && $since ) {
	    print STDERR ("Errors since $since\n\n");
	}
	print STDERR ($date, " ", $msg, "\n");
	$msgcnt++;
	next;
    }

    next unless $opt_usage;

    # Use first parts for accounting only.
    next unless $part =~ m|^[^0-9]*1/|;

    # Get date.
    $year = substr ($date, 0, 2);
    $month = substr ($date, 2, 2);
    $day = substr ($date, 4, 2);

    # Strip known libraries.
    $pkg = $' if $pkg =~ /^$libpat\//o;
    $pkg = $` if $pkg =~ /\s+\(.+\)$/;
    $pkg .= $type;

    # Generate a new report page if the month runs over.
    if ( $curmonth ne $month ) {
	if ( $curmonth ne "" ) {
	    &report;
	    $- = 0;			# Force page break.
	    reset "Z";
	}
	$curmonth = $month;
	$thismonth = $mnames[$curmonth-1];
	$weeksh = &firstday ($month, $year);
    }

    # Normalize addresses and count them.
    &rfc822'parse_addresses ($user);
    $user = $rfc822'addresses[0] . $type;
    $Zucounts{$user}++;
    $Zudays{$user} |= 1 << ($day - 1);
    $Zpcounts{$pkg}++;
    $Zpdays{$pkg} |= 1 << ($day - 1);
}
close (LOG);

# Update since-file.
if ( $opt_since && !$opt_noupdate ) {
    utime ($now, $now, $opt_since) ||
	print STDERR ("Cannot change times on \"$opt_since\" [$!]\n");
}

# Now for the remaining usage reports ...
&report if $opt_usage;

# That's it ...
exit (0);

################ Subroutines ################

sub report {
    $^ = "std_hdr";
    $~ = "std_out";
    $: = " \n-/";
    &report1;
    print STDOUT ($^L);		# Form-feed between reports.
    &report2;
}

sub report1 {
    local ($report_type) = "User";
    local ($total) = 0;
    local ($days) = 0;
    local ($seq, $days, $count, $type);
    $- = 0;
    $% = 0;

    foreach $item (sort (keys (%Zucounts))) {
	$seq = &daylist ($Zudays{$item});
	$days |= $Zpdays{$item};
	$count = $Zucounts{$item};
	$total += $count;
	$type = chop ($item);
	write;
    }
    $item = "TOTAL";
    $type = "";
    $seq = &daylist ($days);
    $count = $total;
    write;
}

sub report2 {
    local ($report_type) = "Package";
    local ($total) = 0;
    local ($days) = 0;
    local ($seq, $days, $count, $type);
    $- = 0;
    $% = 0;

    foreach $item (sort (keys (%Zpcounts))) {
	$seq = &daylist ($Zpdays{$item});
	$days |= $Zpdays{$item};
	$count = $Zpcounts{$item};
	$total += $count;
	$type = chop ($item);
	write;
    }
    $item = "TOTAL";
    $type = "";
    $seq = &daylist ($days);
    $count = $total;
    write;
}

sub daylist {
    local ($day) = pop (@_);
    local ($seq) = "";
    local ($cc) = 1;

    while ( $cc <= 31 ) {
	if ( $day & 0x1 ) {
	    $seq .= substr ("SMTWTFS", ($cc - $weeksh + 7) % 7, 1);
	}
	else {
	    $seq = "$seq ";
	}
	$day >>= 1;
	$cc++;
    }
    return $seq;
}

sub firstday {
    local ($month) = shift (@_);
    local ($year) = shift (@_);
    local ($t);
    local (@tm); 

    $t = 
	($year - 70) * (365 * 24 * 60 * 60) +
	    ($month - 1) * (28 * 24 * 60 * 60);
    $month--;

    do {
	@tm = localtime ($t);
	$t += (28 * 24 * 60 * 60);
    }
    while (($tm[5] < $year) || ($tm[4] < $month));

    $t = ($tm[3] - $tm[6]) % 7;
    $t += 7 if $t < 0;
    return $t;
}

sub options {
    local ($opt_full, $opt_help, $opt_ident) = (0, 0, 0);

    require "newgetopt.pl";

    $opt_errors = $opt_usage = 0;
    if ( !&NGetOpt ("config=s", "ident", "errors", "usage", "full",
		    "since=s", "noupdate",
		    "help")
	|| $opt_help
	|| (@ARGV > 1)) {
	&usage;
    }
    $opt_errors |= $opt_full;
    $opt_usage |= $opt_full;
    print ($my_package, " [", $my_name, " ", $my_version, "]\n")
	if $opt_ident && $opt_usage;
    print STDERR ($my_package, " [", $my_name, " ", $my_version, "]\n")
	if $opt_ident && $opt_errors;
    if ( defined $opt_since ) {
	local ($a) = (stat ($opt_since))[9];
	die ("Cannot timestamp \"$opt_since\" [$!]\n") unless $a > 0;
	local (@tm) = localtime ($a);
	$since = sprintf ("%02d%02d%02d %02d:%02d",
			  $tm[5], 1+$tm[4], $tm[3], $tm[2], $tm[1]);
	$opt_noupdate = defined $opt_noupdate;
    }
    else {
	$since = "";
    }
    $config_file = $opt_config if defined $opt_config;
}

sub usage {
    require "ms_common.pl";
    print STDERR <<EndOfUsage;
$my_package [$my_name $my_version]

Usage: $my_name [options] [ logfile ]

Options:
    -config XX	use alternate config file
    -errors	generate error report to STDERR
    -usage	generate usage report to STDOUT
    -full	generate usage report and error report
    -since FILE	only error messages newer than FILE
		(FILE date will be updated upon successful completion)
    -noupdate	do not update FILE
    -help	this message
    -ident	print program identification

Default action is to generate a usage report from logfile
"$logfile".
EndOfUsage
    exit (1);
}
