
echo "Extracting Makefile with variable substitutions from ./config"

cat > Makefile <<EOF_MAKEFILE

#
# This Makefile was created from Makefile.SH on `date`
# Don't edit it directly; change Makefile.SH instead.
#

LIB	= `./getval lib`
OWNER	= daemon
GRP	= daemon

TARGETS = dorequest process listener
SRC	= dorequest.pl process.pl rfc822.pl listener.c
DIST	= README INSTALL getval Makefile.SH user_docs config unpack.pl

all:	Makefile $(TARGETS)

listener:
	cc $(CFLAGS) -DNICEVALUE=10 -DPERL=\"`./getval perl`\" \\
		-DPROCESS=\"$(LIB)/process\" -DSERVER=\"$(OWNER)\" -o listener listener.c

process: process.pl
	rm -f process
	cp process.pl process
	chmod +x process

dorequest: dorequest.pl
	rm -f dorequest
	cp dorequest.pl dorequest
	chmod +x dorequest

install: all dirs suid other

dirs:
	install -c -g $(GRP) -o $(OWNER) -m 755 -d $(LIB)
	install -c -g $(GRP) -o $(OWNER) -m 755 -d `./getval docdir`

suid: process
	install -c -g $(GRP) -o $(OWNER) -m 555 process $(LIB)/process
	install -c -g $(GRP) -o $(OWNER) -m 4555 listener $(LIB)/listener

other: dorequest config user_docs
	install -c -g $(GRP) -o $(OWNER) -m 555 dorequest $(LIB)
	install -c -g $(GRP) -o $(OWNER) -m 444 rfc822.pl config $(LIB)
	install -c -g $(GRP) -o $(OWNER) -m 444 user_docs/* `./getval docdir`
	install -c -g $(GRP) -o $(OWNER) -m 640 /dev/null `./getval logfile`

clean:
	rm -f $(TARGETS)

dist:
	tar -cvf - $(SRC) $(DIST) | compress > dist.TZ
	
Makefile: Makefile.SH
	@echo "Rerun Makefile.SH before making"
	@/bin/false
EOF_MAKEFILE
