#include "stralloc.h"
#include "substdio.h"
#include "subfd.h"
#include "readwrite.h"
#include "exit.h"
#include "byte.h"
#include "cdbmake.h"
#include "alloc.h"
#include "seek.h"

void usage() {
  substdio_putsflush(subfderr,"tcpmakectl: usage: tcpmakectl rules.cdb rules.tmp\n");
  _exit(1);
}

void die_bad() {
  substdio_putsflush(subfderr,"tcpmakectl: fatal: bad input format\n");
  _exit(111);
}

void die_read() {
  substdio_putsflush(subfderr,"tcpmakectl: fatal: unable to read input\n");
  _exit(111);
}

void die_create() {
  substdio_putsflush(subfderr,"tcpmakectl: fatal: unable to create temporary output\n");
  _exit(111);
}

void die_write() {
  substdio_putsflush(subfderr,"tcpmakectl: fatal: unable to write to temporary output\n");
  _exit(111);
}

void die_rename() {
  substdio_putsflush(subfderr,"tcpmakectl: fatal: unable to move temporary output into place\n");
  _exit(111);
}

void die_nomem() {
  substdio_putsflush(subfderr,"tcpmakectl: fatal: out of memory\n");
  _exit(111);
}

stralloc line = {0};

substdio sscdb;
char sscdbbuf[1024];

stralloc data = {0};

struct cdbmake cdbm;
char packbuf[8];

void main(argc,argv)
int argc;
char **argv;
{
  int match;
  int colon;
  int where;
  int left;
  char *fntemp;
  char *fn;
  int fd;
  int i;
  uint32 h;
  uint32 pos;
  uint32 len;
  uint32 u;
  char ch;

  fn = argv[1];
  if (!fn) usage();
  fntemp = argv[2];
  if (!fntemp) usage();

  cdbmake_init(&cdbm);

  fd = open_trunc(fntemp);
  if (fd == -1) die_create();
  if (seek_set(fd,(seek_pos) sizeof(cdbm.final)) == -1) die_write();
  pos = sizeof(cdbm.final);

  substdio_fdbuf(&sscdb,write,fd,sscdbbuf,sizeof(sscdbbuf));

  for (;;) {
    if (getline2(subfdin,&line,&match,'\n') == -1) die_read();
    if (!match)
      break;

    if (line.s[0] == '#') continue;

    colon = byte_chr(line.s,line.len,':');
    if (colon == line.len) continue;

    if (!stralloc_copys(&data,"")) die_nomem();

    where = colon + 1;
    left = line.len - where;

    while (left) {
      ch = line.s[where + (left - 1)];
      if (ch != '\n') if (ch != ' ') if (ch != '\t') break;
      --left;
    }

    if ((left >= 4) && !byte_diff(line.s + where,4,"deny")) {
      if (!stralloc_catb(&data,"D",2)) die_nomem();
      where += 4;
      left -= 4;
    }
    else if ((left >= 5) && !byte_diff(line.s + where,5,"allow")) {
      where += 5;
      left -= 5;
    }
    else
      die_bad();

    while (left)
      switch(line.s[where]) {
	case ',':
	  i = byte_chr(line.s + where,left,'=');
	  if (i == left) die_bad();
	  if (!stralloc_catb(&data,"+",1)) die_nomem();
	  if (!stralloc_catb(&data,line.s + where + 1,i)) die_nomem();
	  where += (i + 1);
	  left -= (i + 1);
	  if (!left) die_bad();
	  ch = line.s[where];
	  where += 1;
	  left -= 1;
	  i = byte_chr(line.s + where,left,ch);
	  if (i == left) die_bad();
	  if (!stralloc_catb(&data,line.s + where,i)) die_nomem();
	  if (!stralloc_0(&data)) die_nomem();
	  where += i + 1;
	  left -= i + 1;
	  break;
	default:
	  die_bad();
      }

    cdbmake_pack(packbuf,(uint32) colon);
    cdbmake_pack(packbuf + 4,(uint32) data.len);
    if (substdio_put(&sscdb,packbuf,8) == -1) die_write();
    if (substdio_put(&sscdb,line.s,colon) == -1) die_write();
    if (substdio_put(&sscdb,data.s,data.len) == -1) die_write();

    h = CDBMAKE_HASHSTART;
    for (i = 0;i < colon;++i)
      h = cdbmake_hashadd(h,(int) line.s[i]);

    if (!cdbmake_add(&cdbm,h,pos,alloc)) die_nomem();

    pos += 8 + colon + data.len;
  }

  if (!cdbmake_split(&cdbm,alloc)) die_nomem();

  for (i = 0;i < 256;++i) {
    len = cdbmake_throw(&cdbm,pos,i);
    for (u = 0;u < len;++u) {
      cdbmake_pack(packbuf,cdbm.hash[u].h);
      cdbmake_pack(packbuf + 4,cdbm.hash[u].p);
      if (substdio_put(&sscdb,packbuf,8) == -1) die_write();
      pos += 8;
    }
  }

  if (substdio_flush(&sscdb) == -1) die_write();
  if (seek_begin(fd) == -1) die_write();
  if (substdio_putflush(&sscdb,cdbm.final,sizeof(cdbm.final)) == -1) die_write();
  if (fsync(fd) == -1) die_write();
  if (close(fd) == -1) die_write(); /* NFS stupidity */

  if (rename(fntemp,fn)) die_rename();

  _exit(0);
}
