#include "substdio.h"
#include "subfd.h"
#include "alloc.h"
#include "env.h"
#include "str.h"
#include "fmt.h"
#include "open.h"
#include "readwrite.h"
#include "exit.h"
#include "cdb.h"

void usage() {
  substdio_putsflush(subfderr,"tcpcontrol: usage: tcpcontrol rules.cdb subprogram [ args ... ]\n");
  _exit(1);
}

void die_nomem() {
  substdio_putsflush(subfderr,"tcpcontrol: fatal: out of memory\n");
  _exit(111);
}

void die_open() {
  substdio_putsflush(subfderr,"tcpcontrol: fatal: unable to open rules file\n");
  _exit(111);
}

void die_read() {
  substdio_putsflush(subfderr,"tcpcontrol: fatal: unable to read rules file\n");
  _exit(111);
}

char *fnrulescdb;
int fd;

char *tcplocalhost;
char *tcplocalip;
char *tcplocalport;
char *tcpremotehost;
char *tcpremoteip;
char *tcpremoteport;
char *tcpremoteinfo; /* could be 0 */

int flagdeny = 0;

char *report;
unsigned int reportlen;

unsigned int fmtsafe(s,t)
char *s;
char *t;
{
  unsigned int len;
  char ch;
  len = 0;
  if (s)
    while (ch = t[len]) {
      if (ch < 33) ch = '?';
      if (ch > 126) ch = '?';
      if (ch == '%') ch = '?'; /* logger stupidity */
      if (ch == ':') ch = '?';
      s[len++] = ch;
    }
  else
    while (t[len])
      ++len;
  return len;
}

unsigned int fmtlog(s)
char *s;
{
  unsigned int len;
  unsigned int i;
  len = 0;
  i = fmt_str(s,"tcpcontrol: "); if (s) s += i; len += i;
  i = fmt_str(s,flagdeny ? "deny " : "ok "); if (s) s += i; len += i;
  i = fmt_ulong(s,(unsigned long) getpid()); if (s) s += i; len += i;
  i = fmt_str(s," "); if (s) s += i; len += i;
  i = fmtsafe(s,tcplocalhost); if (s) s += i; len += i;
  i = fmt_str(s,":"); if (s) s += i; len += i;
  i = fmtsafe(s,tcplocalip); if (s) s += i; len += i;
  i = fmt_str(s,":"); if (s) s += i; len += i;
  i = fmtsafe(s,tcplocalport); if (s) s += i; len += i;
  i = fmt_str(s," "); if (s) s += i; len += i;
  i = fmtsafe(s,tcpremotehost); if (s) s += i; len += i;
  i = fmt_str(s,":"); if (s) s += i; len += i;
  i = fmtsafe(s,tcpremoteip); if (s) s += i; len += i;
  i = fmt_str(s,":"); if (s) s += i; len += i;
  i = fmtsafe(s,tcpremoteinfo ? tcpremoteinfo : ""); if (s) s += i; len += i;
  i = fmt_str(s,":"); if (s) s += i; len += i;
  i = fmtsafe(s,tcpremoteport); if (s) s += i; len += i;
  i = fmt_str(s,"\n"); if (s) s += i; len += i;
  return len;
}

int findrule(key,keylen)
char *key;
unsigned int keylen;
{
  char *data;
  uint32 dlen32;
  unsigned int datalen;
  unsigned int next0;
  int r;

  r = cdb_seek(fd,key,keylen,&dlen32);
  datalen = dlen32;
  if (r == -1) die_read();

  if (r == 1) {
    data = alloc(datalen);
    if (!data) die_nomem();
    if (cdb_bread(fd,data,datalen) != 0) die_read();

    while ((next0 = byte_chr(data,datalen,0)) < datalen) {
      switch(data[0]) {
	case 'D':
	  flagdeny = 1;
	  break;
	case '+':
	  if (!env_put(data + 1)) die_nomem();
	  break;
      }
      data += (next0 + 1);
      datalen -= (next0 + 1);
    }

    return 1;
  }
  return 0;
}

void checkrules()
{
  unsigned int i;
  char *infoatip;

  if (tcpremoteinfo) {
    i = str_len(tcpremoteinfo) + str_len(tcpremoteip) + 2;
    infoatip = alloc(i);
    if (!infoatip) die_nomem();
    i = fmt_str(infoatip,tcpremoteinfo);
    i += fmt_str(infoatip + i,"@");
    i += fmt_str(infoatip + i,tcpremoteip);

    if (findrule(infoatip,i)) return;
  }

  i = str_len(tcpremoteip);
  if (findrule(tcpremoteip,i)) return;
  while (i > 0)
    if (tcpremoteip[--i] == '.')
      if (findrule(tcpremoteip,i + 1)) return;

  if (findrule("",0)) return;
}

void main(argc,argv)
int argc;
char **argv;
{
  if (!argv[1]) usage();
  if (!argv[2]) usage();

  fnrulescdb = argv[1];

  fd = open_read(fnrulescdb);
  if (fd == -1) die_open();

  tcplocalhost = env_get("TCPLOCALHOST");
  if (!tcplocalhost) tcplocalhost = "";
  tcplocalip = env_get("TCPLOCALIP");
  if (!tcplocalip) tcplocalip = "?.?.?.?";
  tcplocalport = env_get("TCPLOCALPORT");
  if (!tcplocalport) tcplocalport = "?";

  tcpremotehost = env_get("TCPREMOTEHOST");
  if (!tcpremotehost) tcpremotehost = "";
  tcpremoteip = env_get("TCPREMOTEIP");
  if (!tcpremoteip) tcpremoteip = "?.?.?.?";
  tcpremoteport = env_get("TCPREMOTEPORT");
  if (!tcpremoteport) tcpremoteport = "?";

  tcpremoteinfo = env_get("TCPREMOTEINFO");

  checkrules();

  reportlen = fmtlog(FMT_LEN);
  report = alloc(reportlen);
  if (!report) die_nomem();
  fmtlog(report);

  substdio_putflush(subfderr,report,reportlen);

  if (flagdeny) _exit(3);

  execvp(argv[2],argv + 2);
  substdio_putsflush(subfderr,"tcpcontrol: fatal: unable to run subprogram\n");
  _exit(111);
}
