/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
static char *sccsid = "@(#)cmd2.c	1.2 (Ames) 12/10/87";
#endif not lint

#include "rcv.h"
#include <sys/stat.h>
#include <errno.h>

head(argc, argv)
char **argv;
{
	return read_head(argc, argv, 1);
}

read_msg(argc, argv)
char **argv;
{
	return read_head(argc, argv, 0);
}

read_head(argc, argv, ishead)
char **argv;
{
	int mesg;	/* message number */

	if (!logged_on) {
		printf("- Logon with HELO first\r\n");
		return (-1);
	}
	if (state == WAIT_FOR_ACK) {
		printf("- waiting for ACKS, ACKD, or NACK\r\n");
		return (-1);
	}
	if (argc > 1) {
		mesg = atoi(argv[1]);
		if (mesg <= 0 || mesg > msgCount) {
			printf("- Invalid message number.\r\n");
			return (-1);
		}
		dot = &message[mesg-1];
	}
	if (dot == NULL || dot->m_flag & MDELETED)
		printf("=0 no messages\r\n");
	else if (ishead) {
		printf("=%d charcters in header %d\r\n",
		    dot->m_hsize + dot->m_hlines -
		    (unixfrom ? 0 : (dot->m_fromsize + 1)),
		    dot - message + 1);
		state = RETR_HEAD;
	} else {
		printf("=%d charcters in message %d\r\n",
		    dot->m_size + dot->m_lines -
		    (unixfrom ? 0 : (dot->m_fromsize + 1)),
		    dot - message + 1);
		state = RETR_BODY;
	}
	return 0;
}

#ifdef notdef
/*
 * Save/copy the indicated messages at the end of the passed file name.
 * If mark is true, mark the message "saved."
 */
save1(str, mark)
	char str[];
{
	register int *ip, mesg;
	register struct message *mp;
	char *file, *disp, *cmd;
	int f, *msgvec, lc, t;
	long cc;
	FILE *obuf;
	struct stat statb;

	cmd = mark ? "save" : "copy";
	msgvec = (int *) salloc((msgCount + 2) * sizeof *msgvec);
	if ((file = snarf(str, &f)) == NOSTR)
		return(1);
	if (!f) {
		*msgvec = first(0, MMNORM);
		if (*msgvec == NULL) {
			printf("No messages to %s.\n", cmd);
			return(1);
		}
		msgvec[1] = NULL;
	}
	if (f && getmsglist(str, msgvec, 0) < 0)
		return(1);
	if ((file = expand(file)) == NOSTR)
		return(1);
	printf("\"%s\" ", file);
	if (stat(file, &statb) >= 0)
		disp = "[Appended]";
	else
		disp = "[New file]";
	if ((obuf = fopen(file, "a")) == NULL) {
		perror(NOSTR);
		return(1);
	}
	cc = 0L;
	lc = 0;
	for (ip = msgvec; *ip && ip-msgvec < msgCount; ip++) {
		mesg = *ip;
		mp = &message[mesg-1];
		if ((t = send(mp, obuf, 0)) < 0) {
			perror(file);
			fclose(obuf);
			return(1);
		}
		lc += t;
		cc += mp->m_size;
		if (mark)
			mp->m_flag |= MSAVED;
	}
	fflush(obuf);
	if (ferror(obuf))
		perror(file);
	fclose(obuf);
	printf("%s %d/%ld\n", disp, lc, cc);
	return(0);
}
#endif

/*
 * Go to next message.
 */

acks(argc, argv)
char **argv;
{
	if (!logged_on) {
		printf("- Logon with HELO first\r\n");
		return (-1);
	}
	if (state != WAIT_FOR_ACK) {
		printf("- RETR messages first.\r\n");
		return (-1);
	}
	if ((dot->m_flag & MREAD) == 0)
		dot->m_flag |= MREAD|MSTATUS;
	return next_msg();
}

/*
 * Delete messages.
 */

ackd(argc, argv)
char **argv;
{
	int msgvec[2];

	if (!logged_on) {
		printf("- Logon with HELO first\r\n");
		return (-1);
	}
	if (argc != 1) {
		puts("- Invalid number of arguments.\r");
		return -1;
	}
	if (state != WAIT_FOR_ACK) {
		printf("- RETR messages first.\r\n");
		return (-1);
	}
	msgvec[0] = dot - &message[0] + 1;
	msgvec[1] = 0;
	(void) delm(msgvec);
	return next_msg();	/* Go to next message. */
}

dele(argc, argv)
char **argv;
{
	register i;
	int buf[2];
	register *msgvec = buf;

	if (!logged_on) {
		puts("- Logon with HELO first\r");
		return (-1);
	}
	if (argc > 1) {
		register i;

		msgvec = (int *)alloca(argc * sizeof (int));
		argv++; argc--;
		for (i = 0; i < argc; i++) {
			msgvec[i] = atoi(argv[i]);
			if (msgvec[i] == 0) {
				printf("- Invalid argument.\r\n");
				return (-1);
			}
			if (msgvec[i] <= 0 || msgvec[i] > msgCount) {
				printf("- %d: invalid message number\r\n",
				    msgvec[i]);
				return -1;
			}
		}
		msgvec[i] = 0;
	} else {
		if (msgCount == 0) {
			puts("- no messages\r");
			return -1;
		}
		msgvec[0] = dot - &message[0] + 1;
		msgvec[1] = 0;
	}
	if (delm(msgvec)) {
		puts("- message(s) not deleted\r");
		return -1;
	} else {
		puts("+ message(s) deleted\r");
		return 0;
	}
}

/*
 * Set dot to next message.
 */
next_msg()
{
	int msgnum;	/* The real message number - 1 */

	msgnum = dot - &message[0];
	do {
		if (++msgnum >= msgCount) {
			printf("=0 no more messages\r\n");
			state = 0;
			return 0;
		}
		dot++;
	} while (dot->m_flag & MDELETED);
	printf("=%d characters in message %d\r\n",
	    dot->m_size + dot->m_lines, msgnum + 1);
	state = RETR_BODY;
	return 0;
}

nack(argc, argv)
char **argv;
{
	if (!logged_on) {
		printf("- Logon with HELO first\r\n");
		return (-1);
	}
	if (state != WAIT_FOR_ACK) {
		printf("- not expecting NACK\r\n");
		return (-1);
	}
	if (dot->m_flag & MDELETED)	/* Last message. */
		printf("=0\r\n");
	else
		printf("=%d charcters in message %d\r\n",
		    dot->m_size + dot->m_lines -
		    (unixfrom ? 0 : (dot->m_fromsize + 1)),
		    dot - message + 1);
	state = RETR_BODY;	/* Try it again. */
	return 0;
}

/*
 * Delete the indicated messages.
 * Leave dot alone.
 * Internal interface.  Assumes all messages in msgvec are valid.
 */

delm(msgvec)
	int *msgvec;
{
	register struct message *mp;
	register *ip, mesg;

	for (ip = msgvec; *ip != NULL; ip++) {
		mesg = *ip;
		mp = &message[mesg-1];
		mp->m_flag |= MDELETED|MTOUCH;
		mp->m_flag &= ~(MPRESERVE|MSAVED|MBOX);
	}

	return(0);
}

undel(argc, argv)
char **argv;
{
	register i;
	int buf[2];
	register *msgvec = buf;

	if (!logged_on) {
		puts("- Logon with HELO first\r");
		return (-1);
	}
	if (argc > 1) {
		register i;

		msgvec = (int *)alloca(argc * sizeof (int));
		argv++; argc--;
		for (i = 0; i < argc; i++) {
			msgvec[i] = atoi(argv[i]);
			if (msgvec[i] == 0) {
				printf("- Invalid argument.\r\n");
				return (-1);
			}
			if (msgvec[i] <= 0 || msgvec[i] > msgCount) {
				printf("- %d: invalid message number\r\n",
				    msgvec[i]);
				return -1;
			}
		}
		msgvec[i] = 0;
	} else {
		if (msgCount == 0) {
			puts("- no messages\r");
			return -1;
		}
		msgvec[0] = dot - &message[0] + 1;
		msgvec[1] = 0;
	}
	if (undelete(msgvec)) {
		puts("- message(s) not recovered\r");
		return -1;
	} else {
		puts("+ message(s) recovered\r");
		return 0;
	}
}

/*
 * Undelete the indicated messages.
 */

undelete(msgvec)
	int *msgvec;
{
	register struct message *mp;
	register *ip;

	for (ip = msgvec; *ip; ip++) {
		mp = &message[*ip-1];
		dot = mp;
		mp->m_flag &= ~MDELETED;
	}
	return 0;
}
