/*
pop3d.c 1.10 10/6/92
	An implementation of RFC 1081 for use on regular /usr/spool/mail
	format mail files.

	Written by W. Gregg Stefancik (wstef@eng.clemson.edu)
*/

static char *sccs_id = "@(#)pop3d.c	1.10 (wstef@eng.clemson.edu) 10/6/92";

#include "pop3d.h"

int server_state;
struct passwd *pw_ptr;

struct cmd_parms cmd_tab[] = 
{
  { "bad",BAD_CMD,0,CMDAT_NUL },	/* invalid command */
  { "user",USER_CMD,1,CMDAT_STR },	/* USER valid AUTH_STATE */
  { "pass",PASS_CMD,1,CMDAT_STR },	/* PASS valid AUTH_STATE */
  { "stat",STAT_CMD,0,CMDAT_NUL },	/* STAT valid TRANS_STATE */
  { "list",LIST_CMD,-1,CMDAT_NUM},	/* LIST valid TRANS_STATE */
  { "retr",RETR_CMD,1,CMDAT_NUM },	/* RETR valid TRANS_STATE */
  { "dele",DELE_CMD,1,CMDAT_NUM },	/* DELE valid TRANS_STATE */
  { "noop",NOOP_CMD,0,CMDAT_NUL },	/* NOOP valid TRANS_STATE */
  { "last",LAST_CMD,0,CMDAT_NUL },	/* LAST valid TRANS_STATE */
  { "rset",RSET_CMD,0,CMDAT_NUL },	/* RSET valid TRANS_STATE */
  { "rpop",RPOP_CMD,1,CMDAT_STR },	/* RPOP valid AUTH_STATE */
  { "top", TOP_CMD, -2,CMDAT_NUM },	/* TOP valid TRANS_STATE */
  { "quit",QUIT_CMD,0,CMDAT_NUL },	/* QUIT valid AUTH_STATE, TRANS_STATE */
  { (char *)NULL,BAD_CMD,0,CMDAT_NUL }	/* end of table marker */
};

int con_sock;
FILE *con_stream;
int debug=FALSE;
char remote_host[100];

main(argc, argv)
int argc;
char **argv;
{
  /* very simple parse down of command line args */
  if(argc > 1)				/* do we have some args? */
  {
    if(strcmp(argv[1],"-d") == NULL)	/* did we get the debug flag? */
      debug=TRUE;
    if(!debug || argc > 2)		/* no debug or to many args, BARF! */
    {
      fprintf(stderr,"Usage: %s [-d]\n",argv[0]);
      exit(1);
    }
  }

  /* get the connection */
  get_connection();

}

int pop3_server()
{
  char user[10], passwd[10], host[256];
  char arg[2][100];
  int done=FALSE,cmd,auths_failed=0, zapped();
  struct hostent *hp;

  pw_ptr=NULL;
  signal(SIGTERM,zapped);
  signal(SIGPIPE,zapped);

  /* get offical local host name */
  strcpy(host,"noname");
  if(gethostname(host,sizeof(host)) != -1) /* snarf the host name */
    if((hp = gethostbyname(host)) != NULL)
      strcpy(host,hp->h_name);

  /* say hello */
  send_ok("%s POP3D %s by wstef@eng.clemson.edu",host,version);

  server_state=AUTH_STATE;
  do
  {
    if((cmd=get_toke(arg)) < 0)
    {
      /* network connection must have died */
      if(server_state == TRANS_STATE)
      {
	/* clean up if in TRANS_STATE */
	free_mail_entries();
	close(tmp_mbox_fd);
	unlink(tmp_mbox_name);
        free(tmp_mbox_name);
	unlock_popbox(pw_ptr->pw_name);
      }
      return(-1);
    }
    if(debug)
      fprintf(stderr,"pop3_server: state=%d  token=%d\n",server_state,cmd);
    switch(server_state)
    {
      case AUTH_STATE:
	switch(cmd)
	{
	  case BAD_CMD:
	    break;
	  case USER_CMD:
	    if((pw_ptr=getpwnam(arg[0])) == NULL)
	    {
	      send_err("%s doesn't get his mail here",arg[0]);
	      break;
	    }
	    send_ok("%s gets mail here",arg[0]);
	    break;
	  case PASS_CMD:
	    if(pw_ptr == NULL)
	    {
	      send_err("i need a USER");
	      break;
	    }
	    if(strcmp(pw_ptr->pw_passwd,crypt(arg[0],pw_ptr->pw_passwd))!=NULL)
	    {
	      if(++auths_failed > 2)
	      {
		/* put some security logging in here */
		syslog(SECLOG_PRI,
		 "repeated authorization failures from %s user %s",
		  remote_host,pw_ptr->pw_name);
		send_err("too many authorization attempts.  disconnecting.");
		return(0); /* force disconnect */
	      }
	      send_err("invalid password");
	      pw_ptr = NULL;
	      break;
	    }
	    if(!lock_popbox(pw_ptr->pw_name))
	    {
	      send_err("can't lock maildrop");
	      pw_ptr = NULL;
	      break;
	    }
	    if(!read_mailbox(pw_ptr->pw_name))
	    {
	      send_err("can't read mailbox");
	      unlock_popbox(pw_ptr->pw_name);
	      pw_ptr = NULL;
	      break;
	    }
	    send_ok("mailbox locked and ready");
	    server_state=TRANS_STATE;
	    break;
	  case QUIT_CMD:
	    send_ok("%s POP3D connection terminated",host);
	    done=TRUE;
	    break;
	  case RPOP_CMD:
	    send_err("command not implemented");
	    break;
	  default:
            send_err("invalid command");
	    break;
	}
	break;
      case TRANS_STATE:
	switch(cmd)
	{
	  case BAD_CMD:
	    break;
	  case STAT_CMD:
	    send_ok("%d %d",cur_msgs,cur_size);
	    break;
	  case LIST_CMD:
	    if(*arg[0] == '\0')
	      list_all();
	    else
              list_msg(atoi(arg[0]));
	    break;
	  case RETR_CMD:
	    retreve_msg(atoi(arg[0]),-1);
	    break;
	  case DELE_CMD:
	    delete_msg(atoi(arg[0]));
	    break;
	  case NOOP_CMD:
	    send_ok("i did nothing");
	    break;
	  case LAST_CMD:
	    send_ok("%d",last_msg_rd);
	    break;
	  case RSET_CMD:
	    reset_mailbox();
	    break;
	  case TOP_CMD:
	    if(*arg[1] == '\0')
	      retreve_msg(atoi(arg[0]),10);
	    else
	      retreve_msg(atoi(arg[0]),atoi(arg[1]));
	    break;
	  case QUIT_CMD:
            /* ignore signals while updating mbox and leaving */
            signal(SIGTERM,SIG_IGN);
            signal(SIGPIPE,SIG_IGN);

	    if(update_mailbox(pw_ptr->pw_name))
	      send_ok("%s POP3D connection terminated",host);
	    else
	      send_err("could not update mailbox.  connection terminated");
	    unlock_popbox(pw_ptr->pw_name);
	    done=TRUE;
	    break;
	  default:
            send_err("invalid command");
	    break;
	}
	break;
    }
  } while(!done);
  return(0);
}

int get_toke(arg)
char arg[2][100];
{
  char cmdl[4][100];
  char inline[100],*cp;
  int match, token, ma, i;

  for(match = -1;match == -1;)
  {
    *cmdl[0]='\0';
    *cmdl[1]='\0';
    *cmdl[2]='\0';
    *cmdl[3]='\0';
    if(get_line(inline) == NULL)
    {
      if(debug)
        fprintf(stderr,"get_toke: error getting line from connection\n");
      return(-1);
    }
    if((match=sscanf(inline,"%s%s%s%s",cmdl[0],cmdl[1],cmdl[2],cmdl[3])) > 3)
    {
      send_err("too many arguments");
      return(BAD_CMD);
    }
  }
  if(debug)
    fprintf(stderr,"get_toke: got(%d) '%s' '%s' '%s'\n",match,cmdl[0],cmdl[1],
     cmdl[2]);
  if((token=cmdl_to_toke(cmdl[0])) == BAD_CMD)
  {
    send_err("non-existant command");
    return(token);
  }
  match--;
  if(cmd_tab[token].cmdp_args < 0)
  {
    ma = 0 - cmd_tab[token].cmdp_args;
    if(match < ma-1 || match > ma)
    {
      send_err("arguments mismatch");
      return(BAD_CMD);
    }
  }
  else
  {
    if(cmd_tab[token].cmdp_args != match)
    {
      send_err("arguments mismatch");
      return(BAD_CMD);
    }
  }
  if(cmd_tab[token].cmdp_atype == CMDAT_NUM)
    for(i=match; i > 0; i--)
      for(cp=cmdl[i]; *cp != '\0'; cp++)
        if(!isdigit(*cp))
	{
  	  send_err("argument must a positive integer");
	  return(BAD_CMD);
	}
  strcpy(arg[0],cmdl[1]);
  strcpy(arg[1],cmdl[2]);
  if(debug)
    fprintf(stderr,"get_toke: returning %d as token\n",token);
  return(token);
}

cmdl_to_toke(cmdl)
char *cmdl;
{
  char *cp;
  int i;

  /* convert the command to lower case */
  for(cp=cmdl; *cp != '\0'; cp++)
    if(isupper(*cp))
      *cp = tolower(*cp);
  for(i=0; cmd_tab[i].cmdp_str != NULL; i++)
    if(strcmp(cmd_tab[i].cmdp_str,cmdl) == NULL)
      break;
  return(cmd_tab[i].cmdp_cmd);
}

char *get_line(line)
char *line;
{
  char *ptr;

  if((ptr=fgets(line,100,con_stream)) == NULL)
    return(ptr);
  if((ptr=index(line,'\r')) != NULL)
    *ptr = '\0';
  if((ptr=index(line,'\n')) != NULL)
    *ptr = '\0';
  return(line);
}

send_ok(va_alist)
va_dcl
{
  char n_fmt[256],out[512];
  int stat;
  va_list ap;

  va_start(ap);
  sprintf(n_fmt,"+OK %s\r\n",va_arg(ap,char *));
  vsprintf(out,n_fmt,ap);
  stat=write(con_sock,out,strlen(out));
  va_end(list);
  return(stat);
}

send_err(va_alist)
va_dcl
{
  char n_fmt[256],out[512];
  int stat;
  va_list ap;

  va_start(ap);
  sprintf(n_fmt,"-ERR %s\r\n",va_arg(ap,char *));
  vsprintf(out,n_fmt,ap);
  stat=write(con_sock,out,strlen(out));
  va_end(ap);
  return(stat);
}

#ifdef STANDALONE

/* Establishes connections in standalone mode */
get_connection()
{
  int svr_sock, n;
  int process, reaper();
  struct servent *svc_ptr;
  struct sockaddr_in svr_addr;
  int client_len, flag;
  struct hostent *hp;
  struct sockaddr_in client_addr;

  if(debug)
    setbuf(stderr,NULL);
  else
  {
    if(fork())  /* zap off into the background */
       exit(0);
    for (n = 0; n<10; n++)  /* disassociate from controlling tty */
      close(n);
    open("/dev/null", O_RDONLY);
    dup2(0,1);
    dup2(0,2);
#if defined(hpux)
    /*
     * setsid will give me a new session w/o any tty associated at all
     */
    setsid();
#else
    /*
     * TIOCNOTTY will get rid of my tty & set my pgrp to 0
     */
    if((n=open("/dev/tty",O_RDWR)) > 0)
    {
      ioctl(n, TIOCNOTTY, 0) ;
      close(n) ;
    }
#endif /* hpux */
    signal(SIGCHLD, reaper);
  }

  OPENLOG("pop3d",LOG_PID,LOG_DAEMON);

  if((svr_sock = socket(AF_INET,SOCK_STREAM,0)) < 0)
  {
    syslog(LOG_WARNING,"error creating server socket (%d).\n",errno);
    exit(1);
  }

  if((svc_ptr=getservbyname("pop-3","tcp")) != NULL)
    svr_addr.sin_port=svc_ptr->s_port;
  else
    svr_addr.sin_port=htons(DEFAULT_POP3_PORT);

  svr_addr.sin_family=AF_INET;
  svr_addr.sin_addr.s_addr=INADDR_ANY;
  if(bind(svr_sock,&svr_addr,sizeof(svr_addr)) < 0)
  {
    syslog(LOG_WARNING,"can't bind socket (%d).\n",errno);
    exit(1);
  }
  if(listen(svr_sock,1) < 0)
  {
    syslog(LOG_WARNING,"can't listen (%d).\n",errno);
    exit(1);
  }
  while(TRUE)
  {
    client_len=sizeof(client_addr);
    if((con_sock=accept(svr_sock,&client_addr,&client_len))< 0)
    {
      if(errno != EINTR)
	syslog(LOG_WARNING,"accept failed errno %d",errno);
      continue;
    }
    /* see who is knocking on the door */
    if((hp=gethostbyaddr(&client_addr.sin_addr,sizeof(struct sockaddr_in),
     AF_INET)) == NULL)
      strcpy(remote_host,inet_ntoa(client_addr.sin_addr));
    else
      strcpy(remote_host,hp->h_name);
    if(debug)
      process=0; /* if we are debugging don't fork */
    else
      process=fork();
    if(process == 0)
    {
      flag=TRUE;
      if(setsockopt(con_sock,SOL_SOCKET,SO_KEEPALIVE,&flag,sizeof(flag)))
      {
	if(debug)
	  fprintf(stderr,"can't set keepalive option.\n");
	exit(1);
      }
      if(debug)
        fprintf(stderr,"connection from %s remote port %d\n",remote_host,
         ntohs(client_addr.sin_port));
      if((con_stream=fdopen(con_sock,"r")) == NULL)
      {
	if(debug)
          fprintf(stderr,"couldn't assoicate a stream with the socket\n");
        exit(1);
      }
      close(svr_sock);
      pop3_server();
      fclose(con_stream);
      close(con_sock);
      closelog();
      exit(0);
    }
    close(con_sock);
  }
}

reaper()
{
  union wait status;

  while(wait3(&status,WNOHANG,(struct rusage *)0) > 0);
}

#else

/* Establishes connections for inetd mode */
get_connection()
{
  int client_len, flag;
  struct hostent *hp;
  struct sockaddr_in client_addr;

  /* Not all systems pass fd's 1 and 2 from inetd */

  (void) close(1);
  (void) close(2);
  (void) dup(0);
  (void) dup(0);
  con_sock = 0;
  con_stream = stdin;
  
  OPENLOG("pop3d",LOG_PID,LOG_DAEMON);

  /* see who is knocking on the door */
  client_len=sizeof(client_addr);
  if(getpeername(con_sock,&client_addr,&client_len) < 0)
  {
    if(debug)
      fprintf(stderr,"Could not get address of client\n");
    exit(1);
  }
  if((hp=gethostbyaddr(&client_addr.sin_addr,sizeof(struct sockaddr_in),
   AF_INET)) == NULL)
    strcpy(remote_host,inet_ntoa(client_addr.sin_addr));
  else
    strcpy(remote_host,hp->h_name);

  flag=TRUE;
  if(setsockopt(con_sock,SOL_SOCKET,SO_KEEPALIVE,&flag,sizeof(flag)))
  {
    if(debug)
      fprintf(stderr,"can't set keepalive option.\n");
     exit(1);
  }
  if(debug)
    fprintf(stderr,"connection from %s remote port %d\n",remote_host,
     ntohs(client_addr.sin_port));

  pop3_server();

  fclose(con_stream);
  close(con_sock);
  closelog();
}
#endif

zapped()
{
  /* network connection must have died */
  if(pw_ptr)
    unlock_popbox(pw_ptr->pw_name);
  if(tmp_mbox_fd > -1)
  {
    close(tmp_mbox_fd);
    unlink(tmp_mbox_name);
    free(tmp_mbox_name);
  }
  exit(1);
}
