
/*
 * add.c -- Concatenate the string "s2" onto the end
 *       -- of string "s1".  Then free "s1".
 *
 * $Id$
 */

#include <h/mh.h>

char *
add (char *s2, char *s1)
{
    char *cp;
    size_t len1, len2;

    if (!s1)
	s1 = "";
    if (!s2)
	s2 = "";

    len1 = strlen (s1);
    len2 = strlen (s2);

    if (!(cp = malloc (len1 + len2 + 1)))
	adios (NULL, "unable to allocate string storage");

    memcpy (cp, s1, len1);
    memcpy (cp + len1, s2, len2);
    cp[len1 + len2] = '\0';

    if (*s1)
	free (s1);
    return cp;
}
