
/*
 * seq_add.c -- add message(s) to a sequence
 *
 * $Id$
 */

#include <h/mh.h>


/*
 * Add all the SELECTED messages to a
 * (possibly new) sequence.
 */

int
seq_addsel (struct msgs *mp, char *cp, int public, int zero)
{
    int i, msgnum;
    int new_seq = 1;

    if (!seq_nameok (cp))
	return 0;

    /*
     * keep mp->curmsg and msgattrs["cur"] in sync - see seq_list()
     */
    if (!strcmp (current,cp))
	mp->curmsg = mp->hghsel;

    if (public == -1)
	public = !(mp->msgflags & READONLY);

    /* see if sequence already exists for this folder */
    for (i = 0; mp->msgattrs[i]; i++) {
	if (!strcmp (mp->msgattrs[i], cp)) {
	    new_seq = 0;
	    break;
	}
    }

    if (i >= NUMATTRS) {
	advise (NULL, "only %d sequences allowed (no room for %s)!", NUMATTRS, cp);
	return 0;
    }

    /* If this is a new sequence, add a slot for it */
    if (new_seq) {
	mp->msgattrs[i] = getcpy (cp);
	mp->msgattrs[i + 1] = NULL;
    }

    /*
     * If sequence is new, or zero flag is set, then first
     * clear the bit for this sequence from all messages.
     */
    if (new_seq || zero) {
	for (msgnum = mp->lowmsg; msgnum <= mp->hghmsg; msgnum++)
	    clear_sequence (mp, i, msgnum);
    }

    /*
     * Now flip on the bit for this sequence
     * for all selected messages.
     */
    for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++)
	if (is_selected (mp, msgnum))
	    add_sequence (mp, i, msgnum);

    if (public)
	make_seq_public (mp, i);
    else
	make_seq_private (mp, i);

    mp->msgflags |= SEQMOD;

    return 1;
}


/*
 * Add a message to a (possibly new) sequence.
 */

int
seq_addmsg (struct msgs *mp, char *cp, int msgnum, int public, int zero)
{
    int i, k;
    int new_seq = 1;

    if (!seq_nameok (cp))
	return 0;

    /*
     * keep mp->curmsg and msgattrs["cur"] in sync - see seq_list()
     */
    if (!strcmp (current,cp))
	mp->curmsg = msgnum;	

    if (public == -1)
	public = !(mp->msgflags & READONLY);

    /* see if sequence already exists for this folder */
    for (i = 0; mp->msgattrs[i]; i++) {
	if (!strcmp (mp->msgattrs[i], cp)) {
	    new_seq = 0;
	    break;
	}
    }

    if (i >= NUMATTRS) {
	advise (NULL, "only %d sequences allowed (no room for %s)!", NUMATTRS, cp);
	return 0;
    }

    /* If this is a new sequence, add a slot for it */
    if (new_seq) {
	mp->msgattrs[i] = getcpy (cp);
	mp->msgattrs[i + 1] = NULL;
    }

    /*
     * If sequence is new, or zero flag is set, then first
     * clear the bit for this sequence from all messages.
     */
    if (new_seq || zero) {
	for (k = mp->lowmsg; k <= mp->hghmsg; k++)
	    clear_sequence (mp, i, k);
    }

    /*
     * Now flip on the bit for this sequence
     * for this particular message.
     */
    add_sequence (mp, i, msgnum);

    if (public)
	make_seq_public (mp, i);
    else
	make_seq_private (mp, i);

    mp->msgflags |= SEQMOD;

    return 1;
}
