
/*
 * folder_delmsgs.c -- "remove" SELECTED messages from a folder
 *
 * $Id$
 */

#include <h/mh.h>

int
folder_delmsgs (struct msgs *mp, int rename_msgs)
{
    pid_t pid;
    int msgnum, vecp;
    char buf[100], *dp, **vec;

    for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++) {
	if (is_selected (mp, msgnum)) {
	    mp->msgstats[msgnum] &= ~EXISTS;
#if 0
	    mp->msgstats[msgnum] |= DELETED;
#endif
	}
    }
    mp->msgflags |= SEQMOD;

    /* If "rmmproc" is defined, use it to remove messages */
    if (rmmproc) {
	if (mp->numsel > MAXARGS - 2)
	    adios (NULL, "more than %d messages for %s exec", MAXARGS - 2,
		   rmmproc);
	vec = (char **) calloc ((size_t) (mp->numsel + 2), sizeof(*vec));
	if (vec == NULL)
	    adios (NULL, "unable to allocate exec vector");
	vecp = 1;
	for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++)
	    if (is_selected (mp, msgnum))
		vec[vecp++] = getcpy (m_name (msgnum));
	vec[vecp] = NULL;

	fflush (stdout);
	vec[0] = r1bindex (rmmproc, '/');

	switch (pid = vfork()) {
	case NOTOK:
	    advise ("fork", "unable to");
	    return NOTOK;

	case OK:
	    execvp (rmmproc, vec);
	    fprintf (stderr, "unable to exec ");
	    perror (rmmproc);
	    _exit (-1);

	default:
	    return (pidwait (pid, NOTOK));
	}
    }

    /* Either rename or unlink the SELECTED messages */
    for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++) {
	if (is_selected (mp, msgnum)) {
	    dp = m_name (msgnum);
	    if (rename_msgs) {
		/* rename messages with standard prefix */
		strcpy (buf, m_backup (dp));
		if (rename (dp, buf) == NOTOK)
		    admonish (buf, "unable to rename %s to", dp);
	    } else {
		/* or just unlink the selected messages */
		if (unlink (dp) == NOTOK)
		    admonish (dp, "unable to unlink");
	    }
	}
    }
}

