
/*
 * mhpath.c -- print full pathnames of nmh messages and folders
 *
 * $Id$
 */

#include <h/mh.h>

static struct swit switches[] = {
#define VERSIONSW 0
    { "version", 0 },
#define	HELPSW	1
    { "help", 4 },
    { NULL, 0 }
};


main(int argc, char **argv)
{
    int msgp = 0, i;
    char *cp, *maildir, *folder = NULL, buf[100];
    char **ap, **argp, *arguments[MAXARGS], *msgs[MAXARGS];
    struct msgs *mp;

#ifdef LOCALE
    setlocale(LC_ALL, "");
#endif
    invo_name = r1bindex (argv[0], '/');
    if ((cp = m_find (invo_name)) != NULL) {
	ap = brkstring (cp = getcpy (cp), " ", "\n");
	ap = copyip (ap, arguments);
    }
    else
	ap = arguments;
    copyip (argv + 1, ap);
    argp = arguments;

    while ((cp = *argp++)) {
	if (*cp == '-')
	    switch (smatch (++cp, switches)) {
		case AMBIGSW: 
		    ambigsw (cp, switches);
		    done (1);
		case UNKWNSW: 
		    adios (NULL, "-%s unknown", cp);

		case HELPSW: 
		    sprintf (buf, "%s [+folder] [msgs] [switches]", invo_name);
		    print_help (buf, switches);
		    done (1);
		case VERSIONSW:
		    print_version(invo_name);
		    done (1);
	    }
	if (*cp == '+' || *cp == '@') {
	    if (folder)
		adios (NULL, "only one folder at a time!");
	    else
		folder = path (cp + 1, *cp == '+' ? TFOLDER : TSUBCWF);
	}
	else
	    msgs[msgp++] = cp;
    }

    if (!m_find ("path"))
	free (path ("./", TFOLDER));

    if (!folder)
	folder = m_getfolder ();
    maildir = m_maildir (folder);

    /* If no messages are given, print folder pathname */
    if (!msgp) {
	printf ("%s\n", maildir);
	done (0);
    }

    if (chdir (maildir) == NOTOK)
	adios (maildir, "unable to change directory to");

    /* read folder and create message structure */
    if (!(mp = m_gmsg (folder)))
	adios (NULL, "unable to read folder %s", folder);

    if ((mp = m_remsg (mp, 0, MAXFOLDER)) == NULL)
	adios (NULL, "unable to allocate folder storage");

    mp->msgflags |= MHPATH;

    /* parse all the message ranges/sequences and set SELECTED */
    for (i = 0; i < msgp; i++)
	if (!m_convert (mp, msgs[i]))
	    done (1);

    m_setseq (mp);	/* set the previous-sequence */

    if (mp->numsel > MAXARGS - 2)
	adios (NULL, "more than %d messages", MAXARGS - 2);

    for (i = mp->lowsel; i <= mp->hghsel; i++)
	if (is_selected (mp, i))
	    printf ("%s/%s\n", mp->foldpath, m_name (i));

    m_sync (mp);
    m_fmsg (mp);	/* free folder/message structure */
    m_update ();	/* update the context file       */
    done (0);
}
