
/*
 * mh.h -- main header file for all of nmh
 *
 * $Id$
 */

#include <h/nmh.h>

/*
 * Well-used constants
 */
#define	NOTOK        (-1)	/* syscall()s return this on error */
#define	OK             0	/*  ditto on success               */
#define	DONE           1	/* trinary logic                   */
#define ALL           ""
#define	Nbby           8	/* number of bits/byte */

#define MAXARGS	    1000	/* max arguments to exec                */
#define NFOLDERS     300	/* max folder arguments on command line */
#define DMAXFOLDER     4	/* typical number of digits             */

#ifndef	UCI
# define MAXFOLDER  1000	/* message increment */
#else
# define MAXFOLDER  1500	/* message increment */
#endif

/*
 * profile structure
 */
struct node {
    char *n_name;		/* key                  */
    char *n_field;		/* value                */
    char  n_context;		/* context, not profile */
    struct node *n_next;	/* next entry           */
};

/*
 * switches structure
 */
#define	AMBIGSW	 (-2)	/* from smatch() on ambiguous switch */
#define	UNKWNSW	 (-1)	/* from smatch() on unknown switch   */

struct swit {
    char *sw;
    int minchars;
};

extern struct swit anoyes[];	/* standard yes/no switches */

/*
 * messages structure
 */

/*
 * msgstats[] is a int, so we have 16 or 32 bits to work
 * with.  The first 5 are for standard nmh message flags,
 * this leaves us 11 (or 27) for user-defined attributes.
 * Of these, 1 is reserved for future internal use, so
 * this leaves users 10 (or 26).
 */
#define	NUMATTRS  ((sizeof(int) * Nbby) - 6)

/* folder attributes */
#define READONLY  (1<<0)	/* No write access to folder    */
#define	SEQMOD	  (1<<1)	/* folder's sequences modifed   */
#define	MHPATH	  (1<<2)	/* mhpath-style folder handling */
#define	OTHERS	  (1<<3)	/* folder has other files	*/
#define	MODIFIED  (1<<4)	/* msh in-core folder modified  */

#define	FBITS "\020\01READONLY\02SEQMOD\03MHPATH\04OTHERS\05MODIFIED"

/* messages attributes */
#define EXISTS        (1<<0)	/* exists            */
#define DELETED       (1<<1)	/* deleted           */
#define SELECTED      (1<<2)	/* selected for use  */
#define SELECT_EMPTY  (1<<3)	/* mhpath "new"      */
#define	UNSEEN        (1<<4)	/* inc/show "unseen" */

/*
 * first free attribute slot for user-defined attributes
 */
#define	FFATTRSLOT  5

/*
 * first free slot is (1 << 5) or 0x20
 */
#define	MBITS "\020\01EXISTS\02DELETED\03SELECTED\04NEW\05UNSEEN"

struct msgs {
    int hghmsg;		/* Highest msg in directory     */
    int nummsg;		/* Actual Number of msgs        */
    int lowmsg;		/* Lowest msg number            */
    int curmsg;		/* Number of current msg if any */
    int lowsel;		/* Lowest selected msg number   */
    int hghsel;		/* Highest selected msg number  */
    int numsel;		/* Number of msgs selected      */
    char *foldpath;	/* Pathname of folder           */
    int msgflags;	/* Folder status bits           */

#ifndef	MTR
    char pad1[sizeof(int) - sizeof(char)];
#endif /* not MTR */

    char *msgattrs[NUMATTRS + 1]; /* folder attributes          */
    int attrstats;		  /* public = 0, private = 1    */
    int	lowoff;			  /* low element in msgstats[]  */
    int	hghoff;			  /* hgh element in msgstats[]  */

#ifndef	MTR
    int msgstats[1];		/* msg status */
#else
    int *msgbase;		/* msg base   */
    int *msgstats;		/* msg status */
#endif
};

#ifndef	MTR
# define MHSIZE(mp,lo,hi)  ((size_t) (sizeof(*mp) + ((hi) + 2) * sizeof(*mp->msgstats)))
#else
# define MHSIZE(mp,lo,hi)  ((size_t) sizeof(*mp))
# define MHSIZEX(mp,lo,hi) ((size_t) (((hi) - (lo) + 1) * sizeof(*mp->msgstats)))
#endif

#define	NULLMP	((struct msgs *) 0)

/*
 * m_getfld() message parsing
 */

#define NAMESZ  128		/* Limit on component name size    */

#define LENERR  (-2)		/* Name too long error from getfld */
#define FMTERR  (-3)		/* Message Format error            */
#define FLD      0		/* Field returned                  */
#define FLDPLUS  1		/* Field " with more to come       */
#define FLDEOF   2		/* Field " ending at eom           */
#define BODY     3		/* Body  " with more to come       */
#define BODYEOF  4		/* Body  " ending at eom           */
#define FILEEOF  5		/* Reached end of input file       */

/*
 * Maildrop styles
 */
#define	MS_DEFAULT	0	/* default (one msg per file) */
#define	MS_UNKNOWN	1	/* type not known yet         */
#define	MS_MBOX		2	/* Unix-style "from" lines    */
#define	MS_MMDF		3	/* string mmdlm2              */
#define	MS_MSH		4	/* whacko msh                 */

extern int msg_count;		/* m_getfld() indicators */
extern int msg_style;		/*  .. */
extern char *msg_delim;		/*  .. */

#define	NOUSE	0		/* draft being re-used */

#define TFOLDER 0		/* path() given a +folder */
#define TFILE   1		/* path() given a file    */
#define	TSUBCWF	2		/* path() given a @folder */

#define OUTPUTLINELEN	72	/* default line length for headers */

/*
 * miscellaneous macros
 */
#define	pidXwait(id,cp)	pidstatus (pidwait (id, NOTOK), stdout, cp)
#define min(a,b) ((a) < (b) ? (a) : (b))
#define abs(a) ((a) > 0 ? (a) : -(a))

/*
 * GLOBAL VARIABLES
 */
#define CTXMOD	0x01		/* context information modified */
#define	DBITS	"\020\01CTXMOD"
extern char ctxflags;

#ifdef	OVERHEAD
extern int fd_def;
extern int fd_ctx;
#endif /* OVERHEAD */

extern char *invo_name;		/* command invocation name    */
extern char *mypath;		/* user's $HOME               */
extern char *defpath;		/* pathname of user's profile */
extern char *ctxpath;		/* pathname of user's context */
extern struct node *m_defs;	/* profile/context structure  */

/*
 * These standard strings are defined in config.c.  They are the
 * only system-dependent parameters in nmh, and thus by redefining
 * their values and reloading the various modules, nmh will run
 * on any system.
 */
extern char *components;
extern char *context;
extern char *current;
extern char *defalt;
extern char *digestcomps;
extern char *distcomps;
extern char *draft;
extern char *faceproc;
extern char *fileproc;
extern char *foldprot;
extern char *forwcomps;
extern char *inbox;
extern char *incproc;
extern char *installproc;
extern char *lproc;
extern char *mailproc;
extern char *mh_defaults;
extern char *mh_profile;
extern char *mh_seq;
extern char *mhlformat;
extern char *mhlforward;
extern char *mhlproc;
extern char *moreproc;
extern char *msgprot;
extern char *mshproc;
extern char *nsequence;
extern char *packproc;
extern char *postproc;
extern char *pfolder;
extern char *psequence;
extern char *rcvdistcomps;
extern char *rcvstoreproc;
extern char *replcomps;
extern char *rmfproc;
extern char *rmmproc;
extern char *sendproc;
extern char *showproc;
extern char *slocalproc;
extern char *sysed;
extern char *usequence;
extern char *version;
extern char *vmhproc;
extern char *whatnowproc;
extern char *whomproc;

#include <h/prototypes.h>

