
/*
 * m_getdefs.c -- read the user's nmh environment
 *
 * $Id$
 */

#include <h/mh.h>
#include <errno.h>
#include <pwd.h>

extern int errno;

#ifndef	OVERHEAD
# define FOpen(f,m,e,c) fopen (f, m)
# define FClose(f) fclose (f)
#else	/* OVERHEAD */
static FILE *FOpen ();
static int FClose ();
#endif	/* OVERHEAD */


void
m_getdefs(void)
{
    pid_t pid;
    register char *cp, *pp;
    char buf[BUFSIZ];
    struct stat st;
    register struct passwd *pw;
    register FILE *ib;

    if (defpath)
	return;
    if (!mypath) {
	if ((mypath = getenv ("HOME")))
	    mypath = getcpy (mypath);
	else
	    if ((pw = getpwuid (getuid ())) == NULL
		    || pw->pw_dir == NULL
		    || *pw->pw_dir == 0)
		adios (NULL, "no HOME envariable");
	    else
		mypath = getcpy (pw->pw_dir);
	if ((cp = mypath + strlen (mypath) - 1) > mypath && *cp == '/')
	    *cp = 0;
    }

    if ((cp = getenv ("MH")) && *cp) {
	defpath = path (cp, TFILE);
	if ((ib = FOpen (defpath, "r", "MHFD", 0)) == NULL)
	    adios (defpath, "unable to read");
	if (*cp != '/')
	    m_putenv ("MH", defpath);
    }
    else {
	defpath = concat (mypath, "/", mh_profile, NULL);

	if ((ib = FOpen (defpath, "r", "MHFD", 0)) == NULL)
	    switch (pid = vfork ()) {
		case NOTOK:
		    adios ("fork", "unable to");

		case OK:
		    setgid (getgid ());
		    setuid (getuid ());

		    execlp (installproc, "install-mh", "-auto", NULL);
		    fprintf (stderr, "unable to exec ");
		    perror (installproc);
		    _exit (-1);

		default:
		    if (pidwait (pid, OK)
			    || (ib = fopen (defpath, "r")) == NULL)
			adios (NULL, "[install-mh aborted]");
	    }
    }

    m_readefs (&m_defs, ib, mh_profile, 0);
    FClose (ib);

    if ((pp = m_find ("path")) != NULL && *pp) {
	if (*pp != '/')
	    sprintf (buf, "%s/%s", mypath, pp);
	else
	    strcpy (buf, pp);
	if (stat(buf, &st) == NOTOK) {
	    if (errno != ENOENT)
		adios (buf, "error opening");
	    cp = concat ("Your MH-directory \"", buf,
		"\" doesn't exist; Create it? ", NULL);
	    if (!getanswer(cp))
		adios (NULL, "unable to access MH-directory \"%s\"", buf);
	    free (cp);
	    if (!makedir (buf))
		adios (NULL, "unable to create", buf);
	}
    }

    if ((cp = getenv ("MHCONTEXT")) == NULL || *cp == 0)
	cp = context;
    if ((ib = FOpen (ctxpath = getcpy (m_maildir (cp)), "r", "MHCONTEXTFD", 1))
		== NULL) {
    }
    else {
	m_readefs ((struct node **) 0, ib, cp, 1);
	FClose (ib);
    }
}


#ifdef OVERHEAD
int fd_def = NOTOK;
int fd_ctx = NOTOK;


static FILE *
FOpen (char *filename, char *mode, char *envariable, int ctx)
{
    register int fd;
    register char *cp;
    char buffer[10];
    struct stat st1;
    register FILE * fp;

    if ((cp = getenv (envariable)) == NULL || *cp == 0)
	goto not_open;

    if ((fd = atoi (cp)) <= fileno (stderr)) {
	advise (NULL, "bad value for $%s: %s", envariable, cp);
	unputenv (envariable);
	return fopen (filename, mode);
    }
    if (ctx)
	fd_ctx = fd;
    else
	fd_def = fd;

    if (fstat (fd, &st1) == NOTOK) {
not_open: ;
	if ((fp = fopen (filename, mode))
		&& !strcmp (mode, "r")
		&& fileno (fp) > fileno (stderr)) {
	    sprintf (buffer, "%d", fileno (fp));
	    if (!m_putenv (envariable, buffer))
		if (ctx)
		    fd_ctx = fileno (fp);
		else
		    fd_def = fileno (fp);
	}

	if ((cp = getenv ("MHFDEBUG")) && *cp)
	    fprintf (stderr, "FOpen of %s sets %d\n", filename, fileno (fp));
	return fp;
    }

    lseek (fd, (off_t)0, 0);
    return fdopen (fd, mode);
}


static int
FClose (FILE *f)
{
    register int d1, d2, i;
    register char  *cp;

    if (f == NULL)
	return OK;

    if ((d1 = fileno (f)) != fd_def && d1 != fd_ctx)
	return fclose (f);

    d2 = dup (d1);
    i = fclose (f);

    if (d2 != NOTOK) {
	dup2 (d2, d1);
	close (d2);
    }
    else
	if (d1 == fd_def)
	    fd_def = NOTOK;
	else
	    fd_ctx = NOTOK;

    if ((cp = getenv ("MHFDEBUG")) && *cp)
	fprintf (stderr, "FClose emulating close of %d (%d)\n", d1, d2);
    return i;
}
#endif /* OVERHEAD */
