
/*
 * rcvstore.c -- asynchronously incorporate new mail
 *
 * $Id$
 */

#include <h/mh.h>
#include <errno.h>
#include <signal.h>

static struct swit switches[] = {
#define CRETSW         0
    { "create",	0 },
#define NCRETSW        1
    { "nocreate", 0 },
#define PUBSW          2
    { "public",	0 },
#define NPUBSW         3
    { "nopublic",  0 },
#define SEQSW          4
    { "sequence name", 0 },
#define ZEROSW         5
    { "zero",	0 },
#define NZEROSW        6
    { "nozero",	0 },
#define VERSIONSW      7
    { "version", 0 },
#define HELPSW         8
    { "help", 4 },
    { NULL, 0 }
};

extern int errno;

static char *tmpfilenam = NULL;


main (int argc, char **argv)
{
    int publicsw = -1, zerosw = 0, msgnum;
    int create = 1, fd, seqp = 0;
    char *cp, *maildir, *folder = NULL, buf[100];
    char **ap, **argp, *arguments[MAXARGS], *seqs[NUMATTRS+1];
    struct msgs *mp;
    struct stat st;

#ifdef LOCALE
	setlocale(LC_ALL, "");
#endif
    invo_name = r1bindex (argv[0], '/');
    mts_init (invo_name);
    if ((cp = m_find (invo_name))) {
	ap = brkstring (cp = getcpy (cp), " ", "\n");
	ap = copyip (ap, arguments);
    }
    else
	ap = arguments;
    copyip (argv + 1, ap);
    argp = arguments;

    while ((cp = *argp++)) {
	if (*cp == '-')
	    switch (smatch (++cp, switches)) {
		case AMBIGSW: 
		    ambigsw (cp, switches);
		    done (1);
		case UNKWNSW: 
		    adios (NULL, "-%s unknown", cp);

		case HELPSW: 
		    sprintf (buf, "%s [+folder] [switches]", invo_name);
		    print_help (buf, switches);
		    done (1);
		case VERSIONSW:
		    print_version(invo_name);
		    done (1);

		case SEQSW: 
		    if (!(cp = *argp++) || *cp == '-')
			adios (NULL, "missing argument name to %s",
				argp[-2]);
		    if (seqp < NUMATTRS)
			seqs[seqp++] = cp;
		    else
			adios (NULL, "only %d sequences allowed!", NUMATTRS);
		    continue;
		case PUBSW: 
		    publicsw = 1;
		    continue;
		case NPUBSW: 
		    publicsw = 0;
		    continue;
		case ZEROSW: 
		    zerosw++;
		    continue;
		case NZEROSW: 
		    zerosw = 0;
		    continue;

		case CRETSW: 
		    create++;
		    continue;
		case NCRETSW: 
		    create = 0;
		    continue;
	    }
	if (*cp == '+' || *cp == '@') {
	    if (folder)
		adios (NULL, "only one folder at a time!");
	    else
		folder = path (cp + 1, *cp == '+' ? TFOLDER : TSUBCWF);
	}
	else
	    adios (NULL, "usage: %s [+folder] [switches]", invo_name);
    }

    if (!m_find ("path"))
	free (path ("./", TFOLDER));
    if (!folder && !(folder = m_find (inbox)))
	folder = defalt;
    maildir = m_maildir (folder);

    if (stat (maildir, &st) == NOTOK) {
	if (errno != ENOENT)
	    adios (maildir, "error on folder");
	if (!create)
	    adios (NULL, "folder %s doesn't exist", maildir);
	if (!makedir (maildir))
	    adios (NULL, "unable to create folder %s", maildir);
    }

    if (chdir (maildir) == NOTOK)
	adios (maildir, "unable to change directory to");
    if (!(mp = m_gmsg (folder)))
	adios (NULL, "unable to read folder %s", folder);

    signal (SIGHUP, SIG_IGN);
    signal (SIGINT, SIG_IGN);
    signal (SIGQUIT, SIG_IGN);
    signal (SIGTERM, SIG_IGN);

    tmpfilenam = m_scratch ("", invo_name);
    if ((fd = creat (tmpfilenam, m_gmprot ())) == NOTOK)
	adios (tmpfilenam, "unable to create");
    chmod (tmpfilenam, m_gmprot ());

    cpydata (fileno (stdin), fd, "standard input", tmpfilenam);

    if (fstat (fd, &st) == NOTOK) {
	unlink (tmpfilenam);
	adios (tmpfilenam, "unable to fstat");
    }
    if (close (fd) == NOTOK)
	adios (tmpfilenam, "error closing");
    if (st.st_size == 0) {
	unlink (tmpfilenam);
	advise (NULL, "empty file");
	done (0);
    }

    msgnum = mp->hghmsg;
    do {
	msgnum++;
	mp->hghmsg++;
	if (msgnum > mp->hghoff)
	    if (!(mp = m_remsg (mp, 0, mp->hghoff + MAXFOLDER)))
		adios (NULL, "unable to allocate folder storage");

	mp->msgstats[msgnum] |= EXISTS | UNSEEN;
	errno = 0;
    } while (link (tmpfilenam, m_name (msgnum)) == NOTOK && errno == EEXIST);

    unlink (tmpfilenam);
    tmpfilenam = NULL;
    if (errno != 0)
	adios (NULL, "can't file message %d", msgnum);

    if (mp->lowmsg == 0)
	mp->lowmsg = msgnum;
    mp->msgflags |= SEQMOD;

    seqs[seqp] = NULL;
    for (seqp = 0; seqs[seqp]; seqp++) {
	if (zerosw && !m_seqnew (mp, seqs[seqp], publicsw))
	    done (1);
	if (!m_seqadd (mp, seqs[seqp], msgnum, publicsw))
	    done (1);
    }

    m_setvis (mp, 0);
    m_sync (mp);
    m_update ();

    done (0);
}

void
done(int status)
{
    if (tmpfilenam && *tmpfilenam)
	unlink (tmpfilenam);
    exit (status);
}
