.\"
.\" %nmhwarning%
.\" $Id$
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH FLIST %manext1% MH.6.7 [%nmhversion%]
.SH NAME
flist \- list folders with unseen messages
.SH SYNOPSIS
.in +.5i
.ti -.5i
flist
\%[\-all]
\%[\-unseen]
\%[\-alpha] \%[\-noalpha]
\%[\-recurse] \%[\-norecurse]
\%[\-total] \%[\-nototal]
\%[\-version]
\%[\-help]

.in -.5i
.SH DESCRIPTION
This program lists those folders that contain messages in the unseen
sequence.  This is especially useful if you use some mechanism such
as \fIslocal\fP or \fIprocmail\fP (usually in conjunction with
\fIrcvstore\fP) to pre-sort your mail into different folders before you
view it.

\fIFlist\fR will list all folders, or just those folders with unseen
messages (this is the default), and for each one the number of messages
that are in the unseen sequence and the total number of messages.
An example of the output is:

.nf
.if t .in +.5i
.ta \w'/rnd/phyl/Mail/EP 'u +\w'ddd 'u +\w'new out of 'u +\w'ddd 'u
+inbox	9	new out of	117
+junklist	3	new out of	72
.re
.if t .in -.5i
.fi

Specifying `\-all' will produce a line for each folder in the user's nmh
directory, or list all folders under the user's nmh directory recursively
(with `\-recurse').

A `\-nototal' switch will produce only the number of unseen messages,
and suppress the total number of messages in the folder.

The sorting order for the listing is alphabetical (with '\-alpha'),
or in a priority order defined by the Folder-Order profile entry
(with '\-noalpha').  Each item in the Folder-Order is a folder name
or a folder name pattern that uses * to match zero or more characters.
Longer matching patterns have precedence over shorter matching patterns.
For example:
.nf
Folder-Order: personal petproject mh* * admin *junk
.fi
This order puts a few interesting folders first, such as those with mail
addressed to you personally, those about a pet project, and those about
mh-related things.  It shoves uninteresting folders to the end, and it
puts everything else in the middle in alphabetical order.
.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
.Pr
^Path:~^To determine the user's nmh directory
.Ps
^Unseen-Sequence:~^The name of the unseen message sequence
.Ps
^Folder-Order:~^To sort folders by priority
.Sa
folder(1), procmail(1), rcvstore(1), slocal(1)
.De
`\-unseen'
.Ds
`\-noalpha'
.Ds
`\-total'
.Ds
`\-norecurse'
.En
