.\" -*-nroff-*-
.\" Process this file with
.\" groff -man -Tascii mutt.1
.\"
.TH mutt 1 "JULY 1998" Unix "User Manuals"
.SH NAME
mutt \- The Mutt Mail User Agent
.SH SYNOPSIS
mutt [-hnpRvxyzZ]
[-a \fIfile\fP]
[-b \fIaddress\fP]
[-c \fIaddress\fP]
[-e \fIcommand\fP]
[-f \fImailbox\fP]
[-F \fImuttrc\fP]
[-H \fIdraftfile\fP]
[-i \fIinclude\fP]
[-m \fItype\fP]
[-s \fIsubject\fP]
.SH DESCRIPTION
Mutt is a small but very powerful text based program for reading electronic
mail under unix operating systems, including support color terminals, MIME,
and a threaded sorting mode.
.SH OPTIONS
.IP "-a \fIfile\fP"
Attach a file to your message using MIME.
.IP "-b \fIaddress\fP"
Specify a blind-carbon-copy (BCC) recipient
.IP "-c \fIaddress\fP"
Specify a carbon-copy (CC) recipient
.IP "-e \fIcommand\fP"
Specify a configuration command to be run after processing of initialization
files.
.IP "-f \fImailbox\fP"
Specify which mailbox to load.
.IP "-F \fImuttrc\fP"
Specify an initialization file to read instead of ~/.muttrc
.IP "-h"
Display help.
.IP "-H \fIdraft\fP"
Specify a draft file which contains header and body to use to send a
message.
.IP "-i \fIinclude\fP"
Specify a file to include into the body of a message.
.IP "-m \fItype\fP       "
specify a default mailbox type
.IP "-n"
Causes Mutt to bypass the system configuration file.
.IP "-p"
Resume a postponed message.
.IP "-R"
Open a mailbox in \fIread-only\fP mode.
.IP "-s \fIsubject\fP"
Specify the subject of the message.
.IP "-v"
Display the Mutt version number and compile-time definitions.
.IP "-x"
Emulate the mailx compose mode.
.IP "-y"
Start Mutt with a listing of all mailboxes specified by the \fImailboxes\fP
command.
.IP "-z"
When used with -f, causes Mutt not to start if there are no messages in the
mailbox.
.IP "-Z"
Causes Mutt to open the first mailbox specified by the \fImailboxes\fP
command which contains new mail.
.SH ENVIRONMENT
.IP "EDITOR"
Editor to invoke when composing a message.
.IP "HOME"
Full path of the user's home directory.
.IP "MAIL"
Full path of the user's spool mailbox.
.IP "MAILCAPS"
Path to search for mailcap files.
.IP "MM_NOASK"
If this variable is set, mailcap are always used without prompting first.
.IP "PGPPATH"
Directory in which the user's PGP public keyring can be found.
.IP "TMPDIR"
Directory in which temporary files are created.
.IP "REPLYTO"
Default Reply-To address.
.IP "VISUAL"
Editor to invoke when the ~v command is given in the builtin editor.
.SH FILES
.IP "~/.muttrc"
User configuration file.
.IP "/usr/local/share/Muttrc"
System-wide configuration file.
.IP "/tmp/muttXXXXXX"
Temporary files created by Mutt.
.IP "~/.mailcap"
User definition for handling non-text MIME types.
.IP "/usr/local/share/mailcap"
System definition for handing non-text MIME types.
.IP "~/.mime.types"
User's personal mapping between MIME types and file extensions.
.IP "/usr/local/share/mime.types"
System mapping between MIME types and file extensions.
.SH BUGS
Suspend/resume while editing a file with an external editor does not work
under SunOS 4.x if you use the curses lib in /usr/5lib.  It \fIdoes\fP work
with the S-Lang library, however.

Resizing the screen while using an external pager causes Mutt to go haywire
on some systems.

suspend/resume does not work under Ultrix.

The help line for the index menu is not updated if you change the bindings
for one of the functions listed while Mutt is running.
.SH SEE ALSO
.BR curses (3),
.BR ncurses (3),
.BR sendmail (1),
.BR smail (1),
.BR mailcap (5)

Mutt Home Page: http://www.cs.hmc.edu/~me/mutt/
.SH AUTHOR
Michael Elkins <me@cs.hmc.edu>

http://www.cs.hmc.edu/~me/
