/*
 * Copyright (C) 2001 Thomas Roessler <roessler@does-not-exist.org>
 * 
 *     This program is free software; you can redistribute it
 *     and/or modify it under the terms of the GNU General Public
 *     License as published by the Free Software Foundation; either
 *     version 2 of the License, or (at your option) any later
 *     version.
 * 
 *     This program is distributed in the hope that it will be
 *     useful, but WITHOUT ANY WARRANTY; without even the implied
 *     warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *     PURPOSE.  See the GNU General Public License for more
 *     details.
 * 
 *     You should have received a copy of the GNU General Public
 *     License along with this program; if not, write to the Free
 *     Software Foundation, Inc., 59 Temple Place - Suite 330,
 *     Boston, MA  02111, USA.
 */ 

#ifndef _GLOBAL_H
# define _GLOBAL_H

# ifdef MAIN_C
#  define WHERE 
#  define INITVAL(x) = x
# else
#  define WHERE extern
#  define INITVAL(x) 
# endif

# include "libpisock/pi-source.h"
# include "libpisock/pi-socket.h"
# include "libpisock/pi-dlp.h"
# include "libpisock/pi-mail.h"

# include <time.h>

/* data types */

struct context
{
  /* where we talk to the palm */
  int			sd;	/* socket descriptor */
  int			db;	/* database descriptor */
  
  /* palm state */
  struct MailAppInfo 	*app_info;
  struct MailSyncPref 	*sync_pref;
  struct MailSignaturePref
    			*signature;
  struct PilotUser	*user;
  
  /* flags */
  unsigned		sd_valid : 1;
  unsigned		db_valid : 1;
};

typedef struct context CONTEXT;

enum disp_t
{
  DISP_DELETE, DISP_FILE, DISP_KEEP
};

struct options
{
  char 			*port;
  char 			*charset;
  char			*sendmail;
  char			*from;
  char			*path;
  enum disp_t		dispose;
};

typedef struct options OPTIONS;


/* global variables */

WHERE CONTEXT Context;
WHERE OPTIONS Opt;

# ifdef MAIN_C
const char *Weekdays[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
const char *Months[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "ERR" };
# else
extern const char *Weekdays[];
extern const char *Months[];
# endif

/* prototypes */

void pm_destroy_context (void);
void pm_setup_context (const char *);
void pm_send_mail (void);

time_t pm_parse_date (const char *);

/* more prototypes */

# include "lib.h"

#endif
