/*
 * mesh.h -- include file for MADE Email Shell
 *
 * 2-18-93   weber@eitech.com added splitsize field to message struct
 * 1-21-93   weber@eitech.com added to field to message struct
 * 27-Jun-92 weber@eitech.com marked ServiceMail(tm) v1.0
 * 25-May-92 weber@eitech.com created
 *
 * Copyright (c)  1992 Enterprise Integration Technologies Corporation
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name of
 * Enterprise Integration Technologies Corporation may not be used in any 
 * advertising or publicity relating to the software without the specific, 
 * prior written permission of Enterprise Integration Technologies Corporation.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION  BE
 * LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF
 * ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
 * THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#define PROGRAM_NAME    "mesh"
#define PROGRAM_BLURB   "Invoke site-specific services on email messages"
#define PROGRAM_AUTHOR  "Jay C. Weber"
#define PROGRAM_OWNER   "Enterprise Integration Technologies"
#define PROGRAM_LICENSE "All rights reserved"
#define PROGRAM_VERSION "1.1"

#include <stdio.h>
#include <ctype.h>
#include <strings.h>
#ifdef FACILITY 
#include <syslog.h>
#endif

#define MAXLINELEN 1000
#define MAXFILENAMELEN 128
#define MAXPARTS 32
#define MAXCTPARAMETERS 16
#define MAXBOUNDARYLEN 70

struct MessageInfo {
	char *from;
	char *to;
	char *reply_to;
	char *id;
	char *date;
	char *subject;
	char *service;
	char *splitsize;
	struct {
		char *type;
		char *format;
		char *encoding;
		char *id;
		int numparms;
		struct {
			char *name;
			char *value;
		} parms[MAXCTPARAMETERS];
	} content;
	union {
		char fname[MAXFILENAMELEN];
		struct {
			unsigned numparts;
			struct MessageInfo **parts;
		} multipart;		
	} body;
};  
extern int logging,loglevel;
