# finger: an email finger gateway
#
# 4-93 weber@eitech.com rewrote to work with internet-wide addresses
# 8-92 salil@eitech.com created

proc fingerdone {envelope response} {
  set nl \n
  setfield response STRING [concat [getfield $response STRING] ".

------------------------------------------------------------------------------
You have sent electronic mail to a Multimedia E-mail SHell (MESH) server
based on the ServiceMail(tm) Toolkit from Enterprise Integration Technologies.

This server can field a number of different service requests, a list of
which can be obtained by requesting the 'services' service.  In general, users
request a service by placing its name in the Subject: line, followed by
any needed parameters.  The body of the message contains any needed input
files, expressed in MIME format (cf. Internet RFC 1341)"
]
  return [mailout [turnaround $envelope] $response];
}


proc finger {switches envelope inputs } {
  set tilde ~
  set slash /
  set user [lindex $switches 0];
  set project .project
  set plan .plan
  setfield response DESCRIPTION "Results of your finger request"

  set code [catch {exec egrep $user /etc/passwd} ]
  if {$code != 0} {
    setfield response STRING "No such user"
    fingerdone $envelope $response
  }
  if {[file exists [glob $tilde$user$slash$plan]]} {
    if {[file exists [glob $tilde$user$slash$project]]} {
      setfield response STRING [exec cat [glob $tilde$user$slash$project] [glob $tilde$user$slash$plan]];
    } else {
      setfield response STRING [exec cat [glob $tilde$user$slash$plan]];
    }
  } else {
    setfield response STRING "No information is available about this user"
  }
  fingerdone $envelope $response
}
    
