/* -*- C -*-
 *
 * Program:	ximap
 * File:        structures.h -- structures used in ximap.  Some of the structures
 *                              are to be found in the appropriate header file.
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#ifndef __ximap_structures_h
#define __ximap_structures_h

#include <Xb/Browser.h>
#include "mailcap.h"

typedef struct _XIMAP_RES {
  char           *default_host;
  char           *default_mailbox;
  char           *default_bcc;
  char           *default_cc;
  char           *personal_name;
  char           *mail_name;
  char           *mail_host;
  char           *indentPrefix;
  char           *printCommand;
  char           *smtpHost;
  int            serverPort;
  Pixmap         mail_empty;
  Pixmap         mail_full;
  Boolean        filter_headers;
  Boolean        highlight_new;
  Boolean        flag_all_mailboxes;
  Boolean        flag_no_mailboxes;
  int            initial_view;
  float          check_interval;
  Boolean        ring_bell_for_new;
  int            number_of_bells;
  int            line_length;
  int            insert_wrap_columns;
} AppResources;

typedef struct _MessageNode
{
    MESSAGECACHE *elt;
    BODY         *body;
    ENVELOPE     *env;

    int          msgno;
    char         *header_line;    /* header for browsers */

    char         *text;           /* text for display */
    char         *insert;         /* text for inserting into reply */
    char         *header;         /* rfc822 header for read windows */
    char         *filtered_head;  /* filtered header for read windows */
    char         *shortheader;    /* short header for forwarding */

    int          visible;
    int          locked;
    Boolean      found;
    Boolean      toMe;
    Boolean      changed;

    unsigned int status;          
    int          inzoom;	  /* true if in zoom browser */


} MessageNode, *MessageNodePtr;

typedef struct _NodeList
{
    MessageNode* *nodes;
    int         length;
} NodeList, *NodeListPtr;

typedef struct _SEARCHDATES 
{
    Widget                form;
    Widget                beforeText;
    Widget                onText;
    Widget                sinceText;
} SEARCHDATES;

typedef struct _SEARCHFLAGS 
{
    Widget      form;
    Widget      seenToggle;
    Widget      deletedToggle;
    Widget      recentToggle;
    Widget      answeredToggle;
    Widget      flaggedToggle;
    Widget      unseenToggle;
    Widget      undeletedToggle;
    Widget      unrecentToggle;
    Widget      unansweredToggle;
    Widget      unflaggedToggle;
} SEARCHFLAGS;

typedef struct _SEARCHWINDOW 
{
    struct _MailBox     *ms;
    struct _BrowserEntry   *be;

    struct _StateList *states;

    Widget         last_focus;
    Widget         shell;
    Widget         panes;
    Widget         controls;
    Widget         and_toggle;
    Widget         or_toggle;
    Widget         xor_toggle;
    SEARCHDATES    dates;
    SEARCHFLAGS    flags;
    Widget                form;
    Widget                fromText;
    Widget                toText;
    Widget                ccText;
    Widget                bccText;
    Widget                subjectText;
    Widget                bodyText;
    Widget                textText;
    Widget                keywordText;
} SEARCHWINDOW;

typedef struct _BrowserEntry
{
    struct _MailBox     *ms;

    Widget               shell;
    Widget               panes;
    Widget               info;
    Widget               buttons;
    Widget               browser;

    XbListSelectionPtr   currentMap;
    int                  *order;
    int                  size;

    Boolean              main;
    Boolean              redisplay;
    Boolean              active;
    struct _BrowserEntry *next;
    struct _BrowserEntry *prev;
    struct _StateList*            states;

    SEARCHWINDOW         *searchWin;
    char                 *currentFilter;
    int                  *found;

} BrowserEntry, *BrowserList;

typedef struct _MailBox
{
    MAILSTREAM    *mailbox;
    unsigned long status;
    char          *mailboxName;
    char*         host;
    
    MessageNode*  *messages;
    MessageNode*  *last_message;
    int          list_size;
    int          nmsgs;
    int          new;
    int          changedSize;
    int          nzoomed;
    
    MessageNode*  replyto;
    
    Widget       mailWindow;
    Widget       flagShell;
    Widget       mailboxFlag;
    Widget       keywords;
    
    BrowserList  browserList;

    struct read_window*    rwinList;
    struct compose_window* compList;

    XbListSelectionPtr  fauxMapping;    /* for debugging only */
    XbListSelectionPtr  defaultMapping;
    XbListSelectionPtr  zoomMapping;
    
    Display*     curdisplay;
    XtIntervalId timeout;
    XtWorkProcId background_proc;
    
    char         *lastcopy;
    
    int          first_header;
    int          actual_size;
    int          virtual_size;
    int          start_highlight;
    int          view;
    
    Boolean      filter_heads;
    Boolean      zoom;
    
    int          *found;
    int          num_found;
    int          num_expunged;
    Widget       *changing_buttons;
    Widget       *empty_box_buttons;
} MailBox;

typedef struct _STREAMARRAY
{
    struct _STREAMARRAY *prev;
    struct _STREAMARRAY *next;
    Boolean              login;
    Boolean              handle;
    MAILSTREAM          *stream;
    MailBox*              status;
} STREAMARRAY;

typedef struct _OPENHOSTS 
{
    struct _OPENHOSTS *next;
    char              *host;
    char              *name;
    char              *password;
    Boolean           loggedIn;
} OPENHOSTS;

typedef struct _MAILSESSION 
{
    OPENHOSTS      *hosts;
    char           *lasthost;
    int            no_boxes;
    STREAMARRAY*   mailboxes;
    MailBox*       activeCheck;
    MailBox*       activeLogin;
    AppResources   *sess_resources;
    char           *home_dir;
    char           *username;
    char           *localhost;
    HandlerArray   handlers;
} MAILSESSION;

#endif /* __ximap_structures_h */
