/* -*- C -*-
 *
 * Program:	ximap
 * File:        readwin.h -- Creating a read window and reading 
 *                           messages.
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#ifndef __ximap_readwin_h
#define __ximap_readwin_h

typedef struct body_stack
{
    int    gStackSize;
    int    gStackCapacity;
    BODY **gStackTop;
    BODY **gStackBottom;
} BodyStack;

typedef struct part_position
{
    int    gArraySize;
    int    gArrayCapacity;
    int   *gPositionArray;
    int   *gPositionArrayBottom;
} PartPosition;

typedef struct read_window
{
    struct _MailBox *ms;
    MAILHANDLE      *handle;

    MessageNode    **messages;
    MessageNode    **current;
    PART            *currpart;

    BodyStack       *bodystack;   /* This is used for navigating through multi-part messages... */
    PartPosition    *partposition;
    char            *currtext;
    int              nmsgs;
    char            *name;
    int              headerlen;
    Widget           shell;
    Widget           panes;
    Widget           buttons;
    Widget           part_buttons;

    Widget           text;         /*    The widget for displaying text            */

    Widget           dform;        /* The form in the display field.  It supports: */
    Widget           browser;      /*    The widget for displaying multipart       */
    Widget           panel_buttons;
    Widget           panel_label;
    
    int              user_height;
    int              set_height;

    Dimension        text_height;
    Boolean          filterHead;
    Boolean          rawText;
    
    StateList*          states;
    unsigned int        state;

    StateList*          panel_states;
    unsigned int        panel_state;
    struct read_window *next;

    unsigned long   status;
    XEvent         *artificialEvent;

    void           (*display)();
    void           (*change_text)();
    char*          (*current_text)();
} READWINDOW;

extern void        doRead();
extern READWINDOW* getRwinFromWidget();
extern READWINDOW* createReadWindow();
extern void        addReadWindowActions();

/* Read window specific buttons states. */
#define FIRSTMESSAGE   ((unsigned int) 1 << 1)
#define NOBODYPART     ((unsigned int) 1 << 2)
#define HASBODYPART    (~NOBODYPART)
#define TOPLEVEL       ((unsigned int) 1 << 3)
#define INMULTI        (~TOPLEVEL)
#define NOHANDLER      ((unsigned int) 1 << 4)
#define HASHANDLER     (~NOHANDLER)
#define NOENCODEDDATA  ((unsigned int) 1 << 5)
#define ENCODEDDATA    (~NOENCODEDDATA)
#define NOMIME         ((unsigned int) 1 << 6)

#endif /* __ximap_readwin_h */

