/* -*- C -*-
 *
 * Program:	ximap
 * File:        copywrap.c -- reformat text (for insert) 
 *
 * Author:      Mike macgirvin
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x231
 *		Stanford, CA 94305
 *		Internet: Mike_Macgirvin@CAMIS.Stanford.EDU
 *
 * Date:	16 November 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, 
 * AND IN NO EVENT SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER 
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF 
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF 
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>

#include <Client/osdep.h>
#include <Client/mail.h>
#include <Client/misc.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#ifdef MOTIF
#include <X11/Xm/Text.h>
#else
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Text.h>
#endif

#include "structures.h"
#include "message.h"
#include "globals.h"
#include "textutil.h"

extern AppResources res;

/*
 *
 * char * copywrap(char *);
 *
 *    Creates a copy of a text string which has been re-formatted
 * to a shorter(?) line length than the original.
 *    Used in the Compose Window "Insert Text" function to keep inserted
 * text (plus the indent string) to a smaller size than the display, enhancing
 * readability significantly.
 *    Not really perfect. Tries to re-format "paragraphs" from the original
 * while honoring paragraph breaks and premature linefeeds. Since any 
 * paragraphs have already been formatted with forced line-breaks, there 
 * are occasional mistakes made trying to figure out what a "paragraph" is. 
 *
 * Resources: insertWrapCol
 *    insertWrapCol == 0  (default)          Don't reformat
 *    insertWrapCol > MAXLINELENGTH (80)     Don't reformat
 *    insertWrapCol < MINWRAPCOLS   (35)     Don't reformat
 *
 */


char * 
copywrap(s)
     char * s;
{

  int wrapcols = res.insert_wrap_columns;
  int cnt = 0;
  int wrap = FALSE;
  int doubleline = FALSE;
  char * src = s;
  char * dst = NULL;
  char * temp = NULL;
  
  if(wrapcols == 0 || wrapcols < MINWRAPCOLS  || wrapcols > MAXLINELENGTH )
    return(cpystr(s));
  
  if(s == NULL || (temp = XtMalloc(strlen(s) + 1)) == NULL)
    return(NULL);
  dst = temp;

  while(*src != '\0') {
    cnt ++;
    switch(*src) {
    case SPACECHAR:
      if(((cnt + 1) + wordlen(src+1)) >= wrapcols) {
	  * dst = LFCHAR;
	  wrap = TRUE;
	  cnt = 0;
	  break;
	}
      else {
	*dst = *src;
	break;
      }
    case LFCHAR:
      if(wrap == FALSE) {
	*dst = *src;
	cnt = 0;
	break;
      }
      if(cnt >= wrapcols) {
	*dst = LFCHAR;
	wrap = FALSE;
	cnt = 0;
	break;
      }
      if(isspace(*(src+1)) || ispunct(*(src+1))) {
	*dst = *src;
	doubleline = TRUE;
	cnt = 0;
	break;
      }
      if(*(src+1) != LFCHAR && (doubleline == FALSE)) { 
	*dst = SPACECHAR;
	break;
      }
      else 
	doubleline = FALSE;
    default:
      *dst = *src;
      break;
    }
    src++; 
    dst++;
  }
  *dst = '\0';
  return(temp);
}



int wordlen(s)
     char *s;
{
  int cnt = 0;
  char * ptr = s;
  while((*ptr) && (!isspace(*ptr))) {
    ptr ++;
    cnt ++;
  }
  return(cnt);
}
